/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.material;

import io.github.phantamanta44.libnine.util.helper.OreDictUtils;
import net.minecraftforge.fml.common.Loader;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import xyz.phanta.tconevo.TconEvoConfig;

public interface RegCondition {
    public boolean isSatisfied();

    public static class MaterialCanOverride
    implements RegCondition {
        private final String matId;

        public MaterialCanOverride(String matId) {
            this.matId = matId;
        }

        @Override
        public boolean isSatisfied() {
            return TconEvoConfig.overrideMaterials || TinkerRegistry.getMaterial((String)this.matId) == Material.UNKNOWN;
        }
    }

    public static class MaterialVisible
    implements RegCondition {
        private final Material[] materials;

        public MaterialVisible(Material[] materials) {
            this.materials = materials;
        }

        @Override
        public boolean isSatisfied() {
            for (Material material : this.materials) {
                if (material.isHidden()) continue;
                return true;
            }
            return false;
        }
    }

    public static class OreDictExists
    implements RegCondition {
        private final String[] oreKeys;

        public OreDictExists(String[] oreKeys) {
            this.oreKeys = oreKeys;
        }

        @Override
        public boolean isSatisfied() {
            for (String oreKey : this.oreKeys) {
                if (!OreDictUtils.exists((String)oreKey)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ModLoaded
    implements RegCondition {
        private final String[] modIds;

        public ModLoaded(String[] modIds) {
            this.modIds = modIds;
        }

        @Override
        public boolean isSatisfied() {
            for (String modId : this.modIds) {
                if (!Loader.isModLoaded((String)modId)) continue;
                return true;
            }
            return false;
        }
    }
}

