/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.TinkerCraftingEvent;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.tinkering.ITinkerable;
import xyz.phanta.tconevo.item.ItemMaterial;
import xyz.phanta.tconevo.trait.base.MatchSensitiveModifier;
import xyz.phanta.tconevo.util.ToolUtils;

public class ModifierArtifact
extends ModifierTrait
implements MatchSensitiveModifier {
    private static final String LOC_UNSEALED = "modifier.%s.unsealed";

    public ModifierArtifact() {
        super("tconevo.artifact", 14333039, 2, 0);
        this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean canApplyCustomWithMatch(ItemStack tool, RecipeMatch.Match match) {
        return match.stacks.isEmpty() || !ItemMaterial.Type.ARTIFACT_UNSEALER.matches((ItemStack)match.stacks.get(0)) || ToolUtils.getTraitLevel(tool, "tconevo.artifact") == 1;
    }

    public int onToolHeal(ItemStack tool, int amount, int newAmount, EntityLivingBase entity) {
        if (ToolUtils.getTraitLevel(tool, "tconevo.artifact") == 1) {
            return 0;
        }
        return newAmount;
    }

    @SubscribeEvent
    public void onToolCraft(TinkerCraftingEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ITinkerable && ToolUtils.getTraitLevel(stack, "tconevo.artifact") == 1) {
            event.setCanceled(Util.translate((String)"tconevo.info.artifact_sealed", (Object[])new Object[0]));
        }
    }

    public int getPriority() {
        return 0;
    }

    public String getLeveledTooltip(int level, @Nullable String suffix) {
        return level == 1 ? this.getLocalizedName() : String.format("%s (%s)", this.getLocalizedName(), Util.translate((String)LOC_UNSEALED, (Object[])new Object[]{this.getIdentifier()}));
    }
}

