/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait;

import io.github.phantamanta44.libnine.capability.provider.CapabilityBroker;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import io.github.phantamanta44.libnine.util.math.MathUtils;
import java.util.Objects;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.modifiers.ModMendingMoss;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.capability.PowerWrapper;
import xyz.phanta.tconevo.client.event.ItemStackBarEvent;
import xyz.phanta.tconevo.trait.base.EnergeticModifier;
import xyz.phanta.tconevo.trait.base.MatchSensitiveModifier;
import xyz.phanta.tconevo.util.ItemEnergyStore;

public class ModifierFluxed
extends ModifierTrait
implements MatchSensitiveModifier,
EnergeticModifier {
    public static final int COLOUR = 11091771;
    private static final int DEFAULT_ENERGY_MAX = 20000;
    private static final String TAG_ENERGY_MAX = "FluxedEnergyMax";
    private static final String TAG_ENERGY = "FluxedEnergy";

    public ModifierFluxed() {
        super("tconevo.fluxed", 11091771);
        this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
        this.addAspects(new ModifierAspect[]{new ModifierAspect.FreeFirstModifierAspect((IModifier)this, 1)});
        TconEvoMod.PROXY.getToolCapHandler().addModifierCap((Modifier)this, s -> new CapabilityBroker().with(CapabilityEnergy.ENERGY, (Object)new FluxedEnergyStore((ItemStack)s)));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean canApplyCustom(ItemStack stack) {
        return !PowerWrapper.isPowered((ICapabilityProvider)stack) || TconEvoConfig.general.modFluxedReplaceable && this.isToolWithTrait(stack);
    }

    public boolean canApplyTogether(IToolMod otherModifier) {
        return !(otherModifier instanceof ModMendingMoss);
    }

    @Override
    public boolean canApplyCustomWithMatch(ItemStack tool, RecipeMatch.Match match) {
        double divider = TconEvoConfig.general.modFluxedDurabilityThresholdDivider;
        return divider == 0.0 || !match.stacks.isEmpty() && OptUtils.capability((ICapabilityProvider)((ICapabilityProvider)match.stacks.get(0)), (Capability)CapabilityEnergy.ENERGY).map(e -> ToolHelper.getMaxDurability((ItemStack)tool) >= (int)Math.ceil((double)e.getMaxEnergyStored() / divider)).orElse(false) != false;
    }

    @Override
    public void applyEffectWithMatch(ItemStack tool, RecipeMatch.Match match) {
        ItemStack energyCell;
        NBTTagCompound tag = TagUtil.getTagSafe((ItemStack)tool);
        if (!match.stacks.isEmpty() && (energyCell = (ItemStack)match.stacks.get(0)).hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = (IEnergyStorage)Objects.requireNonNull(energyCell.getCapability(CapabilityEnergy.ENERGY, null));
            int energyMax = Math.max(energy.getMaxEnergyStored(), 1);
            tag.func_74768_a(TAG_ENERGY_MAX, energyMax);
            tag.func_74768_a(TAG_ENERGY, MathUtils.clamp((int)energy.getEnergyStored(), (int)0, (int)energyMax));
        } else {
            tag.func_74768_a(TAG_ENERGY_MAX, 20000);
            tag.func_74768_a(TAG_ENERGY, 0);
        }
        tool.func_77982_d(tag);
    }

    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        return ModifierFluxed.doDamageReduction(tool, newDamage, TconEvoConfig.general.modFluxedEnergyCostTools);
    }

    public static int doDamageReduction(ItemStack tool, int damage, int unitCost) {
        if (damage > 0 && tool.hasCapability(CapabilityEnergy.ENERGY, null)) {
            int cost = damage * unitCost;
            int spent = ((IEnergyStorage)Objects.requireNonNull(tool.getCapability(CapabilityEnergy.ENERGY, null))).extractEnergy(cost, false);
            if (spent >= cost) {
                return 0;
            }
            if (spent > 0) {
                return Math.max(damage - (int)Math.ceil((float)damage * ((float)spent / (float)cost)), 0);
            }
        }
        return damage;
    }

    public int getPriority() {
        return 25;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemStackBars(ItemStackBarEvent event) {
        if (this.isToolWithTrait(event.stack)) {
            event.addForgeEnergyBar();
        }
    }

    public static class FluxedEnergyStore
    extends ItemEnergyStore {
        public FluxedEnergyStore(ItemStack stack) {
            super(stack);
        }

        @Override
        public String getNbtKeyEnergy() {
            return ModifierFluxed.TAG_ENERGY;
        }

        @Override
        public double getEnergyTransferDivider() {
            return TconEvoConfig.general.modFluxedEnergyTransferDivider;
        }

        public int getMaxEnergyStored() {
            return OptUtils.stackTag((ItemStack)this.stack).filter(t -> t.func_150297_b(ModifierFluxed.TAG_ENERGY_MAX, 3)).map(t -> t.func_74762_e(ModifierFluxed.TAG_ENERGY_MAX)).orElse(20000);
        }
    }
}

