/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import io.github.phantamanta44.libnine.util.format.FormatUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.capability.PowerWrapper;
import xyz.phanta.tconevo.integration.ic2.Ic2Hooks;
import xyz.phanta.tconevo.trait.base.MatchSensitiveModifier;
import xyz.phanta.tconevo.util.ToolUtils;

public class ModifierPhotovoltaic
extends ModifierTrait
implements MatchSensitiveModifier {
    public static final int COLOUR = 3894951;
    private static final int DEFAULT_GEN_RATE = 1;
    private static final String TAG_GEN_RATE = "PhotovoltaicRate";
    private static final Map<Item, TIntIntMap> matches = new HashMap<Item, TIntIntMap>();

    public static void registerSolarItem(ItemStack stack, int genRate) {
        TconEvoMod.LOGGER.debug("Registering solar item \"{}\" generating {} RF/s", (Object)stack, (Object)genRate);
        matches.computeIfAbsent(stack.func_77973_b(), k -> new TIntIntHashMap()).put(stack.func_77960_j(), genRate);
    }

    public static int getModifierItemGenRate(ItemStack stack) {
        int genRate;
        TIntIntMap itemMap = matches.get(stack.func_77973_b());
        if (itemMap != null && (genRate = itemMap.get(stack.func_77960_j())) > 0) {
            return genRate;
        }
        return 0;
    }

    public ModifierPhotovoltaic() {
        super("tconevo.photovoltaic", 3894951);
        this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
        this.addAspects(new ModifierAspect[]{new ModifierAspect.FreeFirstModifierAspect((IModifier)this, 1)});
    }

    public boolean canApplyCustom(ItemStack stack) {
        return PowerWrapper.isPowered((ICapabilityProvider)stack) && (TconEvoConfig.general.modPhotovoltaicReplaceable || !this.isToolWithTrait(stack));
    }

    @Override
    public void applyEffectWithMatch(ItemStack tool, RecipeMatch.Match match) {
        int genRate;
        NBTTagCompound tag = TagUtil.getTagSafe((ItemStack)tool);
        if (!match.stacks.isEmpty() && (genRate = ModifierPhotovoltaic.getModifierItemGenRate((ItemStack)match.stacks.get(0))) > 0) {
            tag.func_74768_a(TAG_GEN_RATE, genRate);
        } else {
            tag.func_74768_a(TAG_GEN_RATE, 1);
        }
        tool.func_77982_d(tag);
    }

    public static int getToolGenRateMax(ItemStack tool) {
        return TagUtil.getTagSafe((ItemStack)tool).func_74762_e(TAG_GEN_RATE);
    }

    public static int getToolGenRate(ItemStack tool, World world, BlockPos pos) {
        int maxGenRate = ModifierPhotovoltaic.getToolGenRateMax(tool);
        return maxGenRate > 0 ? Math.round((float)maxGenRate * Ic2Hooks.INSTANCE.getSunlight(world, pos)) : 0;
    }

    public static void handleGeneration(ItemStack tool, World world, Entity entity) {
        int genRate;
        PowerWrapper energy = PowerWrapper.wrap((ICapabilityProvider)tool);
        if (energy != null && energy.getEnergy() < energy.getEnergyMax() && (genRate = ModifierPhotovoltaic.getToolGenRate(tool, world, entity.func_180425_c())) > 0) {
            energy.inject(genRate, true, true);
        }
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && !isSelected && entity instanceof EntityLivingBase && entity.field_70173_aa % 20 == 0) {
            ModifierPhotovoltaic.handleGeneration(tool, world, entity);
        }
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        int genRate = ModifierPhotovoltaic.getToolGenRateMax(tool);
        return genRate > 0 ? ToolUtils.formatExtraInfo(this.identifier, FormatUtils.formatSI((int)genRate, (String)"RF/s")) : Collections.emptyList();
    }
}

