/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import xyz.phanta.tconevo.TconEvoConfig;

public class TraitJuggernaut
extends AbstractTrait {
    public TraitJuggernaut() {
        super("tconevo.juggernaut", 5343871);
    }

    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        float bonusDamage = damage * Calculator.get().calculateBonusDamage(player.func_110143_aJ());
        return bonusDamage > 0.0f ? newDamage + bonusDamage : newDamage;
    }

    private static abstract class Calculator {
        @Nullable
        private static Calculator cached = null;
        final float healthBase;
        final float threshFactor;
        final float damageMult;

        static Calculator get() {
            float healthBase = (float)TconEvoConfig.general.traitJuggernautHealthBase;
            float threshFactor = (float)TconEvoConfig.general.traitJuggernautThresholdFactor;
            float damageMult = (float)TconEvoConfig.general.traitJuggernautDamageMultiplier;
            if (cached == null || Calculator.cached.healthBase != healthBase || Calculator.cached.threshFactor != threshFactor || Calculator.cached.damageMult != damageMult) {
                cached = threshFactor <= 1.0f ? new Linear(healthBase, threshFactor, damageMult) : new Logarithmic(healthBase, threshFactor, damageMult);
            }
            return cached;
        }

        protected Calculator(float healthBase, float threshFactor, float damageMult) {
            this.healthBase = healthBase;
            this.threshFactor = threshFactor;
            this.damageMult = damageMult;
        }

        abstract float calculateBonusDamage(float var1);

        private static class Linear
        extends Calculator {
            Linear(float healthBase, float threshFactor, float damageMult) {
                super(healthBase, threshFactor, damageMult);
            }

            @Override
            float calculateBonusDamage(float health) {
                return this.damageMult * (health / this.healthBase);
            }
        }

        private static class Logarithmic
        extends Calculator {
            private final float logHealthBase;
            private final float logThreshFactor;

            Logarithmic(float healthBase, float threshFactor, float damageMult) {
                super(healthBase, threshFactor, damageMult);
                this.logHealthBase = (float)Math.log(healthBase);
                this.logThreshFactor = (float)Math.log(threshFactor);
            }

            @Override
            float calculateBonusDamage(float health) {
                float result = this.damageMult * (((float)Math.log(health) - this.logHealthBase) / this.logThreshFactor + 1.0f);
                return Float.isFinite(result) ? result : 0.0f;
            }
        }
    }
}

