/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.astralsorcery;

import io.github.phantamanta44.libnine.util.helper.OptUtils;
import io.github.phantamanta44.libnine.util.tuple.IPair;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTraits;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.integration.astralsorcery.AstralConstellation;
import xyz.phanta.tconevo.integration.astralsorcery.AstralHooks;

public abstract class ModifierAttuned
extends ModifierTrait {
    public static final int COLOUR = 25337;
    public static final String TAG_ATTUNEMENT = "AttunedConstellation";
    private final AstralConstellation constellation;

    public ModifierAttuned(String identifier, AstralConstellation constellation) {
        super(identifier, 25337);
        this.constellation = constellation;
        this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
    }

    public AstralConstellation getConstellation() {
        return this.constellation;
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        rootCompound.func_74768_a(TAG_ATTUNEMENT, this.constellation.ordinal());
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        if (this.isConstellationInSky(event.getEntityPlayer().field_70170_p)) {
            event.setNewSpeed(event.getNewSpeed() + event.getOriginalSpeed() * (float)TconEvoConfig.moduleAstralSorcery.attunementBonusEfficiency);
        }
    }

    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        return this.isConstellationInSky(player.field_70170_p) ? newDamage + damage * (float)TconEvoConfig.moduleAstralSorcery.attunementBonusDamage : newDamage;
    }

    private boolean isConstellationInSky(World world) {
        return AstralHooks.INSTANCE.isConstellationInSky(world, this.constellation);
    }

    @Nullable
    public static AstralConstellation getAttunement(ItemStack stack) {
        return OptUtils.stackTag((ItemStack)stack).filter(t -> t.func_150297_b(TAG_ATTUNEMENT, 3)).map(t -> AstralConstellation.VALUES[t.func_74762_e(TAG_ATTUNEMENT)]).orElse(null);
    }

    public static class Pelotrio
    extends ModifierAttuned {
        public Pelotrio() {
            super("tconevo.attuned_pelotrio", AstralConstellation.PELOTRIO);
        }

        public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
            double odds;
            if (!world.field_72995_K && !isSelected && entity instanceof EntityLivingBase && entity.field_70173_aa % 20 == 0 && tool.func_77952_i() > 0 && !ToolHelper.isBroken((ItemStack)tool) && (odds = TconEvoConfig.moduleAstralSorcery.toolPelotrioRepairProbability) > 0.0 && (odds >= 1.0 || world.field_73012_v.nextDouble() <= odds)) {
                ToolHelper.healTool((ItemStack)tool, (int)1, (EntityLivingBase)((EntityLivingBase)entity));
            }
        }
    }

    public static class Octans
    extends ModifierAttuned {
        public Octans() {
            super("tconevo.attuned_octans", AstralConstellation.OCTANS);
        }

        @Override
        public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
            super.miningSpeed(tool, event);
            TinkerTraits.aquadynamic.miningSpeed(tool, event);
        }
    }

    public static class Mineralis
    extends EffectEnchant {
        public Mineralis() {
            super("tconevo.attuned_mineralis", AstralConstellation.MINERALIS);
        }

        @Override
        protected IPair<Enchantment, Integer> getAttunedEnchantment() {
            return IPair.of((Object)Enchantments.field_185308_t, (Object)TconEvoConfig.moduleAstralSorcery.toolMineralisFortuneLevel);
        }
    }

    public static class Lucerna
    extends EffectAfterHit {
        public Lucerna() {
            super("tconevo.attuned_lucerna", AstralConstellation.LUCERNA);
        }

        @Override
        protected void doAttunedEffect(EntityLivingBase attacker, EntityLivingBase target, float damage) {
            target.func_70690_d(new PotionEffect(MobEffects.field_188423_x, TconEvoConfig.moduleAstralSorcery.toolLucernaGlowingDuration, 1));
        }
    }

    public static class Horologium
    extends EffectAfterHit {
        public Horologium() {
            super("tconevo.attuned_horologium", AstralConstellation.HOROLOGIUM);
        }

        @Override
        protected void doAttunedEffect(EntityLivingBase attacker, EntityLivingBase target, float damage) {
            AstralHooks.INSTANCE.freezeTime(target.field_70170_p, target.func_180425_c(), (Entity)attacker, 1.0f, TconEvoConfig.moduleAstralSorcery.toolHorologiumFreezeDuration, false);
        }
    }

    public static class Fornax
    extends EffectAfterHit {
        public Fornax() {
            super("tconevo.attuned_fornax", AstralConstellation.FORNAX);
        }

        @Override
        protected void doAttunedEffect(EntityLivingBase attacker, EntityLivingBase target, float damage) {
            target.func_70015_d(TconEvoConfig.moduleAstralSorcery.toolFornaxFireDuration);
        }
    }

    public static class Bootes
    extends EffectEnchant {
        public Bootes() {
            super("tconevo.attuned_bootes", AstralConstellation.BOOTES);
        }

        @Override
        protected IPair<Enchantment, Integer> getAttunedEnchantment() {
            return IPair.of((Object)Enchantments.field_185306_r, (Object)1);
        }
    }

    public static class Vicio
    extends EffectAfterHit {
        public Vicio() {
            super("tconevo.attuned_vicio", AstralConstellation.VICIO);
        }

        @Override
        protected void doAttunedEffect(EntityLivingBase attacker, EntityLivingBase target, float damage) {
            attacker.func_70690_d(new PotionEffect(MobEffects.field_76424_c, TconEvoConfig.moduleAstralSorcery.toolVicioSpeedDuration, 1));
        }
    }

    public static class Evorsio
    extends EffectToolData {
        public Evorsio() {
            super("tconevo.attuned_evorsio", AstralConstellation.EVORSIO);
        }

        @Override
        protected void doAttunedEffect(ToolNBT toolData, ToolNBT originalData) {
            toolData.speed += originalData.speed * (float)TconEvoConfig.moduleAstralSorcery.toolEvorsioBonusEfficiency;
        }
    }

    public static class Discidia
    extends EffectToolData {
        public Discidia() {
            super("tconevo.attuned_discidia", AstralConstellation.DISCIDIA);
        }

        @Override
        protected void doAttunedEffect(ToolNBT toolData, ToolNBT originalData) {
            toolData.attack += originalData.attack * (float)TconEvoConfig.moduleAstralSorcery.toolDiscidiaBonusDamage;
        }
    }

    public static class Armara
    extends EffectAfterHit {
        public Armara() {
            super("tconevo.attuned_armara", AstralConstellation.ARMARA);
        }

        @Override
        protected void doAttunedEffect(EntityLivingBase attacker, EntityLivingBase target, float damage) {
            attacker.func_70690_d(new PotionEffect(MobEffects.field_76429_m, TconEvoConfig.moduleAstralSorcery.toolArmaraResistanceDuration, 1));
        }
    }

    public static class Aevitas
    extends EffectAfterHit {
        public Aevitas() {
            super("tconevo.attuned_aevitas", AstralConstellation.AEVITAS);
        }

        @Override
        protected void doAttunedEffect(EntityLivingBase attacker, EntityLivingBase target, float damage) {
            attacker.func_70690_d(new PotionEffect(MobEffects.field_76428_l, TconEvoConfig.moduleAstralSorcery.toolAevitasRegenDuration, 1));
        }
    }

    private static abstract class EffectEnchant
    extends ModifierAttuned {
        EffectEnchant(String identifier, AstralConstellation constellation) {
            super(identifier, constellation);
        }

        @Override
        public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
            super.applyEffect(rootCompound, modifierTag);
            IPair<Enchantment, Integer> ench = this.getAttunedEnchantment();
            while (ToolBuilder.getEnchantmentLevel((NBTTagCompound)rootCompound, (Enchantment)((Enchantment)ench.getA())) < (Integer)ench.getB()) {
                ToolBuilder.addEnchantment((NBTTagCompound)rootCompound, (Enchantment)((Enchantment)ench.getA()));
            }
        }

        protected abstract IPair<Enchantment, Integer> getAttunedEnchantment();
    }

    private static abstract class EffectAfterHit
    extends ModifierAttuned {
        EffectAfterHit(String identifier, AstralConstellation constellation) {
            super(identifier, constellation);
        }

        public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
            if (target.field_70170_p.field_72995_K || !wasHit || player instanceof EntityPlayer && ((EntityPlayer)player).func_184825_o(0.5f) < 0.95f) {
                return;
            }
            this.doAttunedEffect(player, target, damageDealt);
        }

        protected abstract void doAttunedEffect(EntityLivingBase var1, EntityLivingBase var2, float var3);
    }

    private static abstract class EffectToolData
    extends ModifierAttuned {
        EffectToolData(String identifier, AstralConstellation constellation) {
            super(identifier, constellation);
        }

        @Override
        public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
            super.applyEffect(rootCompound, modifierTag);
            ToolNBT toolData = TagUtil.getToolStats((NBTTagCompound)rootCompound);
            this.doAttunedEffect(toolData, TagUtil.getOriginalToolStats((NBTTagCompound)rootCompound));
            TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)toolData.get());
        }

        protected abstract void doAttunedEffect(ToolNBT var1, ToolNBT var2);
    }
}

