/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.draconicevolution;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.utils.TagUtil;
import xyz.phanta.tconevo.util.ToolUtils;

public class ModifierDraconic
extends ModifierTrait {
    public static final int DEFAULT_COLOUR = 43690;
    static final List<ModifierDraconic> allMods = new ArrayList<ModifierDraconic>();
    @Nullable
    private final Set<Category> eligibleCategories;

    public ModifierDraconic(String name, int colour, int maxLevel, Category ... eligibleCategories) {
        super(name, colour, maxLevel + 1, 0);
        this.eligibleCategories = eligibleCategories.length > 0 ? Sets.newHashSet((Object[])eligibleCategories) : null;
        this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
        allMods.add(this);
    }

    public ModifierDraconic(String name, Category ... eligibleCategories) {
        this(name, 43690, 4, eligibleCategories);
    }

    public final void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        int level = ToolUtils.getTraitLevel(modifierTag);
        if (level > 1) {
            this.applyDraconicEffect(rootCompound, level - 1);
        }
    }

    protected void applyDraconicEffect(NBTTagCompound rootTag, int tier) {
    }

    public boolean isEligible(NBTTagCompound root) {
        if (this.eligibleCategories == null) {
            return true;
        }
        for (Category cat : TagUtil.getCategories((NBTTagCompound)root)) {
            if (!this.eligibleCategories.contains(cat)) continue;
            return true;
        }
        return false;
    }

    public String getLeveledTooltip(int level, @Nullable String suffix) {
        return String.format("%s " + TextFormatting.GOLD + "%s%s", this.getLocalizedName(), I18n.func_135052_a((String)("upgrade.level." + (level - 1)), (Object[])new Object[0]), suffix);
    }

    protected int getDraconicTier(ItemStack stack) {
        return ToolUtils.getTraitLevel(stack, this.identifier) - 1;
    }
}

