/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.draconicevolution;

import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.capability.EnergyShield;
import xyz.phanta.tconevo.init.TconEvoCaps;
import xyz.phanta.tconevo.integration.draconicevolution.DraconicHooks;
import xyz.phanta.tconevo.network.SPacketEntitySpecialEffect;
import xyz.phanta.tconevo.util.ToolUtils;

public class ModifierEntropic
extends ModifierTrait {
    public ModifierEntropic() {
        super("tconevo.entropic", 0xFF6600, 5, 0);
        if (TconEvoConfig.moduleDraconicEvolution.entropicOnlyUsesOneModifier) {
            this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
            this.addAspects(new ModifierAspect[]{new ModifierAspect.FreeFirstModifierAspect((IModifier)this, 1)});
        }
    }

    private static float getBonusEntropy(int level) {
        return (float)level * (float)TconEvoConfig.moduleDraconicEvolution.entropicBonusEntropyPerLevel;
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (target.field_70170_p.field_72995_K || !wasHit) {
            return;
        }
        float entropy = damageDealt / 20.0f * ModifierEntropic.getBonusEntropy(ToolUtils.getTraitLevel(tool, this.identifier));
        if (entropy > 0.0f) {
            boolean success = false;
            for (ItemStack stack : target.func_184193_aE()) {
                if (DraconicHooks.INSTANCE.inflictEntropy(stack, entropy)) {
                    success = true;
                    continue;
                }
                if (!stack.hasCapability(TconEvoCaps.ENERGY_SHIELD, null)) continue;
                EnergyShield shield = (EnergyShield)Objects.requireNonNull(stack.getCapability(TconEvoCaps.ENERGY_SHIELD, null));
                shield.setEntropy(shield.getEntropy() + entropy);
                success = true;
            }
            if (success) {
                TconEvoMod.PROXY.playEntityEffect((Entity)target, SPacketEntitySpecialEffect.EffectType.ENTROPY_BURST);
            }
        }
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        return ToolUtils.formatExtraInfoPercent(this.identifier, ModifierEntropic.getBonusEntropy(ToolUtils.getTraitLevel(modifierTag)));
    }
}

