/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.draconicevolution;

import io.github.phantamanta44.libnine.util.math.MathUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.capability.PowerWrapper;
import xyz.phanta.tconevo.integration.draconicevolution.DraconicHooks;
import xyz.phanta.tconevo.network.SPacketEntitySpecialEffect;
import xyz.phanta.tconevo.util.DamageUtils;
import xyz.phanta.tconevo.util.ToolUtils;

public class ModifierFluxBurn
extends ModifierTrait {
    public ModifierFluxBurn() {
        super("tconevo.flux_burn", 11150920, 5, 0);
        if (TconEvoConfig.moduleDraconicEvolution.fluxBurnOnlyUsesOneModifier) {
            this.aspects.remove(this.aspects.lastIndexOf(ModifierAspect.freeModifier));
            this.addAspects(new ModifierAspect[]{new ModifierAspect.FreeFirstModifierAspect((IModifier)this, 1)});
        }
    }

    private float getBurnFraction(int level) {
        return (float)level * (float)TconEvoConfig.moduleDraconicEvolution.fluxBurnPortionPerLevel;
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (target.field_70170_p.field_72995_K || !wasHit || player instanceof EntityPlayer && ((EntityPlayer)player).func_184825_o(0.5f) < 0.95f) {
            return;
        }
        int level = ToolUtils.getTraitLevel(tool, this.identifier);
        float burnAmount = this.getBurnFraction(level);
        int minBurn = level * TconEvoConfig.moduleDraconicEvolution.fluxBurnMinPerLevel;
        int maxBurn = TconEvoConfig.moduleDraconicEvolution.fluxBurnMaxPerLevel;
        maxBurn = maxBurn > 0 ? level * maxBurn : Integer.MAX_VALUE;
        long totalBurned = 0L;
        for (ItemStack stack : target.func_184193_aE()) {
            int burned = DraconicHooks.INSTANCE.burnArmourEnergy(stack, burnAmount, minBurn, maxBurn);
            if (burned > 0) {
                totalBurned += (long)burned;
                continue;
            }
            PowerWrapper energy = PowerWrapper.wrap((ICapabilityProvider)stack);
            if (energy == null || (burned = MathUtils.clamp((int)((int)Math.ceil((float)energy.getEnergy() * burnAmount)), (int)minBurn, (int)maxBurn)) <= 0) continue;
            totalBurned += (long)energy.extract(burned, true, true);
        }
        if (totalBurned > 0L) {
            float burnDamage = (float)((double)totalBurned / (double)TconEvoConfig.moduleDraconicEvolution.fluxBurnEnergy);
            if (burnDamage >= 0.01f) {
                target.field_70172_ad = 0;
                DamageUtils.attackEntityWithTool(player, tool, (Entity)target, DamageUtils.getEntityDamageSource(player), burnDamage);
            }
            TconEvoMod.PROXY.playEntityEffect((Entity)target, SPacketEntitySpecialEffect.EffectType.FLUX_BURN);
        }
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        return ToolUtils.formatExtraInfoPercent(this.identifier, this.getBurnFraction(ToolUtils.getTraitLevel(modifierTag)));
    }
}

