/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.draconicevolution;

import io.github.phantamanta44.libnine.capability.provider.CapabilityBroker;
import io.github.phantamanta44.libnine.util.helper.ItemUtils;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.events.ProjectileEvent;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tools.ranged.ProjectileCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.TconEvoMod;
import xyz.phanta.tconevo.capability.RatedEnergyStorage;
import xyz.phanta.tconevo.client.event.ItemStackBarEvent;
import xyz.phanta.tconevo.integration.conarm.ConArmHooks;
import xyz.phanta.tconevo.trait.base.EnergeticModifier;
import xyz.phanta.tconevo.trait.base.StackableTrait;
import xyz.phanta.tconevo.trait.draconicevolution.ModifierDraconic;
import xyz.phanta.tconevo.util.ToolUtils;

public class TraitEvolved
extends StackableTrait
implements EnergeticModifier {
    public static final int COLOUR = 13146868;
    public static final String TAG_EVOLVED_TIER = "EvolvedTier";

    public static int getEvolvedTier(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(TAG_EVOLVED_TIER, 3)) {
            return Math.max(tag.func_74762_e(TAG_EVOLVED_TIER), 1);
        }
        String traitId = ConArmHooks.INSTANCE.isTinkerArmour(stack) ? "tconevo.evolved_armor" : "tconevo.evolved";
        return Math.max(ToolUtils.getTraitLevel(stack, traitId), 1);
    }

    public TraitEvolved(int level) {
        super("tconevo.evolved", 13146868, 3, level);
        if (level == 1) {
            TconEvoMod.PROXY.getToolCapHandler().addModifierCap("tconevo.evolved", s -> new CapabilityBroker().with(CapabilityEnergy.ENERGY, (Object)new EvolvedCap((ItemStack)s)));
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        if (modifierTag.func_74762_e("level") == 0) {
            super.applyEffect(rootCompound, modifierTag);
            rootCompound.func_74757_a("Unbreakable", true);
            for (ModifierDraconic mod : ModifierDraconic.allMods) {
                if (!mod.isEligible(rootCompound) || TinkerUtil.hasTrait((NBTTagCompound)rootCompound, (String)mod.identifier)) continue;
                mod.apply(rootCompound);
            }
            if (TinkerUtil.hasCategory((NBTTagCompound)rootCompound, (Category)Category.PROJECTILE) && rootCompound.func_74762_e("EvolvedEnergy") <= 0) {
                NBTTagCompound toolDataTag = TagUtil.getToolTag((NBTTagCompound)rootCompound);
                toolDataTag.func_74757_a("Broken", true);
                TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)toolDataTag);
            }
        } else {
            super.applyEffect(rootCompound, modifierTag);
        }
    }

    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        if (!TraitEvolved.isCanonical(this, tool)) {
            return newDamage;
        }
        int energyCost = TraitEvolved.getOperationCost(tool);
        if (energyCost > 0) {
            OptUtils.capability((ICapabilityProvider)tool, (Capability)CapabilityEnergy.ENERGY).ifPresent(e -> e.extractEnergy(energyCost, false));
        }
        return 0;
    }

    public int onToolHeal(ItemStack tool, int amount, int newAmount, EntityLivingBase entity) {
        if (!TraitEvolved.isCanonical(this, tool)) {
            return newAmount;
        }
        if (tool.func_77973_b() instanceof ProjectileCore) {
            this.updateProjectileAmmo(tool);
        }
        return 0;
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        if (TraitEvolved.isCanonical(this, tool) && !this.canPerformOperation(tool)) {
            event.setNewSpeed(0.5f);
        }
    }

    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        if (!TraitEvolved.isCanonical(this, tool)) {
            return newDamage;
        }
        return this.canPerformOperation(tool) ? newDamage : newDamage / 10.0f;
    }

    @SubscribeEvent
    public void onBreakExtraBlocks(TinkerToolEvent.ExtraBlockBreak event) {
        if (this.isToolWithStackableTrait(event.itemStack) && !this.canPerformOperation(event.itemStack)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onProjectileLaunch(ProjectileEvent.OnLaunch event) {
        if (!event.projectileEntity.field_70170_p.field_72995_K) {
            ItemStack ammoStack;
            ItemStack bowStack = event.launcher;
            if (bowStack != null && this.isToolWithStackableTrait(bowStack)) {
                if (event.projectile != null) {
                    if (!this.canPerformOperation(bowStack)) {
                        TraitEvolved.dampenVelocity((Entity)event.projectile);
                        event.projectile.tinkerProjectile.setPower(event.projectile.tinkerProjectile.getPower() / 10.0f);
                    }
                } else if (!this.canPerformOperation(bowStack)) {
                    TraitEvolved.dampenVelocity(event.projectileEntity);
                }
            }
            if (event.projectile != null && (ammoStack = event.projectile.tinkerProjectile.getItemStack()).func_77973_b() instanceof ProjectileCore && this.isToolWithStackableTrait(ammoStack)) {
                event.projectile.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
            }
        }
    }

    private static void dampenVelocity(Entity entity) {
        entity.field_70159_w /= 10.0;
        entity.field_70181_x /= 10.0;
        entity.field_70179_y /= 10.0;
        entity.field_70133_I = true;
    }

    private boolean canPerformOperation(ItemStack tool) {
        int energyCost = TraitEvolved.getOperationCost(tool);
        return energyCost <= 0 || OptUtils.capability((ICapabilityProvider)tool, (Capability)CapabilityEnergy.ENERGY).map(e -> e.getEnergyStored() >= energyCost && e.extractEnergy(energyCost, true) >= energyCost).orElse(false) != false;
    }

    private static int getOperationCost(ItemStack stack) {
        return TconEvoConfig.moduleDraconicEvolution.getOperationEnergy(TraitEvolved.getEvolvedTier(stack));
    }

    public int getPriority() {
        return 25;
    }

    private void updateProjectileAmmo(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energy instanceof EvolvedCap) {
            EvolvedCap cap = (EvolvedCap)energy;
            cap.updateProjectileAmmo(cap.getEnergyStored());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemStackBars(ItemStackBarEvent event) {
        if (this.isToolWithStackableTrait(event.stack)) {
            event.addForgeEnergyBar();
        }
    }

    public static class EvolvedCap
    implements RatedEnergyStorage {
        public static final String TAG_ENERGY = "EvolvedEnergy";
        protected final ItemStack stack;

        public EvolvedCap(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate, boolean ignoreTfrRate) {
            int tier = TraitEvolved.getEvolvedTier(this.stack);
            int stored = this.getEnergyStored();
            int capacity = this.getMaxEnergyStored(tier);
            int toTransfer = Math.min(maxReceive, capacity - stored);
            if (!ignoreTfrRate) {
                toTransfer = Math.min(toTransfer, TconEvoConfig.moduleDraconicEvolution.getRfTransfer(tier));
            }
            if (toTransfer > 0 && !simulate) {
                this.setEnergyStored(stored + toTransfer);
            }
            return toTransfer;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate, boolean ignoreTfrRate) {
            int stored = this.getEnergyStored();
            int toTransfer = Math.min(maxExtract, stored);
            if (toTransfer > 0 && !simulate) {
                this.setEnergyStored(stored - toTransfer);
            }
            return toTransfer;
        }

        public void setEnergyStored(int amount) {
            ItemUtils.getOrCreateTag((ItemStack)this.stack).func_74768_a(TAG_ENERGY, amount);
            if (this.stack.func_77973_b() instanceof ProjectileCore) {
                this.updateProjectileAmmo(amount);
            }
        }

        private void updateProjectileAmmo(int amount) {
            ProjectileCore projItem = (ProjectileCore)this.stack.func_77973_b();
            if (amount >= TraitEvolved.getOperationCost(this.stack)) {
                projItem.setAmmo(projItem.getMaxAmmo(this.stack), this.stack);
                NBTTagCompound toolDataTag = TagUtil.getToolTag((ItemStack)this.stack);
                toolDataTag.func_74757_a("Broken", false);
                TagUtil.setToolTag((ItemStack)this.stack, (NBTTagCompound)toolDataTag);
            } else {
                projItem.setAmmo(0, this.stack);
            }
        }

        public int getEnergyStored() {
            return OptUtils.stackTag((ItemStack)this.stack).map(t -> t.func_74762_e(TAG_ENERGY)).orElse(0);
        }

        public int getMaxEnergyStored() {
            return this.getMaxEnergyStored(TraitEvolved.getEvolvedTier(this.stack));
        }

        private int getMaxEnergyStored(int tier) {
            int capacity = TconEvoConfig.moduleDraconicEvolution.getBaseRfCapacity(tier);
            int energyTier = this.getEnergyTier();
            if (energyTier > 1) {
                capacity <<= energyTier - 1;
            }
            return capacity;
        }

        protected int getEnergyTier() {
            return ToolUtils.getTraitLevel(this.stack, "tconevo.draconic_energy");
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

