/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.trait.projecte;

import gnu.trove.list.array.TLongArrayList;
import io.github.phantamanta44.libnine.util.helper.InventoryUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import xyz.phanta.tconevo.TconEvoConfig;
import xyz.phanta.tconevo.integration.projecte.EqExHooks;
import xyz.phanta.tconevo.trait.base.StackableTrait;
import xyz.phanta.tconevo.util.ToolUtils;

public class TraitEternalDensity
extends StackableTrait {
    public static final int COLOUR = 3675966;

    public TraitEternalDensity(int level) {
        super("tconevo.eternal_density", 3675966, 2, level);
    }

    private static double getConversionRatio(int level) {
        return (double)level * TconEvoConfig.moduleProjectE.eternalDensityDamageConversion;
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (target.field_70170_p.field_72995_K || !wasHit || !TraitEternalDensity.isCanonical(this, tool)) {
            return;
        }
        long amount = (long)Math.ceil((double)damageDealt * TraitEternalDensity.getConversionRatio(ToolUtils.getTraitLevel(tool, "tconevo.eternal_density")));
        if ((double)amount > 0.0) {
            TraitEternalDensity.distributeEmc(player, amount);
        }
    }

    private static void distributeEmc(EntityLivingBase entity, long amount) {
        Iterator iterInv = InventoryUtils.streamInventory((EntityLivingBase)entity).iterator();
        ArrayList<ItemStack> recipients = new ArrayList<ItemStack>();
        TLongArrayList recipientMisssing = new TLongArrayList();
        long totalMissing = 0L;
        while (iterInv.hasNext()) {
            ItemStack stack = (ItemStack)iterInv.next();
            long capacity = EqExHooks.INSTANCE.getEmcCapacity(stack);
            if (capacity <= 0L) continue;
            recipients.add(stack);
            long missing = capacity - EqExHooks.INSTANCE.getEmcStored(stack);
            totalMissing += missing;
            recipientMisssing.add(missing);
        }
        if (totalMissing <= 0L) {
            return;
        }
        for (int i = 0; i < recipients.size(); ++i) {
            EqExHooks.INSTANCE.injectEmc((ItemStack)recipients.get(i), Math.round((double)amount * ((double)recipientMisssing.get(i) / (double)totalMissing)));
        }
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        if (!TraitEternalDensity.isCanonical(this, tool)) {
            return;
        }
        int densityTier = EqExHooks.INSTANCE.getDenseBlockTier(event.getState());
        if (densityTier > 0 && ToolUtils.getTraitLevel(tool, "tconevo.eternal_density") >= densityTier) {
            event.setNewSpeed(1200000.0f);
        }
    }

    public void afterBlockBreak(ItemStack tool, World world, IBlockState state, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        int densityTier;
        if (player instanceof EntityPlayer && wasEffective && TraitEternalDensity.isCanonical(this, tool) && (densityTier = EqExHooks.INSTANCE.getDenseBlockTier(state)) > 0 && ToolUtils.getTraitLevel(tool, "tconevo.eternal_density") >= densityTier && !state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)player)) {
            state.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, state, world.func_175625_s(pos), tool);
        }
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        return ToolUtils.formatExtraInfoPercent("tconevo.eternal_density", (float)TraitEternalDensity.getConversionRatio(ToolUtils.getTraitLevel(modifierTag)));
    }
}

