/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.tconevo.util;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.capability.projectile.CapabilityTinkerProjectile;
import slimeknights.tconstruct.library.capability.projectile.ITinkerProjectile;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ProjectileNBT;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import xyz.phanta.tconevo.integration.conarm.ConArmHooks;

public class ToolUtils {
    public static ItemStack getAttackerWeapon(DamageSource dmgSrc, EntityLivingBase attacker) {
        return CapabilityTinkerProjectile.getTinkerProjectile((DamageSource)dmgSrc).map(ITinkerProjectile::getItemStack).orElse(attacker.func_184586_b(EnumHand.MAIN_HAND));
    }

    public static ProjectileNBT getProjectileData(NBTTagCompound tag) {
        return new ProjectileNBT(TagUtil.getToolTag((NBTTagCompound)tag));
    }

    public static ProjectileNBT getOriginalProjectileData(NBTTagCompound tag) {
        return new ProjectileNBT(ToolUtils.getOriginalToolTag(tag));
    }

    public static ProjectileLauncherNBT getLauncherData(NBTTagCompound tag) {
        return new ProjectileLauncherNBT(TagUtil.getToolTag((NBTTagCompound)tag));
    }

    public static ProjectileLauncherNBT getOriginalLauncherData(NBTTagCompound tag) {
        return new ProjectileLauncherNBT(ToolUtils.getOriginalToolTag(tag));
    }

    public static NBTTagCompound getOriginalToolTag(NBTTagCompound tag) {
        return TagUtil.getTagSafe((NBTTagCompound)tag, (String)"StatsOriginal");
    }

    public static boolean hasTrait(ItemStack stack, String traitId) {
        return TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack), (String)traitId);
    }

    public static boolean hasModifier(ItemStack stack, String modifierId) {
        return ToolUtils.hasModifier(TagUtil.getTagSafe((ItemStack)stack), modifierId);
    }

    public static boolean hasModifier(NBTTagCompound rootTag, String modifierId) {
        NBTTagList modTags = TagUtil.getModifiersTagList((NBTTagCompound)rootTag);
        for (int i = 0; i < modTags.func_74745_c(); ++i) {
            if (!modifierId.equals(modTags.func_150305_b(i).func_74779_i("identifier"))) continue;
            return true;
        }
        return false;
    }

    public static int getTraitLevel(ItemStack stack, String traitId) {
        return ToolUtils.getTraitLevel(TinkerUtil.getModifierTag((ItemStack)stack, (String)traitId));
    }

    public static int getTraitLevel(NBTTagCompound modTag) {
        return ModifierNBT.readTag((NBTTagCompound)modTag).level;
    }

    public static List<String> formatExtraInfo(String identifier, String info) {
        return Collections.singletonList(I18n.func_135052_a((String)String.format("modifier.%s.extra", identifier), (Object[])new Object[]{info}));
    }

    public static List<String> formatExtraInfoPercent(String identifier, float percentage) {
        if (percentage > 0.0f && percentage < 0.01f) {
            return ToolUtils.formatExtraInfo(identifier, "<1%");
        }
        return ToolUtils.formatExtraInfo(identifier, Util.dfPercent.format(percentage));
    }

    public static int getAndSetModifierCount(ItemStack stack, int mods) {
        ToolNBT toolData = TagUtil.getToolStats((ItemStack)stack);
        int oldModCount = toolData.modifiers;
        toolData.modifiers = mods;
        TagUtil.setToolTag((ItemStack)stack, (NBTTagCompound)toolData.get());
        return oldModCount;
    }

    public static void rebuildToolStack(ItemStack stack) throws TinkerGuiException {
        NBTTagCompound rootTag = TagUtil.getTagSafe((ItemStack)stack);
        if (stack.func_77973_b() instanceof TinkersItem) {
            ToolBuilder.rebuildTool((NBTTagCompound)rootTag, (TinkersItem)((TinkersItem)stack.func_77973_b()));
        } else if (ConArmHooks.INSTANCE.isTinkerArmour(stack)) {
            ConArmHooks.INSTANCE.rebuildArmour(rootTag, stack.func_77973_b());
        }
        stack.func_77982_d(rootTag);
    }

    public static List<Material> getToolMaterials(ItemStack stack) {
        return TinkerUtil.getMaterialsFromTagList((NBTTagList)TagUtil.getBaseMaterialsTagList((ItemStack)stack));
    }
}

