/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.why.network;

import java.util.function.Supplier;
import net.mcreator.why.ItsNotRealMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItsNotRealModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ItsNotRealMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        ItsNotRealMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.SoundCooldown = message.data.SoundCooldown;
                    variables.CustomGuiCooldown = message.data.CustomGuiCooldown;
                    variables.StaticGoogle1 = message.data.StaticGoogle1;
                    variables.clientjoin = message.data.clientjoin;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double SoundCooldown = 3400.0;
        public double CustomGuiCooldown = 22000.0;
        public boolean StaticGoogle1 = false;
        public boolean clientjoin = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ItsNotRealMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("SoundCooldown", this.SoundCooldown);
            nbt.m_128347_("CustomGuiCooldown", this.CustomGuiCooldown);
            nbt.m_128379_("StaticGoogle1", this.StaticGoogle1);
            nbt.m_128379_("clientjoin", this.clientjoin);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.SoundCooldown = nbt.m_128459_("SoundCooldown");
            this.CustomGuiCooldown = nbt.m_128459_("CustomGuiCooldown");
            this.StaticGoogle1 = nbt.m_128471_("StaticGoogle1");
            this.clientjoin = nbt.m_128471_("clientjoin");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("its_not_real", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "its_not_real_mapvars";
        public double StalkSpawnCooldown = 7000.0;
        public boolean SeenStalk = false;
        public boolean SeenScare = false;
        public double ScareSpawnCooldown = 12500.0;
        public double HallucinationSpawnCooldown = 7300.0;
        public double TheEntityKicksCooldown = 64000.0;
        public boolean BeenKicked = false;
        public boolean HitByHallucination = false;
        public double FalseStructureCooldown = 28000.0;
        public double Obelisk1Cooldown = 32000.0;
        public boolean ObeliskAttacked = false;
        public double SentinelCooldown = 9000.0;
        public double NullPointCooldown = 5000.0;
        public double AnimalStareCooldown = 14500.0;
        public double FigureSpawnCooldown = 13000.0;
        public double FlyingHallucinationCooldown = 15000.0;
        public boolean worldjoin = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.StalkSpawnCooldown = nbt.m_128459_("StalkSpawnCooldown");
            this.SeenStalk = nbt.m_128471_("SeenStalk");
            this.SeenScare = nbt.m_128471_("SeenScare");
            this.ScareSpawnCooldown = nbt.m_128459_("ScareSpawnCooldown");
            this.HallucinationSpawnCooldown = nbt.m_128459_("HallucinationSpawnCooldown");
            this.TheEntityKicksCooldown = nbt.m_128459_("TheEntityKicksCooldown");
            this.BeenKicked = nbt.m_128471_("BeenKicked");
            this.HitByHallucination = nbt.m_128471_("HitByHallucination");
            this.FalseStructureCooldown = nbt.m_128459_("FalseStructureCooldown");
            this.Obelisk1Cooldown = nbt.m_128459_("Obelisk1Cooldown");
            this.ObeliskAttacked = nbt.m_128471_("ObeliskAttacked");
            this.SentinelCooldown = nbt.m_128459_("SentinelCooldown");
            this.NullPointCooldown = nbt.m_128459_("NullPointCooldown");
            this.AnimalStareCooldown = nbt.m_128459_("AnimalStareCooldown");
            this.FigureSpawnCooldown = nbt.m_128459_("FigureSpawnCooldown");
            this.FlyingHallucinationCooldown = nbt.m_128459_("FlyingHallucinationCooldown");
            this.worldjoin = nbt.m_128471_("worldjoin");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("StalkSpawnCooldown", this.StalkSpawnCooldown);
            nbt.m_128379_("SeenStalk", this.SeenStalk);
            nbt.m_128379_("SeenScare", this.SeenScare);
            nbt.m_128347_("ScareSpawnCooldown", this.ScareSpawnCooldown);
            nbt.m_128347_("HallucinationSpawnCooldown", this.HallucinationSpawnCooldown);
            nbt.m_128347_("TheEntityKicksCooldown", this.TheEntityKicksCooldown);
            nbt.m_128379_("BeenKicked", this.BeenKicked);
            nbt.m_128379_("HitByHallucination", this.HitByHallucination);
            nbt.m_128347_("FalseStructureCooldown", this.FalseStructureCooldown);
            nbt.m_128347_("Obelisk1Cooldown", this.Obelisk1Cooldown);
            nbt.m_128379_("ObeliskAttacked", this.ObeliskAttacked);
            nbt.m_128347_("SentinelCooldown", this.SentinelCooldown);
            nbt.m_128347_("NullPointCooldown", this.NullPointCooldown);
            nbt.m_128347_("AnimalStareCooldown", this.AnimalStareCooldown);
            nbt.m_128347_("FigureSpawnCooldown", this.FigureSpawnCooldown);
            nbt.m_128347_("FlyingHallucinationCooldown", this.FlyingHallucinationCooldown);
            nbt.m_128379_("worldjoin", this.worldjoin);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ItsNotRealMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "its_not_real_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ItsNotRealMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.SoundCooldown = original.SoundCooldown;
            clone.CustomGuiCooldown = original.CustomGuiCooldown;
            clone.StaticGoogle1 = original.StaticGoogle1;
            clone.clientjoin = original.clientjoin;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    ItsNotRealMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ItsNotRealMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                ItsNotRealMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

