/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidybinds.core;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aaavein.tidybinds.TidyBinds;
import net.aaavein.tidybinds.config.TidyBindsConfig;
import net.aaavein.tidybinds.util.KeyMappingHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;

public final class KeyBindManager {
    public static final String HIDDEN_CATEGORY = "key.categories.tidybinds.hidden";
    private static final Map<KeyMapping, String> originalCategories = new HashMap<KeyMapping, String>();
    private static boolean hasSnapshotted = false;

    private KeyBindManager() {
    }

    public static KeyMapping getKeyByName(String name) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options == null) {
            return null;
        }
        for (KeyMapping key : mc.options.keyMappings) {
            if (!key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    public static Set<String> getHiddenKeyNames() {
        HashSet<String> hidden = new HashSet<String>((Collection)TidyBindsConfig.HIDDEN_KEYS.get());
        for (String combo : (List)TidyBindsConfig.KEY_COMBINATIONS.get()) {
            String[] parts = combo.split(";", 2);
            if (parts.length != 2) continue;
            for (String link : parts[1].split(",")) {
                hidden.add(link.trim());
            }
        }
        return hidden;
    }

    public static void applyConfiguration() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options == null) {
            return;
        }
        if (((Boolean)TidyBindsConfig.LOG_ACTIONS.get()).booleanValue()) {
            TidyBinds.LOGGER.info("Applying TidyBinds configuration...");
        }
        KeyBindManager.snapshotOriginalCategories(mc);
        KeyBindManager.resetCategories();
        KeyBindManager.applyCategoryMoves();
        Set<String> hiddenKeys = KeyBindManager.getHiddenKeyNames();
        if (((Boolean)TidyBindsConfig.DISPLAY_HIDDEN_KEYS.get()).booleanValue()) {
            KeyBindManager.moveToHiddenCategory(mc, hiddenKeys);
        }
        if (((Boolean)TidyBindsConfig.UNBIND_HIDDEN_KEYS.get()).booleanValue()) {
            KeyBindManager.unbindHiddenKeys(mc, hiddenKeys);
        }
        KeyBindManager.applyCategoryOrdering();
        KeyBindManager.registerNewCategories(mc);
        if (((Boolean)TidyBindsConfig.PRINT_KEYS.get()).booleanValue()) {
            KeyBindManager.printKeys(mc);
        }
        if (((Boolean)TidyBindsConfig.PRINT_CATEGORIES.get()).booleanValue()) {
            KeyBindManager.printCategories();
        }
    }

    private static void snapshotOriginalCategories(Minecraft mc) {
        if (hasSnapshotted) {
            return;
        }
        for (KeyMapping key : mc.options.keyMappings) {
            originalCategories.put(key, key.getCategory());
        }
        hasSnapshotted = true;
    }

    private static void resetCategories() {
        for (Map.Entry<KeyMapping, String> entry : originalCategories.entrySet()) {
            KeyMappingHelper.setCategory(entry.getKey(), entry.getValue());
        }
    }

    private static void applyCategoryMoves() {
        for (String entry : (List)TidyBindsConfig.KEY_CATEGORIES.get()) {
            String[] parts = entry.split(";", 2);
            if (parts.length != 2) continue;
            String keyName = parts[0].trim();
            String category = parts[1].trim();
            KeyMapping key = KeyBindManager.getKeyByName(keyName);
            if (key == null) continue;
            KeyMappingHelper.setCategory(key, category);
            if (!((Boolean)TidyBindsConfig.LOG_ACTIONS.get()).booleanValue()) continue;
            TidyBinds.LOGGER.info("Moved key '{}' to category '{}'", (Object)keyName, (Object)category);
        }
    }

    private static void moveToHiddenCategory(Minecraft mc, Set<String> hiddenKeys) {
        Set<String> categories = KeyMappingHelper.getCategoriesSet();
        if (categories != null) {
            categories.add(HIDDEN_CATEGORY);
        }
        for (KeyMapping key : mc.options.keyMappings) {
            if (!hiddenKeys.contains(key.getName())) continue;
            KeyMappingHelper.setCategory(key, HIDDEN_CATEGORY);
            if (!((Boolean)TidyBindsConfig.LOG_ACTIONS.get()).booleanValue()) continue;
            TidyBinds.LOGGER.info("Moved hidden key '{}' to hidden category", (Object)key.getName());
        }
    }

    private static void unbindHiddenKeys(Minecraft mc, Set<String> hiddenKeys) {
        for (KeyMapping key : mc.options.keyMappings) {
            if (!hiddenKeys.contains(key.getName())) continue;
            key.setKey(InputConstants.UNKNOWN);
            if (!((Boolean)TidyBindsConfig.LOG_ACTIONS.get()).booleanValue()) continue;
            TidyBinds.LOGGER.info("Unbound hidden key '{}'", (Object)key.getName());
        }
    }

    private static void applyCategoryOrdering() {
        Map<String, Integer> sortOrder = KeyMappingHelper.getSortOrderMap();
        Set<String> categories = KeyMappingHelper.getCategoriesSet();
        if (sortOrder == null || categories == null) {
            return;
        }
        for (String entry : (List)TidyBindsConfig.CATEGORY_ORDER.get()) {
            String[] parts = entry.split(";", 2);
            if (parts.length != 2) continue;
            try {
                String category = parts[0].trim();
                int order = Integer.parseInt(parts[1].trim());
                sortOrder.put(category, order);
                if (!((Boolean)TidyBindsConfig.LOG_ACTIONS.get()).booleanValue()) continue;
                TidyBinds.LOGGER.info("Set category '{}' order to {}", (Object)category, (Object)order);
            }
            catch (NumberFormatException e) {
                TidyBinds.LOGGER.warn("Invalid category order value: {}", (Object)entry);
            }
        }
        categories.clear();
        categories.addAll(sortOrder.keySet());
    }

    private static void registerNewCategories(Minecraft mc) {
        Set<String> categories = KeyMappingHelper.getCategoriesSet();
        if (categories == null) {
            return;
        }
        for (KeyMapping key : mc.options.keyMappings) {
            categories.add(key.getCategory());
        }
    }

    private static void printKeys(Minecraft mc) {
        TidyBinds.LOGGER.info("Available keys:");
        Arrays.stream(mc.options.keyMappings).map(KeyMapping::getName).sorted().forEach(name -> TidyBinds.LOGGER.info("  {}", name));
    }

    private static void printCategories() {
        TidyBinds.LOGGER.info("Available categories:");
        Set<String> categories = KeyMappingHelper.getCategoriesSet();
        if (categories != null) {
            categories.stream().sorted().forEach(name -> TidyBinds.LOGGER.info("  {}", name));
        }
    }
}

