/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidybinds.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aaavein.tidybinds.config.TidyBindsConfig;
import net.aaavein.tidybinds.core.KeyBindManager;
import net.aaavein.tidybinds.util.KeyMappingHelper;
import net.minecraft.client.KeyMapping;

public final class KeyCombinationHandler {
    private static final Map<KeyMapping, List<KeyMapping>> activeCombinations = new HashMap<KeyMapping, List<KeyMapping>>();

    private KeyCombinationHandler() {
    }

    public static void reload() {
        activeCombinations.clear();
        for (String entry : (List)TidyBindsConfig.KEY_COMBINATIONS.get()) {
            KeyMapping trigger;
            String[] parts = entry.split(";", 2);
            if (parts.length != 2 || (trigger = KeyBindManager.getKeyByName(parts[0].trim())) == null) continue;
            ArrayList<KeyMapping> links = new ArrayList<KeyMapping>();
            for (String linkName : parts[1].split(",")) {
                KeyMapping link = KeyBindManager.getKeyByName(linkName.trim());
                if (link == null) continue;
                links.add(link);
            }
            if (links.isEmpty()) continue;
            activeCombinations.put(trigger, links);
        }
    }

    public static void tick() {
        if (activeCombinations.isEmpty()) {
            return;
        }
        for (Map.Entry<KeyMapping, List<KeyMapping>> entry : activeCombinations.entrySet()) {
            KeyMapping trigger = entry.getKey();
            List<KeyMapping> links = entry.getValue();
            boolean isTriggerDown = trigger.isDown();
            int triggerClicks = KeyMappingHelper.getClickCount(trigger);
            for (KeyMapping link : links) {
                int linkClicks;
                if (link.isDown() != isTriggerDown) {
                    link.setDown(isTriggerDown);
                }
                if (triggerClicks <= 0 || (linkClicks = KeyMappingHelper.getClickCount(link)) >= triggerClicks) continue;
                KeyMappingHelper.setClickCount(link, triggerClicks);
            }
        }
    }
}

