/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidybinds.util;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import net.aaavein.tidybinds.TidyBinds;
import net.minecraft.client.KeyMapping;

public final class KeyMappingHelper {
    private static Field clickCountField;
    private static Field categorySortOrderField;
    private static Field categoriesField;
    private static Field categoryField;
    private static boolean initialized;
    private static boolean initFailed;

    private KeyMappingHelper() {
    }

    private static void ensureInitialized() {
        if (initialized || initFailed) {
            return;
        }
        try {
            clickCountField = KeyMapping.class.getDeclaredField("clickCount");
            clickCountField.setAccessible(true);
            categorySortOrderField = KeyMapping.class.getDeclaredField("CATEGORY_SORT_ORDER");
            categorySortOrderField.setAccessible(true);
            categoriesField = KeyMapping.class.getDeclaredField("CATEGORIES");
            categoriesField.setAccessible(true);
            categoryField = KeyMapping.class.getDeclaredField("category");
            categoryField.setAccessible(true);
            initialized = true;
        }
        catch (NoSuchFieldException e) {
            TidyBinds.LOGGER.error("Failed to initialize KeyMapping reflection - field not found", (Throwable)e);
            initFailed = true;
        }
        catch (SecurityException e) {
            TidyBinds.LOGGER.error("Failed to initialize KeyMapping reflection - security exception", (Throwable)e);
            initFailed = true;
        }
    }

    public static void setCategory(KeyMapping key, String newCategory) {
        KeyMappingHelper.ensureInitialized();
        if (categoryField == null) {
            return;
        }
        try {
            categoryField.set(key, newCategory);
        }
        catch (IllegalAccessException e) {
            TidyBinds.LOGGER.error("Failed to set category for key '{}'", (Object)key.getName(), (Object)e);
        }
    }

    public static int getClickCount(KeyMapping key) {
        KeyMappingHelper.ensureInitialized();
        if (clickCountField == null) {
            return 0;
        }
        try {
            return clickCountField.getInt(key);
        }
        catch (IllegalAccessException e) {
            return 0;
        }
    }

    public static void setClickCount(KeyMapping key, int count) {
        KeyMappingHelper.ensureInitialized();
        if (clickCountField == null) {
            return;
        }
        try {
            clickCountField.setInt(key, count);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static Map<String, Integer> getSortOrderMap() {
        KeyMappingHelper.ensureInitialized();
        if (categorySortOrderField == null) {
            return null;
        }
        try {
            return (Map)categorySortOrderField.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Set<String> getCategoriesSet() {
        KeyMappingHelper.ensureInitialized();
        if (categoriesField == null) {
            return null;
        }
        try {
            return (Set)categoriesField.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    static {
        initialized = false;
        initFailed = false;
    }
}

