/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidybinds.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aaavein.tidybinds.config.ClientConfig;
import net.aaavein.tidybinds.core.KeyBindsManager;
import net.aaavein.tidybinds.util.KeyReflection;
import net.minecraft.client.KeyMapping;

public class InputHandler {
    private static Map<KeyMapping, List<KeyMapping>> activeCombinations = null;

    public static void reloadCombinations() {
        activeCombinations = new HashMap<KeyMapping, List<KeyMapping>>();
        for (String s : (List)ClientConfig.KEY_COMBINATIONS.get()) {
            KeyMapping trigger;
            String[] parts = s.split(";");
            if (parts.length != 2 || (trigger = KeyBindsManager.getKeyByName(parts[0].trim())) == null) continue;
            ArrayList<KeyMapping> links = new ArrayList<KeyMapping>();
            for (String linkName : parts[1].split(",")) {
                KeyMapping link = KeyBindsManager.getKeyByName(linkName.trim());
                if (link == null) continue;
                links.add(link);
            }
            if (links.isEmpty()) continue;
            activeCombinations.put(trigger, links);
        }
    }

    public static void handleTick() {
        if (activeCombinations == null) {
            return;
        }
        for (Map.Entry<KeyMapping, List<KeyMapping>> entry : activeCombinations.entrySet()) {
            KeyMapping trigger = entry.getKey();
            List<KeyMapping> links = entry.getValue();
            boolean isTriggerDown = trigger.isDown();
            int triggerClicks = KeyReflection.getClickCount(trigger);
            for (KeyMapping link : links) {
                int linkClicks;
                if (link.isDown() != isTriggerDown) {
                    link.setDown(isTriggerDown);
                }
                if (triggerClicks <= 0 || (linkClicks = KeyReflection.getClickCount(link)) >= triggerClicks) continue;
                KeyReflection.setClickCount(link, triggerClicks);
            }
        }
    }
}

