/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidybinds.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aaavein.tidybinds.TidyBinds;
import net.aaavein.tidybinds.config.ClientConfig;
import net.aaavein.tidybinds.util.KeyReflection;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Logger;

public class KeyBindsManager {
    public static final String HIDDEN_CATEGORY = "key.categories.tidybinds.hidden";
    private static final Map<KeyMapping, String> vanillaCategories = new HashMap<KeyMapping, String>();
    private static boolean capturedVanillaState = false;

    public static KeyMapping getKeyByName(String name) {
        if (Minecraft.getInstance().options == null) {
            return null;
        }
        for (KeyMapping key : Minecraft.getInstance().options.keyMappings) {
            if (!key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    public static void applyConfiguration() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options == null) {
            return;
        }
        if (((Boolean)ClientConfig.LOG_ACTIONS.get()).booleanValue()) {
            TidyBinds.LOGGER.info("Applying TidyBinds configuration...");
        }
        if (!capturedVanillaState) {
            for (KeyMapping key : mc.options.keyMappings) {
                vanillaCategories.put(key, key.getCategory());
            }
            capturedVanillaState = true;
        }
        for (Map.Entry entry : vanillaCategories.entrySet()) {
            KeyReflection.setCategory((KeyMapping)entry.getKey(), (String)entry.getValue());
        }
        KeyBindsManager.applyCategoryMoves();
        if (((Boolean)ClientConfig.SHOW_HIDDEN_KEYS.get()).booleanValue()) {
            KeyBindsManager.moveHiddenKeysToDebugCategory(mc);
        }
        KeyBindsManager.applyCategoryReordering();
        Set<String> knownCategories = KeyReflection.getCategoriesSet();
        if (knownCategories != null) {
            for (KeyMapping key : mc.options.keyMappings) {
                knownCategories.add(key.getCategory());
            }
        }
        if (((Boolean)ClientConfig.PRINT_KEYS.get()).booleanValue()) {
            KeyBindsManager.printDebugKeys(mc);
        }
        if (((Boolean)ClientConfig.PRINT_CATEGORIES.get()).booleanValue()) {
            KeyBindsManager.printDebugCategories();
        }
    }

    private static void applyCategoryMoves() {
        for (String entry : (List)ClientConfig.KEY_CATEGORIES.get()) {
            KeyMapping key;
            String[] parts = entry.split(";");
            if (parts.length != 2 || (key = KeyBindsManager.getKeyByName(parts[0].trim())) == null) continue;
            KeyReflection.setCategory(key, parts[1].trim());
        }
    }

    private static void applyCategoryReordering() {
        Map<String, Integer> sortOrder = KeyReflection.getSortOrderMap();
        Set<String> categories = KeyReflection.getCategoriesSet();
        if (sortOrder == null || categories == null) {
            return;
        }
        for (String entry : (List)ClientConfig.CATEGORY_ORDER.get()) {
            String[] parts = entry.split(";");
            if (parts.length != 2) continue;
            try {
                sortOrder.put(parts[0].trim(), Integer.parseInt(parts[1].trim()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        categories.clear();
        categories.addAll(sortOrder.keySet());
    }

    private static void moveHiddenKeysToDebugCategory(Minecraft mc) {
        HashSet keysToHide = new HashSet((Collection)ClientConfig.HIDE_KEYS.get());
        for (String combo : (List)ClientConfig.KEY_COMBINATIONS.get()) {
            String[] parts = combo.split(";");
            if (parts.length != 2) continue;
            Collections.addAll(keysToHide, parts[1].split(","));
        }
        String debugCategory = HIDDEN_CATEGORY;
        Set<String> cats = KeyReflection.getCategoriesSet();
        if (cats != null) {
            cats.add(debugCategory);
        }
        for (KeyMapping key : mc.options.keyMappings) {
            if (!keysToHide.contains(key.getName())) continue;
            KeyReflection.setCategory(key, debugCategory);
            if (!((Boolean)ClientConfig.LOG_ACTIONS.get()).booleanValue()) continue;
            TidyBinds.LOGGER.info("Moved hidden key {} to debug category", (Object)key.getName());
        }
    }

    private static void printDebugKeys(Minecraft mc) {
        TidyBinds.LOGGER.info("--- Available Keys ---");
        Arrays.stream(mc.options.keyMappings).map(KeyMapping::getName).sorted().forEach(arg_0 -> ((Logger)TidyBinds.LOGGER).info(arg_0));
    }

    private static void printDebugCategories() {
        TidyBinds.LOGGER.info("--- Available Categories ---");
        Set<String> cats = KeyReflection.getCategoriesSet();
        if (cats != null) {
            cats.stream().sorted().forEach(arg_0 -> ((Logger)TidyBinds.LOGGER).info(arg_0));
        }
    }
}

