/*
 * Decompiled with CFR 0.152.
 */
package net.dented.tmadw.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.dented.tmadw.TeamworkMakesADreamWorkMod;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static String teamCharterNameChangePrefixString = "name=";
    public static String teamCharterPrefixChangePrefixString = "prefix=";
    public static String teamCharterSuffixChangePrefixString = "suffix=";
    public static String teamRevokingTokenPlayerChangePrefixString = "player=";
    public static String teamRevokingTokenRevertString = "revert";
    private static final transient Gson GSON = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).serializeNulls().serializeSpecialFloatingPointValues().setPrettyPrinting().setLenient().create();

    public static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("tmadw.json");
    }

    public static void loadConfigFromFile() {
        Path configPath = Config.getConfigPath();
        try {
            GSON.fromJson(Files.readString(configPath), Config.class);
        }
        catch (IOException e) {
            TeamworkMakesADreamWorkMod.LOGGER.warn("Failed to read config file from " + String.valueOf(configPath), (Throwable)e);
        }
    }

    public static void writeConfigToFile() {
        Path configPath = Config.getConfigPath();
        try {
            String jsonString = GSON.toJson((Object)new Config());
            Files.writeString(configPath, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (IOException e) {
            TeamworkMakesADreamWorkMod.LOGGER.warn("Failed to write config file to " + String.valueOf(configPath), (Throwable)e);
        }
    }
}

