/*
 * Decompiled with CFR 0.152.
 */
package com.barby.ignshistoryplus;

import com.barby.ignshistoryplus.IgnsHistoryPlus;
import com.barby.ignshistoryplus.gui.NameHistoryScreen;
import com.barby.ignshistoryplus.mixin.MinecraftClientAccessor;
import com.barby.ignshistoryplus.util.CraftyApi;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5599;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_7497;
import net.minecraft.class_8765;

public class IgnsHistoryPlusClient
implements ClientModInitializer {
    private static final Gson GSON = new Gson();

    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"igns").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> IgnsHistoryPlusClient.suggestOnlinePlayers(builder)).executes(ctx -> {
                String username = StringArgumentType.getString((CommandContext)ctx, (String)"username");
                this.handleLookup(username, true);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"names").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> IgnsHistoryPlusClient.suggestOnlinePlayers(builder)).executes(ctx -> {
                String username = StringArgumentType.getString((CommandContext)ctx, (String)"username");
                this.handleLookup(username, true);
                return 1;
            })));
        });
    }

    private void handleLookup(String username, boolean showHead) {
        class_310.method_1551().execute(() -> {
            class_310.method_1551().method_1507(null);
            this.sendChat(class_2561.method_30163((String)("\u00a7eSearching for player " + username + "...")));
        });
        new Thread(() -> {
            try {
                UUID fetched;
                boolean success;
                String body = CraftyApi.getPlayerJson(username);
                if (body == null) {
                    this.sendChat(class_2561.method_30163((String)"\u00a7cFailed to contact the API. Please try again later."));
                    return;
                }
                JsonObject root = (JsonObject)GSON.fromJson(body, JsonObject.class);
                boolean bl = success = root.has("success") && root.get("success").getAsBoolean();
                if (!success) {
                    this.sendChat(class_2561.method_30163((String)"\u00a7cPlayer not found."));
                    return;
                }
                if (!root.has("data") || !root.get("data").isJsonObject()) {
                    this.sendChat(class_2561.method_30163((String)"\u00a7cInvalid response from API."));
                    return;
                }
                JsonObject data = root.getAsJsonObject("data");
                String canonical = data.has("username") && !data.get("username").isJsonNull() ? data.get("username").getAsString() : username;
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<String> dates = new ArrayList<String>();
                if (data.has("usernames") && data.get("usernames").isJsonArray()) {
                    JsonArray arr = data.getAsJsonArray("usernames");
                    for (int i = 0; i < arr.size(); ++i) {
                        JsonObject entry = arr.get(i).getAsJsonObject();
                        if (!entry.has("username") || entry.get("username").isJsonNull()) continue;
                        names.add(entry.get("username").getAsString());
                        if (entry.has("changedToAt") && !entry.get("changedToAt").isJsonNull()) {
                            try {
                                long ts = entry.get("changedToAt").getAsLong();
                                if (ts < 1000000000000L) {
                                    ts *= 1000L;
                                }
                                LocalDate date = Instant.ofEpochMilli(ts).atZone(ZoneId.systemDefault()).toLocalDate();
                                dates.add(date.toString());
                            }
                            catch (Exception e) {
                                dates.add("");
                            }
                            continue;
                        }
                        dates.add("");
                    }
                }
                String uuidStr = null;
                if (data.has("uuid") && !data.get("uuid").isJsonNull()) {
                    uuidStr = data.get("uuid").getAsString();
                } else if (data.has("id") && !data.get("id").isJsonNull()) {
                    uuidStr = data.get("id").getAsString();
                }
                String finalCanonical = canonical;
                List finalNames = List.copyOf(names);
                List finalDates = List.copyOf(dates);
                String resolvedUuid = uuidStr;
                if ((resolvedUuid == null || resolvedUuid.isEmpty()) && finalCanonical != null && !finalCanonical.isEmpty() && (fetched = this.fetchMojangUuid(finalCanonical)) != null) {
                    resolvedUuid = fetched.toString();
                }
                String finalUuid = resolvedUuid;
                int finalTotal = names.size();
                boolean finalShowHead = showHead;
                GameProfile fullProfile = null;
                if (finalShowHead) {
                    try {
                        YggdrasilAuthenticationService authService = ((MinecraftClientAccessor)class_310.method_1551()).getAuthenticationService();
                        class_7497 services = class_7497.method_44143((YggdrasilAuthenticationService)authService, (File)class_310.method_1551().field_1697);
                        GameProfile basicProfile = this.fetchProfile(finalCanonical, services).join();
                        if (basicProfile != null) {
                            fullProfile = Optional.ofNullable(services.comp_837().fetchProfile(basicProfile.getId(), true)).map(ProfileResult::profile).orElseGet(() -> new GameProfile(UUID.randomUUID(), finalCanonical));
                        }
                    }
                    catch (Exception e) {
                        fullProfile = null;
                    }
                }
                GameProfile resolvedProfile = fullProfile;
                class_310.method_1551().execute(() -> {
                    class_8765 skinWidget = null;
                    if (finalShowHead) {
                        try {
                            GameProfile profile = resolvedProfile != null ? resolvedProfile : new GameProfile(UUID.randomUUID(), finalCanonical);
                            Supplier supplier = class_310.method_1551().method_1582().method_52858(profile);
                            class_5599 entityModels = class_310.method_1551().method_31974();
                            skinWidget = new class_8765(80, 160, entityModels, supplier);
                        }
                        catch (Exception ignored) {
                            skinWidget = null;
                        }
                    }
                    class_310.method_1551().method_1507((class_437)new NameHistoryScreen(finalCanonical, finalUuid, finalNames, finalDates, finalTotal, skinWidget));
                });
            }
            catch (Exception e) {
                IgnsHistoryPlus.LOGGER.error("Lookup failed", (Throwable)e);
                this.sendChat(class_2561.method_30163((String)"\u00a7cAn error occurred while contacting the API. Please try again."));
            }
        }, "ignshistoryplus-lookup").start();
    }

    private void sendChat(class_2561 message) {
        class_310.method_1551().execute(() -> class_310.method_1551().field_1705.method_1743().method_1812(message));
    }

    private UUID fetchMojangUuid(String username) {
        try {
            String raw;
            JsonObject obj;
            HttpClient client = HttpClient.newHttpClient();
            URI uri = URI.create("https://api.mojang.com/users/profiles/minecraft/" + username);
            HttpRequest req = HttpRequest.newBuilder().uri(uri).header("User-Agent", "IGNSHistoryPlus-Mod/1.0").GET().build();
            HttpResponse<String> resp = client.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() == 200 && (obj = (JsonObject)GSON.fromJson(resp.body(), JsonObject.class)) != null && obj.has("id") && (raw = obj.get("id").getAsString()).length() == 32) {
                String uuidStr = raw.replaceFirst("([0-9a-fA-F]{8})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]+)", "$1-$2-$3-$4-$5");
                return UUID.fromString(uuidStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private CompletableFuture<GameProfile> fetchProfile(String username, class_7497 services) {
        final CompletableFuture<GameProfile> future = new CompletableFuture<GameProfile>();
        try {
            services.comp_839().findProfilesByNames(new String[]{username}, new ProfileLookupCallback(){

                public void onProfileLookupSucceeded(GameProfile profile) {
                    future.complete(profile);
                }

                public void onProfileLookupFailed(String profileName, Exception exception) {
                    future.completeExceptionally(exception);
                }
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private static CompletableFuture<Suggestions> suggestOnlinePlayers(SuggestionsBuilder builder) {
        class_310 client = class_310.method_1551();
        class_634 handler = client.method_1562();
        List names = handler != null ? handler.method_2880().stream().map(class_640::method_2966).map(GameProfile::getName).filter(name -> name != null).toList() : List.of();
        return class_2172.method_9265(names, (SuggestionsBuilder)builder);
    }
}

