/*
 * Decompiled with CFR 0.152.
 */
package com.barby.ignshistoryplus.gui;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_8765;

public class NameHistoryScreen
extends class_437 {
    private final String username;
    private final String uuid;
    private final List<String> names;
    private final List<String> dates;
    private final int total;
    private final class_8765 skinWidget;
    private int scrollIndex = 0;
    private int copyX;
    private int copyY;
    private int copyW;
    private int copyH;
    private static final int DEFAULT_SKIN_WIDTH = 80;
    private static final int DEFAULT_SKIN_HEIGHT = 160;
    private static final int SKIN_OFFSET_X = -25;
    private static final int SKIN_OFFSET_Y = 20;
    private static final class_2960 LOGO = class_2960.method_60655((String)"ignshistory_plus", (String)"crafty_logo.png");
    private static final int LOGO_WIDTH = 102;
    private static final int LOGO_HEIGHT = 40;

    public NameHistoryScreen(String username, String uuid, List<String> names, List<String> dates, int total, class_8765 skinWidget) {
        super((class_2561)class_2561.method_43470((String)"Name History"));
        this.username = username;
        this.uuid = uuid;
        this.names = names;
        this.dates = dates;
        this.total = total;
        this.skinWidget = skinWidget;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        int index;
        int xStart;
        this.method_25420(drawContext, mouseX, mouseY, delta);
        super.method_25394(drawContext, mouseX, mouseY, delta);
        int gap = 10;
        Objects.requireNonNull(this.field_22793);
        int rowHeight = 9 + 2;
        int maxNameWidth = 0;
        for (int i = 0; i < this.names.size(); ++i) {
            String date;
            String entry = this.names.get(i);
            String text = "- " + entry + (String)((date = this.dates != null && i < this.dates.size() ? this.dates.get(i) : "") != null && !date.isEmpty() ? " (" + date + ")" : "");
            int width = this.field_22793.method_1727(text);
            if (width <= maxNameWidth) continue;
            maxNameWidth = width;
        }
        int columnWidth = maxNameWidth + 20;
        int infoLines = 4;
        Objects.requireNonNull(this.field_22793);
        int infoHeight = infoLines * (9 + 2);
        int topMargin = Math.max(0, this.field_22790 / 6 - 40);
        int availableHeight = this.field_22790 - topMargin - infoHeight - 20;
        int maxRows = Math.max(1, availableHeight / rowHeight);
        int rowsToShow = Math.min(maxRows, this.names.size());
        int columns = 1;
        int skinW = 0;
        int skinH = 0;
        if (this.skinWidget != null) {
            skinW = this.skinWidget.method_25368();
            skinH = this.skinWidget.method_25364();
            if (skinW <= 0) {
                skinW = 80;
            }
            if (skinH <= 0) {
                skinH = 160;
            }
        }
        int logoW = 102;
        int logoH = 40;
        int totalWidth = (this.skinWidget != null ? skinW : 0) + (this.skinWidget != null ? gap : 0) + columns * columnWidth;
        int xSkin = xStart = (this.field_22789 - totalWidth) / 2;
        int xTextStart = xStart + (this.skinWidget != null ? skinW + gap : 0);
        int yStart = topMargin;
        int logoXCentered = xTextStart + (columnWidth - 102) / 2;
        drawContext.method_25290(LOGO, logoXCentered - 5, yStart - 10, 0.0f, 0.0f, 102, 40, 102, 40);
        int infoY = yStart + 40 + 4;
        if (this.skinWidget != null) {
            this.skinWidget.method_48229(xSkin + -25, infoY + 20);
            this.skinWidget.method_25394(drawContext, mouseX, mouseY, delta);
        }
        int y = infoY;
        String userLine = "Username: " + this.username;
        drawContext.method_51433(this.field_22793, userLine, xTextStart, y, 0xFFFFFF, false);
        Objects.requireNonNull(this.field_22793);
        y += 9 + 2;
        if (this.uuid != null && !this.uuid.isEmpty()) {
            String label = "UUID: ";
            int labelWidth = this.field_22793.method_1727(label);
            drawContext.method_51433(this.field_22793, label, xTextStart, y, 0xFFFFFF, false);
            int uuidX = xTextStart + labelWidth;
            int uuidColor = 65416;
            drawContext.method_51433(this.field_22793, this.uuid, uuidX, y, uuidColor, false);
            String copyText = " [copy]";
            int uuidWidth = this.field_22793.method_1727(this.uuid);
            this.copyX = uuidX + uuidWidth;
            this.copyY = y;
            this.copyW = this.field_22793.method_1727(copyText);
            Objects.requireNonNull(this.field_22793);
            this.copyH = 9;
            drawContext.method_51433(this.field_22793, copyText, this.copyX, this.copyY, 0x66CCFF, false);
        } else {
            this.copyH = 0;
            this.copyW = 0;
            this.copyY = 0;
            this.copyX = 0;
        }
        Objects.requireNonNull(this.field_22793);
        String totalLine = "Total Names: " + this.total;
        drawContext.method_51433(this.field_22793, totalLine, xTextStart, y += 9 + 2, 0xFFFFFF, false);
        Objects.requireNonNull(this.field_22793);
        drawContext.method_51433(this.field_22793, "Previous Names:", xTextStart, y += 9 + 4, 0xAAAAFF, false);
        Objects.requireNonNull(this.field_22793);
        int namesStartX = xTextStart;
        int namesStartY = (y += 9 + 2) + 2;
        int namesAreaWidth = columnWidth;
        int namesAreaHeight = rowsToShow * rowHeight;
        int bgX1 = namesStartX - 4;
        int bgY1 = namesStartY - 2;
        int bgX2 = namesStartX + namesAreaWidth + 4;
        int bgY2 = namesStartY + namesAreaHeight + 2;
        drawContext.method_25294(bgX1, bgY1, bgX2, bgY2, 0x44000000);
        int borderCol = 0x55FFFFFF;
        drawContext.method_25294(bgX1, bgY1, bgX2, bgY1 + 1, borderCol);
        drawContext.method_25294(bgX1, bgY2 - 1, bgX2, bgY2, borderCol);
        drawContext.method_25294(bgX1, bgY1, bgX1 + 1, bgY2, borderCol);
        drawContext.method_25294(bgX2 - 1, bgY1, bgX2, bgY2, borderCol);
        int maxScroll = Math.max(0, this.names.size() - rowsToShow);
        if (this.scrollIndex > maxScroll) {
            this.scrollIndex = maxScroll;
        }
        if (this.scrollIndex < 0) {
            this.scrollIndex = 0;
        }
        int yRow = namesStartY;
        for (int row = 0; row < rowsToShow && (index = this.scrollIndex + row) < this.names.size(); ++row) {
            String entry = this.names.get(index);
            String date = this.dates != null && index < this.dates.size() ? this.dates.get(index) : "";
            String text = "- " + entry + (String)(date != null && !date.isEmpty() ? " (" + date + ")" : "");
            drawContext.method_51433(this.field_22793, text, namesStartX, yRow, 0xFFFFFF, false);
            yRow += rowHeight;
        }
        if (this.names.size() > rowsToShow) {
            float visibleRatio = (float)rowsToShow / (float)this.names.size();
            int barHeight = Math.max(4, (int)((float)namesAreaHeight * visibleRatio));
            int trackHeight = namesAreaHeight - barHeight;
            int maxScrollInt = Math.max(1, this.names.size() - rowsToShow);
            float scrollRatio = (float)this.scrollIndex / (float)maxScrollInt;
            int barY = namesStartY + (int)((float)trackHeight * scrollRatio);
            int barX = namesStartX + namesAreaWidth + 4;
            int trackColor = -2131824914;
            int thumbColor = -3158065;
            drawContext.method_25294(barX, namesStartY, barX + 4, namesStartY + namesAreaHeight, trackColor);
            drawContext.method_25294(barX, barY, barX + 4, barY + barHeight, thumbColor);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.uuid != null && !this.uuid.isEmpty() && mouseX >= (double)this.copyX && mouseX <= (double)(this.copyX + this.copyW) && mouseY >= (double)this.copyY && mouseY <= (double)(this.copyY + this.copyH)) {
            class_310 client = class_310.method_1551();
            client.field_1774.method_1455(this.uuid);
            client.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            client.field_1705.method_1743().method_1812(class_2561.method_30163((String)"\u00a7aUUID copied to clipboard"));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int topMargin = Math.max(0, this.field_22790 / 6 - 40);
        Objects.requireNonNull(this.field_22793);
        int rowHeight = 9 + 2;
        int infoLines = 4;
        Objects.requireNonNull(this.field_22793);
        int infoHeight = infoLines * (9 + 2);
        int availableHeight = this.field_22790 - topMargin - infoHeight - 20;
        int maxRows = Math.max(1, availableHeight / rowHeight);
        int rowsToShow = Math.min(maxRows, this.names.size());
        if (this.names.size() > rowsToShow) {
            int maxScroll = Math.max(0, this.names.size() - rowsToShow);
            if (verticalAmount < 0.0) {
                this.scrollIndex = Math.min(this.scrollIndex + 1, maxScroll);
            } else if (verticalAmount > 0.0) {
                this.scrollIndex = Math.max(this.scrollIndex - 1, 0);
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25421() {
        return false;
    }
}

