/*
 * Decompiled with CFR 0.152.
 */
package com.barby.ignshistoryplus.util;

import com.barby.ignshistoryplus.IgnsHistoryPlus;
import com.mojang.authlib.GameProfile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1071;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8685;

public final class PlayerSkinUtil {
    private static final HttpClient CLIENT = HttpClient.newHttpClient();

    private PlayerSkinUtil() {
    }

    public static byte[] downloadSkinBytes(String url) {
        try {
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "IGNSHistoryPlus-Mod/1.0").GET().build();
            HttpResponse<byte[]> resp = CLIENT.send(req, HttpResponse.BodyHandlers.ofByteArray());
            if (resp.statusCode() == 200 && resp.body() != null && resp.body().length > 0) {
                return resp.body();
            }
        }
        catch (Exception e) {
            IgnsHistoryPlus.LOGGER.warn("Failed to download skin from {}", (Object)url, (Object)e);
        }
        return null;
    }

    public static class_2960 registerSkinTexture(String username, byte[] pngBytes) {
        if (pngBytes == null || pngBytes.length == 0) {
            return null;
        }
        try {
            class_1011 img = class_1011.method_4309((InputStream)new ByteArrayInputStream(pngBytes));
            class_1043 tex = new class_1043(img);
            class_2960 id = class_2960.method_60655((String)"ignshistory_plus", (String)("skins/" + username.toLowerCase()));
            class_310.method_1551().method_1531().method_4616(id, (class_1044)tex);
            return id;
        }
        catch (Exception e) {
            IgnsHistoryPlus.LOGGER.warn("Failed to register skin texture for {}", (Object)username, (Object)e);
            return null;
        }
    }

    public static class_2960 getOrDownloadSkin(String username) {
        try {
            class_310 client = class_310.method_1551();
            class_1071 provider = client.method_1582();
            GameProfile profile = new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes()), username);
            class_8685 textures = provider.method_52862(profile);
            if (textures == null) {
                return null;
            }
            return textures.comp_1626();
        }
        catch (Exception e) {
            IgnsHistoryPlus.LOGGER.error("Failed to load fallback skin for {}", (Object)username, (Object)e);
            return null;
        }
    }
}

