/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.util.registry;

import java.util.ArrayList;
import java.util.List;
import turniplabs.halplibe.util.registry.Reservation;
import turniplabs.halplibe.util.registry.RunLengthConfig;
import turniplabs.halplibe.util.registry.RunReserves;
import turniplabs.halplibe.util.registry.error.RequestCutShortException;
import turniplabs.halplibe.util.registry.error.RequestOutOfBoundsException;

public class IdSupplier {
    String modId;
    RunReserves reserves;
    RunLengthConfig cfg;
    int max;
    ArrayList<Reservation> reservations = new ArrayList();
    boolean hasUnreserved = false;
    int reservationId = 0;
    int current = 0;
    int done = 0;
    int reservationStart = -1;
    int reservationEnd = -1;

    public IdSupplier(String modId, RunReserves reserves, RunLengthConfig cfg, int max) {
        this.modId = modId;
        this.reserves = reserves;
        this.cfg = cfg;
        this.max = max;
        if (cfg.reservations[0].reserved) {
            this.reservations.add(cfg.reservations[0]);
            this.reservationStart = cfg.reservations[0].start;
            this.reservationEnd = cfg.reservations[0].end;
        }
        for (Reservation reservation : cfg.reservations) {
            if (reservation.reserved) continue;
            this.hasUnreserved = true;
            break;
        }
    }

    public int next() {
        Reservation workingIn = this.cfg.reservations[this.reservationId];
        if (workingIn.reserved && workingIn.start + this.current > workingIn.end) {
            ++this.reservationId;
            this.current = 0;
            workingIn = this.cfg.reservations[this.reservationId];
            if (workingIn.reserved) {
                this.reservations.add(workingIn);
            }
            this.reservationStart = workingIn.start;
            this.reservationEnd = workingIn.end;
        }
        if (!(workingIn.reserved || this.reservationStart != -1 && this.reservationStart + this.current < this.reservationEnd)) {
            if (this.reservationStart != -1) {
                this.reservations.add(new Reservation(this.reservationStart, this.reservationStart + this.current - 1));
            }
            this.reservationStart = this.reserves.idFinder.apply(0);
            this.reservationEnd = this.reservationStart + this.reserves.runLengthFinder.apply(this.reservationStart, this.max - this.done);
            this.current = 0;
        }
        if (this.done > this.max) {
            throw new RequestOutOfBoundsException(this.modId + " has grabbed more ids than it has requested.");
        }
        ++this.done;
        if (this.done == this.max) {
            int id = this.reservationStart + this.current++;
            this.cfg.write(this.calculateRuns());
            return id;
        }
        return this.reservationStart + this.current++;
    }

    public List<Reservation> calculateRuns() {
        if (!this.cfg.reservations[this.reservationId].reserved && this.reservationStart != -1 && this.current != 0) {
            this.reservations.add(new Reservation(this.reservationStart, this.reservationStart + this.current - 1));
            this.reservationId = -1;
            this.reservationStart = -1;
            this.reservationEnd = -1;
            this.current = 0;
        }
        if (this.hasUnreserved) {
            ArrayList<Reservation> result = new ArrayList<Reservation>();
            Reservation prev = null;
            for (Reservation reservation : this.reservations) {
                if (prev == null) {
                    prev = reservation;
                    result.add(reservation);
                    continue;
                }
                if (prev.end + 1 == reservation.start) {
                    result.remove(result.size() - 1);
                    result.add(new Reservation(prev.start, reservation.end));
                } else {
                    result.add(reservation);
                }
                prev = reservation;
            }
            return result;
        }
        return this.reservations;
    }

    public void ensureFree(int amount) {
        Reservation workingIn = this.cfg.reservations[this.reservationId];
        if (workingIn.reserved) {
            return;
        }
        int remaining = this.reservationEnd - (this.reservationStart + this.current);
        System.out.println(remaining);
        if (remaining >= amount) {
            return;
        }
        if (this.reservationStart != -1) {
            this.reservations.add(new Reservation(this.reservationStart, this.reservationStart + this.current - 1));
        }
        this.reservationStart = this.reserves.idFinder.apply(amount);
        this.reservationEnd = this.reservationStart + this.reserves.runLengthFinder.apply(this.reservationStart, this.max - this.done);
        this.current = 0;
    }

    public void validate() {
        if (this.done != this.max) {
            throw new RequestCutShortException(this.modId + " did not use up all requested ids.");
        }
    }
}

