/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.repo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.NonNull;
import moe.nea.firmament.deps.repo.IReloadable;
import moe.nea.firmament.deps.repo.NEUConstants;
import moe.nea.firmament.deps.repo.NEUItems;
import moe.nea.firmament.deps.repo.NEURepoFile;
import moe.nea.firmament.deps.repo.NEURepositoryException;
import moe.nea.firmament.deps.repo.data.Coordinate;
import moe.nea.firmament.deps.repo.data.NEUCraftingRecipe;
import moe.nea.firmament.deps.repo.data.NEUForgeRecipe;
import moe.nea.firmament.deps.repo.data.NEUIngredient;
import moe.nea.firmament.deps.repo.data.NEUKatUpgradeRecipe;
import moe.nea.firmament.deps.repo.data.NEUMobDropRecipe;
import moe.nea.firmament.deps.repo.data.NEUNpcShopRecipe;
import moe.nea.firmament.deps.repo.data.NEURecipe;
import moe.nea.firmament.deps.repo.data.NEUTradeRecipe;
import moe.nea.firmament.deps.repo.data.NEUUnknownRecipe;
import moe.nea.firmament.deps.repo.vendored.RuntimeTypeAdapterFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NEURepository {
    final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(new TypeToken<NEUUnknownRecipe>(){}.getType(), (Object)new NEUUnknownRecipe.Serializer()).registerTypeAdapter(new TypeToken<NEUIngredient>(){}.getType(), (Object)new NEUIngredient.Serializer()).registerTypeAdapter(new TypeToken<Coordinate>(){}.getType(), (Object)new Coordinate.CoordinateSerializer()).registerTypeAdapter(new TypeToken<NEUMobDropRecipe.Drop>(){}.getType(), (Object)new NEUMobDropRecipe.Drop.Serializer()).registerTypeAdapter(new TypeToken<NEUCraftingRecipe>(){}.getType(), (Object)new NEUCraftingRecipe.Serializer()).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(NEURecipe.class, "type", true).registerSubtype(NEUForgeRecipe.class, "forge").registerSubtype(NEUTradeRecipe.class, "trade").registerSubtype(NEUCraftingRecipe.class, "crafting").registerSubtype(NEUMobDropRecipe.class, "drops").registerSubtype(NEUNpcShopRecipe.class, "npc_shop").registerSubtype(NEUKatUpgradeRecipe.class, "katgrade").setFallbackType(NEUUnknownRecipe.class).setDefaultTypeTag("crafting")).create();
    final Path baseFolder;
    final NEUConstants constants;
    final List<IReloadable> reloadables = new ArrayList<IReloadable>();
    final NEUItems items;
    boolean isUnstable = true;
    boolean isIncomplete = true;

    public static NEURepository of(@NonNull Path baseFolder) {
        if (baseFolder == null) {
            throw new NullPointerException("baseFolder is marked non-null but is null");
        }
        return new NEURepository(baseFolder);
    }

    private NEURepository(@NonNull Path baseFolder) {
        if (baseFolder == null) {
            throw new NullPointerException("baseFolder is marked non-null but is null");
        }
        this.baseFolder = baseFolder;
        this.constants = new NEUConstants();
        this.items = new NEUItems();
        this.registerReloadListener(this.constants);
        this.registerReloadListener(this.items);
    }

    public void registerReloadListener(IReloadable reloadable) {
        this.reloadables.add(reloadable);
    }

    public synchronized void reload() throws NEURepositoryException {
        ArrayList<NEURepositoryException> storedExceptions = new ArrayList<NEURepositoryException>();
        this.isUnstable = true;
        for (IReloadable reloadable : this.reloadables) {
            try {
                reloadable.reload(this);
            }
            catch (NEURepositoryException e2) {
                storedExceptions.add(e2);
            }
            catch (Exception e3) {
                storedExceptions.add(new NEURepositoryException("<unknown>", "Invalid non NEU exception thrown during repository reload", e3));
            }
        }
        for (int i2 = 1; i2 < storedExceptions.size(); ++i2) {
            ((NEURepositoryException)storedExceptions.get(0)).addSuppressed((Throwable)storedExceptions.get(i2));
        }
        if (storedExceptions.size() > 0) {
            this.isIncomplete = true;
            throw (NEURepositoryException)storedExceptions.get(0);
        }
        this.isUnstable = false;
        this.isIncomplete = false;
    }

    public NEURepoFile requireFile(@NonNull String path) throws NEURepositoryException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        NEURepoFile file = this.file(path);
        if (file == null) {
            throw new NEURepositoryException(path, "this file is required", null);
        }
        return file;
    }

    public @Nullable NEURepoFile file(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Path fsPath = this.baseFolder.resolve(path);
        if (!Files.isReadable(fsPath)) {
            return null;
        }
        return new NEURepoFile(this, fsPath);
    }

    public Stream<NEURepoFile> tree(@NonNull String path) throws NEURepositoryException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Path fsPath = this.baseFolder.resolve(path);
        if (!Files.isDirectory(fsPath, new LinkOption[0])) {
            return Stream.empty();
        }
        try {
            return Files.walk(fsPath, new FileVisitOption[0]).map(it -> new NEURepoFile(this, (Path)it));
        }
        catch (IOException e2) {
            throw new NEURepositoryException(path, "could not walk directory", e2);
        }
    }

    public Path getBaseFolder() {
        return this.baseFolder;
    }

    public NEUConstants getConstants() {
        return this.constants;
    }

    public List<IReloadable> getReloadables() {
        return this.reloadables;
    }

    public NEUItems getItems() {
        return this.items;
    }

    public boolean isUnstable() {
        return this.isUnstable;
    }

    public boolean isIncomplete() {
        return this.isIncomplete;
    }
}

