/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.init;

import moe.nea.firmament.init.Intermediary;
import moe.nea.firmament.init.RiserUtils;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SectionBuilderRiser
extends RiserUtils {
    Intermediary.InterClass SectionBuilder = Intermediary.ofIntermediaryClass("net.minecraft.class_9810");
    Intermediary.InterClass BlockPos = Intermediary.ofIntermediaryClass("net.minecraft.class_2338");
    Intermediary.InterClass BlockRenderManager = Intermediary.ofIntermediaryClass("net.minecraft.class_776");
    Intermediary.InterClass BlockState = Intermediary.ofIntermediaryClass("net.minecraft.class_2680");
    Intermediary.InterClass BlockStateModel = Intermediary.ofIntermediaryClass("net.minecraft.class_1087");
    String CustomBlockTextures = "moe.nea.firmament.features.texturepack.CustomBlockTextures";
    Intermediary.InterMethod getModel = Intermediary.ofMethod("method_3349", "net/minecraft/class_776", this.BlockStateModel, this.BlockState);

    @Override
    public void addTinkerers() {
        if (FabricLoader.getInstance().isModLoaded("fabric-renderer-indigo")) {
            this.addTransformation(this.SectionBuilder, this::handle, true);
        }
    }

    private void handle(ClassNode classNode) {
        System.out.println("AVAST! " + String.valueOf(this.getModel));
        for (MethodNode method : classNode.methods) {
            if (!method.name.endsWith("$fabric-renderer-indigo$hookBuildRenderBlock") && !method.name.endsWith("$fabric-renderer-indigo$hookChunkBuildTessellate") || !method.name.startsWith("redirect$")) continue;
            this.handleIndigo(method);
            return;
        }
        System.err.println("Could not inject indigo rendering hook. Is a custom renderer installed (e.g. sodium)?");
    }

    private void handleIndigo(MethodNode method) {
        LocalVariableNode blockPosVar = null;
        LocalVariableNode blockStateVar = null;
        for (LocalVariableNode localVariable : method.localVariables) {
            if (Type.getType((String)localVariable.desc).equals((Object)this.BlockPos.mapped())) {
                blockPosVar = localVariable;
            }
            if (!Type.getType((String)localVariable.desc).equals((Object)this.BlockState.mapped())) continue;
            blockStateVar = localVariable;
        }
        if (blockPosVar == null || blockStateVar == null) {
            System.err.println("Firmament could inject into indigo: missing either block pos or blockstate");
            return;
        }
        for (AbstractInsnNode instruction : method.instructions) {
            if (instruction.getOpcode() != 182) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)instruction;
            if (!methodInsn.name.equals(this.getModel.mapped()) || !Type.getObjectType((String)methodInsn.owner).equals((Object)this.BlockRenderManager.mapped())) continue;
            method.instructions.insertBefore((AbstractInsnNode)methodInsn, (AbstractInsnNode)new MethodInsnNode(184, this.getTypeForClassName(this.CustomBlockTextures).getInternalName(), "enterFallbackCall", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0])));
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, this.getTypeForClassName(this.CustomBlockTextures).getInternalName(), "exitFallbackCall", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0])));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, blockPosVar.index));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, blockStateVar.index));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, this.getTypeForClassName(this.CustomBlockTextures).getInternalName(), "patchIndigo", Type.getMethodDescriptor((Type)this.BlockStateModel.mapped(), (Type[])new Type[]{this.BlockStateModel.mapped(), this.BlockPos.mapped(), this.BlockState.mapped()}), false));
            method.instructions.insert((AbstractInsnNode)methodInsn, insnList);
        }
    }
}

