/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.util;

import java.time.ZoneId;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import moe.nea.firmament.events.AllowChatEvent;
import moe.nea.firmament.events.FirmamentEvent;
import moe.nea.firmament.events.ProcessChatEvent;
import moe.nea.firmament.events.ProfileSwitchEvent;
import moe.nea.firmament.events.ServerConnectedEvent;
import moe.nea.firmament.events.SkyblockServerUpdateEvent;
import moe.nea.firmament.util.Locraw;
import moe.nea.firmament.util.MC;
import moe.nea.firmament.util.SkyBlockIsland;
import moe.nea.firmament.util.TimeMark;
import net.hypixel.data.type.ServerType;
import net.hypixel.modapi.HypixelModAPI;
import net.hypixel.modapi.packet.impl.clientbound.event.ClientboundLocationPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R$\u0010\u0016\u001a\u0004\u0018\u00010\u000f8F@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0019R\u001f\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R$\u0010$\u001a\u0004\u0018\u00010#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0013\u0010-\u001a\u0004\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u00100\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u00101\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010/R\"\u00103\u001a\u0002028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108\u00a8\u00069"}, d2={"Lmoe/nea/firmament/util/SBData;", "", "<init>", "()V", "", "init", "Lkotlin/text/Regex;", "profileRegex", "Lkotlin/text/Regex;", "", "", "profileSuggestTexts", "Ljava/util/List;", "getProfileSuggestTexts", "()Ljava/util/List;", "Ljava/util/UUID;", "NULL_UUID", "Ljava/util/UUID;", "getNULL_UUID", "()Ljava/util/UUID;", "getProfileIdOrNil", "profileIdOrNil", "profileId", "getProfileId", "setProfileId", "(Ljava/util/UUID;)V", "Ljava/time/ZoneId;", "kotlin.jvm.PlatformType", "hypixelTimeZone", "Ljava/time/ZoneId;", "getHypixelTimeZone", "()Ljava/time/ZoneId;", "", "hasReceivedProfile", "Z", "Lmoe/nea/firmament/util/Locraw;", "locraw", "Lmoe/nea/firmament/util/Locraw;", "getLocraw", "()Lmoe/nea/firmament/util/Locraw;", "setLocraw", "(Lmoe/nea/firmament/util/Locraw;)V", "Lmoe/nea/firmament/util/SkyBlockIsland;", "getSkyblockLocation", "()Lmoe/nea/firmament/util/SkyBlockIsland;", "skyblockLocation", "getHasValidLocraw", "()Z", "hasValidLocraw", "isOnSkyblock", "Lmoe/nea/firmament/util/TimeMark;", "profileIdCommandDebounce", "Lmoe/nea/firmament/util/TimeMark;", "getProfileIdCommandDebounce", "()Lmoe/nea/firmament/util/TimeMark;", "setProfileIdCommandDebounce", "(Lmoe/nea/firmament/util/TimeMark;)V", "Firmament"})
public final class SBData {
    @NotNull
    public static final SBData INSTANCE = new SBData();
    @NotNull
    private static final Regex profileRegex = new Regex("Profile ID: ([a-z0-9\\-]+)");
    @NotNull
    private static final List<String> profileSuggestTexts;
    @NotNull
    private static final UUID NULL_UUID;
    @Nullable
    private static UUID profileId;
    private static final ZoneId hypixelTimeZone;
    private static boolean hasReceivedProfile;
    @Nullable
    private static Locraw locraw;
    @NotNull
    private static TimeMark profileIdCommandDebounce;

    private SBData() {
    }

    @NotNull
    public final List<String> getProfileSuggestTexts() {
        return profileSuggestTexts;
    }

    @NotNull
    public final UUID getNULL_UUID() {
        return NULL_UUID;
    }

    @NotNull
    public final UUID getProfileIdOrNil() {
        UUID uUID = this.getProfileId();
        if (uUID == null) {
            uUID = NULL_UUID;
        }
        return uUID;
    }

    @Nullable
    public final UUID getProfileId() {
        if (!this.isOnSkyblock()) {
            return null;
        }
        return profileId;
    }

    public final void setProfileId(@Nullable UUID uUID) {
        profileId = uUID;
    }

    public final ZoneId getHypixelTimeZone() {
        return hypixelTimeZone;
    }

    @Nullable
    public final Locraw getLocraw() {
        return locraw;
    }

    public final void setLocraw(@Nullable Locraw locraw) {
        SBData.locraw = locraw;
    }

    @Nullable
    public final SkyBlockIsland getSkyblockLocation() {
        Locraw locraw = SBData.locraw;
        return locraw != null ? locraw.getSkyblockLocation() : null;
    }

    public final boolean getHasValidLocraw() {
        Object[] objectArray = new String[]{"limbo", null};
        Locraw locraw = SBData.locraw;
        return !CollectionsKt.listOf((Object[])objectArray).contains(locraw != null ? locraw.getServer() : null);
    }

    public final boolean isOnSkyblock() {
        Locraw locraw = SBData.locraw;
        return Intrinsics.areEqual((Object)(locraw != null ? locraw.getGametype() : null), (Object)"SKYBLOCK");
    }

    @NotNull
    public final TimeMark getProfileIdCommandDebounce() {
        return profileIdCommandDebounce;
    }

    public final void setProfileIdCommandDebounce(@NotNull TimeMark timeMark) {
        Intrinsics.checkNotNullParameter((Object)timeMark, (String)"<set-?>");
        profileIdCommandDebounce = timeMark;
    }

    public final void init() {
        ServerConnectedEvent.Companion.subscribe("SBData:onServerConnected", SBData::init$lambda$0);
        HypixelModAPI.getInstance().createHandler(ClientboundLocationPacket.class, SBData::init$lambda$1);
        SkyblockServerUpdateEvent.Companion.subscribe("SBData:sendProfileId", SBData::init$lambda$2);
        AllowChatEvent.Companion.subscribe("SBData:hideProfileSuggest", SBData::init$lambda$3);
        ProcessChatEvent.Companion.subscribe(true, "SBData:loadProfile", SBData::init$lambda$4);
    }

    private static final Unit init$lambda$0(ServerConnectedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HypixelModAPI.getInstance().subscribeToEventPacket(ClientboundLocationPacket.class);
        return Unit.INSTANCE;
    }

    private static final void init$lambda$1(ClientboundLocationPacket it) {
        MC.INSTANCE.onMainThread((Function0<Unit>)((Function0)() -> SBData.init$lambda$1$0(it)));
    }

    private static final Unit init$lambda$1$0(ClientboundLocationPacket $it) {
        String string;
        Locraw lastLocraw = locraw;
        UUID oldProfileId = INSTANCE.getProfileId();
        String string2 = $it.getServerName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getServerName(...)");
        Optional optional = $it.getServerType();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getServerType(...)");
        Object object = (ServerType)OptionalsKt.getOrNull((Optional)optional);
        if (object != null && (object = object.getName()) != null) {
            String string3 = ((String)object).toUpperCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        } else {
            string = null;
        }
        Optional optional2 = $it.getMode();
        Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getMode(...)");
        String string4 = (String)OptionalsKt.getOrNull((Optional)optional2);
        Optional optional3 = $it.getMap();
        Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"getMap(...)");
        locraw = new Locraw(string2, string, string4, (String)OptionalsKt.getOrNull((Optional)optional3));
        SkyblockServerUpdateEvent.Companion.publish((FirmamentEvent)new SkyblockServerUpdateEvent(lastLocraw, locraw));
        if (!Intrinsics.areEqual((Object)oldProfileId, (Object)INSTANCE.getProfileId())) {
            ProfileSwitchEvent.Companion.publish((FirmamentEvent)new ProfileSwitchEvent(oldProfileId, INSTANCE.getProfileId()));
        }
        profileIdCommandDebounce = TimeMark.Companion.now();
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$2(SkyblockServerUpdateEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!hasReceivedProfile && INSTANCE.isOnSkyblock()) {
            if (Duration.compareTo-LRDsOJo((long)profileIdCommandDebounce.passedTime-UwyO8pc(), (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS)) > 0) {
                profileIdCommandDebounce = TimeMark.Companion.now();
                MC.INSTANCE.sendCommand("profileid");
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$3(AllowChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (profileSuggestTexts.contains(event.getUnformattedString())) {
            if (Duration.compareTo-LRDsOJo((long)profileIdCommandDebounce.passedTime-UwyO8pc(), (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)) < 0) {
                event.cancel();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$4(ProcessChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MatchResult profileMatch = profileRegex.matchEntire((CharSequence)event.getUnformattedString());
        if (profileMatch != null) {
            UUID oldProfile = INSTANCE.getProfileId();
            try {
                profileId = UUID.fromString((String)profileMatch.getGroupValues().get(1));
                hasReceivedProfile = true;
            }
            catch (IllegalArgumentException e2) {
                profileId = null;
                e2.printStackTrace();
            }
            if (!Intrinsics.areEqual((Object)oldProfile, (Object)INSTANCE.getProfileId())) {
                ProfileSwitchEvent.Companion.publish((FirmamentEvent)new ProfileSwitchEvent(oldProfile, INSTANCE.getProfileId()));
            }
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"CLICK THIS TO SUGGEST IT IN CHAT [DASHES]", "CLICK THIS TO SUGGEST IT IN CHAT [NO DASHES]"};
        profileSuggestTexts = CollectionsKt.listOf((Object[])objectArray);
        NULL_UUID = new UUID(0L, 0L);
        hypixelTimeZone = ZoneId.of("US/Eastern");
        profileIdCommandDebounce = TimeMark.Companion.farPast();
    }
}

