/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.util;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import moe.nea.firmament.repo.MiningRepoData;
import moe.nea.firmament.repo.RepoManager;
import moe.nea.firmament.util.SkyBlockIsland;
import org.jetbrains.annotations.NotNull;

@Serializable(with=Serializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0002\u0012\u0011B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u0010\u001a\u00070\u0002\u00a2\u0006\u0002\b\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0013"}, d2={"Lmoe/nea/firmament/util/SkyBlockIsland;", "", "", "locrawMode", "<init>", "(Ljava/lang/String;)V", "Ljava/lang/String;", "getLocrawMode", "()Ljava/lang/String;", "", "getHasCustomMining", "()Z", "hasCustomMining", "isModernServer", "Lorg/jetbrains/annotations/NotNull;", "getUserFriendlyName", "userFriendlyName", "Companion", "Serializer", "Firmament"})
public final class SkyBlockIsland {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String locrawMode;
    @NotNull
    private static final Map<String, SkyBlockIsland> allIslands = new LinkedHashMap();
    @NotNull
    private static final SkyBlockIsland HUB = Companion.forMode("hub");
    @NotNull
    private static final SkyBlockIsland DWARVEN_MINES = Companion.forMode("dwarven_mines");
    @NotNull
    private static final SkyBlockIsland CRYSTAL_HOLLOWS = Companion.forMode("crystal_hollows");
    @NotNull
    private static final SkyBlockIsland CRIMSON_ISLE = Companion.forMode("crimson_isle");
    @NotNull
    private static final SkyBlockIsland PRIVATE_ISLAND = Companion.forMode("dynamic");
    @NotNull
    private static final SkyBlockIsland RIFT = Companion.forMode("rift");
    @NotNull
    private static final SkyBlockIsland MINESHAFT = Companion.forMode("mineshaft");
    @NotNull
    private static final SkyBlockIsland GARDEN = Companion.forMode("garden");
    @NotNull
    private static final SkyBlockIsland DUNGEON = Companion.forMode("dungeon");
    @NotNull
    private static final SkyBlockIsland NIL = Companion.forMode("_");
    @NotNull
    private static final SkyBlockIsland GALATEA = Companion.forMode("foraging_2");

    private SkyBlockIsland(String locrawMode) {
        this.locrawMode = locrawMode;
    }

    @NotNull
    public final String getLocrawMode() {
        return this.locrawMode;
    }

    public final boolean getHasCustomMining() {
        MiningRepoData.CustomMiningArea customMiningArea = RepoManager.INSTANCE.getMiningData().getCustomMiningAreas().get(this);
        return customMiningArea != null ? customMiningArea.isSpecialMining() : false;
    }

    public final boolean isModernServer() {
        return Intrinsics.areEqual((Object)this, (Object)GALATEA);
    }

    @NotNull
    public final String getUserFriendlyName() {
        String string = RepoManager.INSTANCE.getNeuRepo().getConstants().getIslands().getAreaNames().getOrDefault(this.locrawMode, this.locrawMode);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrDefault(...)");
        return string;
    }

    public /* synthetic */ SkyBlockIsland(String locrawMode, DefaultConstructorMarker $constructor_marker) {
        this(locrawMode);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u001b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0004\b\n\u0010\u000bR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\u0015\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0017\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0018\u0010\u0012R\u0017\u0010\u0019\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u001a\u0010\u0012R\u0017\u0010\u001b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0010\u001a\u0004\b\u001c\u0010\u0012R\u0017\u0010\u001d\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0010\u001a\u0004\b\u001e\u0010\u0012R\u0017\u0010\u001f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0010\u001a\u0004\b \u0010\u0012R\u0017\u0010!\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u0010\u001a\u0004\b\"\u0010\u0012R\u0017\u0010#\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b#\u0010\u0010\u001a\u0004\b$\u0010\u0012R\u0017\u0010%\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b%\u0010\u0010\u001a\u0004\b&\u0010\u0012\u00a8\u0006'"}, d2={"Lmoe/nea/firmament/util/SkyBlockIsland$Companion;", "", "<init>", "()V", "", "mode", "Lmoe/nea/firmament/util/SkyBlockIsland;", "forMode", "(Ljava/lang/String;)Lmoe/nea/firmament/util/SkyBlockIsland;", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;", "", "allIslands", "Ljava/util/Map;", "HUB", "Lmoe/nea/firmament/util/SkyBlockIsland;", "getHUB", "()Lmoe/nea/firmament/util/SkyBlockIsland;", "DWARVEN_MINES", "getDWARVEN_MINES", "CRYSTAL_HOLLOWS", "getCRYSTAL_HOLLOWS", "CRIMSON_ISLE", "getCRIMSON_ISLE", "PRIVATE_ISLAND", "getPRIVATE_ISLAND", "RIFT", "getRIFT", "MINESHAFT", "getMINESHAFT", "GARDEN", "getGARDEN", "DUNGEON", "getDUNGEON", "NIL", "getNIL", "GALATEA", "getGALATEA", "Firmament"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SkyBlockIsland forMode(@NotNull String mode) {
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            SkyBlockIsland skyBlockIsland = allIslands.computeIfAbsent(mode, arg_0 -> Companion.forMode$lambda$0(forMode.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)skyBlockIsland, (String)"computeIfAbsent(...)");
            return skyBlockIsland;
        }

        @NotNull
        public final SkyBlockIsland getHUB() {
            return HUB;
        }

        @NotNull
        public final SkyBlockIsland getDWARVEN_MINES() {
            return DWARVEN_MINES;
        }

        @NotNull
        public final SkyBlockIsland getCRYSTAL_HOLLOWS() {
            return CRYSTAL_HOLLOWS;
        }

        @NotNull
        public final SkyBlockIsland getCRIMSON_ISLE() {
            return CRIMSON_ISLE;
        }

        @NotNull
        public final SkyBlockIsland getPRIVATE_ISLAND() {
            return PRIVATE_ISLAND;
        }

        @NotNull
        public final SkyBlockIsland getRIFT() {
            return RIFT;
        }

        @NotNull
        public final SkyBlockIsland getMINESHAFT() {
            return MINESHAFT;
        }

        @NotNull
        public final SkyBlockIsland getGARDEN() {
            return GARDEN;
        }

        @NotNull
        public final SkyBlockIsland getDUNGEON() {
            return DUNGEON;
        }

        @NotNull
        public final SkyBlockIsland getNIL() {
            return NIL;
        }

        @NotNull
        public final SkyBlockIsland getGALATEA() {
            return GALATEA;
        }

        @NotNull
        public final KSerializer<SkyBlockIsland> serializer() {
            return Serializer.INSTANCE;
        }

        private static final SkyBlockIsland forMode$lambda$0(Function1 $tmp0, Object p0) {
            return (SkyBlockIsland)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lmoe/nea/firmament/util/SkyBlockIsland$Serializer;", "Lkotlinx/serialization/KSerializer;", "Lmoe/nea/firmament/util/SkyBlockIsland;", "<init>", "()V", "Lkotlinx/serialization/encoding/Decoder;", "decoder", "deserialize", "(Lkotlinx/serialization/encoding/Decoder;)Lmoe/nea/firmament/util/SkyBlockIsland;", "Lkotlinx/serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lkotlinx/serialization/encoding/Encoder;Lmoe/nea/firmament/util/SkyBlockIsland;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Firmament"})
    public static final class Serializer
    implements KSerializer<SkyBlockIsland> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"SkyBlockIsland", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
        }

        @NotNull
        public SkyBlockIsland deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            return Companion.forMode(decoder.decodeString());
        }

        public void serialize(@NotNull Encoder encoder, @NotNull SkyBlockIsland value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            encoder.encodeString(value.getLocrawMode());
        }
    }
}

