/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.util.compatloader;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.annotation.Repeatable;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.RepeatableContainer;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import moe.nea.firmament.Firmament;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000b\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001:\u0001 B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0017\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ\u001f\u0010\u000b\u001a\u00020\n2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0003H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\r\u001a\u00020\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\r\u0010\fR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001f\u001a\u0004\u0018\u00018\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0018\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lmoe/nea/firmament/util/compatloader/CompatLoader;", "", "T", "Ljava/lang/Class;", "kClass", "<init>", "(Ljava/lang/Class;)V", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "type", "", "shouldLoad", "(Ljava/lang/Class;)Z", "checkRequiredModsPresent", "Ljava/lang/Class;", "getKClass", "()Ljava/lang/Class;", "Ljava/util/ServiceLoader;", "loader", "Ljava/util/ServiceLoader;", "getLoader", "()Ljava/util/ServiceLoader;", "", "allValidInstances$delegate", "Lkotlin/Lazy;", "getAllValidInstances", "()Ljava/util/List;", "allValidInstances", "singleInstance$delegate", "getSingleInstance", "()Ljava/lang/Object;", "singleInstance", "RequireMod", "Firmament"})
@SourceDebugExtension(value={"SMAP\nCompatLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompatLoader.kt\nmoe/nea/firmament/util/compatloader/CompatLoader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,51:1\n12767#2,2:52\n*S KotlinDebug\n*F\n+ 1 CompatLoader.kt\nmoe/nea/firmament/util/compatloader/CompatLoader\n*L\n45#1:52,2\n*E\n"})
public class CompatLoader<T> {
    @NotNull
    private final Class<T> kClass;
    @NotNull
    private final ServiceLoader<T> loader;
    @NotNull
    private final Lazy allValidInstances$delegate;
    @NotNull
    private final Lazy singleInstance$delegate;

    public CompatLoader(@NotNull Class<T> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        this.kClass = kClass;
        ServiceLoader<T> serviceLoader = ServiceLoader.load(this.kClass);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        this.loader = serviceLoader;
        this.allValidInstances$delegate = LazyKt.lazy(() -> CompatLoader.allValidInstances_delegate$lambda$0(this));
        this.singleInstance$delegate = LazyKt.lazy(() -> CompatLoader.singleInstance_delegate$lambda$0(this));
    }

    @NotNull
    public final Class<T> getKClass() {
        return this.kClass;
    }

    public CompatLoader(@NotNull KClass<T> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        this(JvmClassMappingKt.getJavaClass(kClass));
    }

    @NotNull
    public final ServiceLoader<T> getLoader() {
        return this.loader;
    }

    @NotNull
    public final List<T> getAllValidInstances() {
        Lazy lazy = this.allValidInstances$delegate;
        return (List)lazy.getValue();
    }

    @Nullable
    public final T getSingleInstance() {
        Lazy lazy = this.singleInstance$delegate;
        return (T)lazy.getValue();
    }

    public boolean shouldLoad(@NotNull Class<? extends T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.checkRequiredModsPresent(type);
    }

    public final boolean checkRequiredModsPresent(@NotNull Class<?> type) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            RequireMod[] requiredMods = (RequireMod[])type.getAnnotationsByType(RequireMod.class);
            Intrinsics.checkNotNull((Object)requiredMods);
            RequireMod[] $this$all$iv = requiredMods;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int j = 0; j < n; ++j) {
                RequireMod element$iv;
                RequireMod it = element$iv = $this$all$iv[j];
                boolean bl2 = false;
                if (FabricLoader.getInstance().isModLoaded(it.modId())) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final List allValidInstances_delegate$lambda$0(CompatLoader this$0) {
        this$0.loader.reload();
        Stream stream = this$0.loader.stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), arg_0 -> CompatLoader.allValidInstances_delegate$lambda$0$0(this$0, arg_0)), arg_0 -> CompatLoader.allValidInstances_delegate$lambda$0$1(this$0, arg_0)));
    }

    private static final boolean allValidInstances_delegate$lambda$0$0(CompatLoader this$0, ServiceLoader.Provider provider) {
        Object object;
        Object $this$allValidInstances_delegate_u24lambda_u240_u240_u240;
        Object object2 = this$0;
        try {
            $this$allValidInstances_delegate_u24lambda_u240_u240_u240 = object2;
            boolean bl = false;
            Class clazz = provider.type();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"type(...)");
            $this$allValidInstances_delegate_u24lambda_u240_u240_u240 = Result.constructor-impl((Object)((CompatLoader)$this$allValidInstances_delegate_u24lambda_u240_u240_u240).shouldLoad(clazz));
        }
        catch (Throwable bl) {
            $this$allValidInstances_delegate_u24lambda_u240_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$allValidInstances_delegate_u24lambda_u240_u240_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            Firmament.INSTANCE.getLogger().error("Could not determine whether to load a " + this$0.kClass.getName() + " subclass", it);
            object = false;
        }
        return (Boolean)object;
    }

    private static final Object allValidInstances_delegate$lambda$0$1(CompatLoader this$0, ServiceLoader.Provider provider) {
        Object object;
        Object $this$allValidInstances_delegate_u24lambda_u240_u241_u240;
        Object object2 = this$0;
        try {
            $this$allValidInstances_delegate_u24lambda_u240_u241_u240 = object2;
            boolean bl = false;
            $this$allValidInstances_delegate_u24lambda_u240_u241_u240 = Result.constructor-impl(provider.get());
        }
        catch (Throwable bl) {
            $this$allValidInstances_delegate_u24lambda_u240_u241_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$allValidInstances_delegate_u24lambda_u240_u241_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            Firmament.INSTANCE.getLogger().error("Could not load desired instance " + provider.type().getName() + " for " + this$0.kClass.getName(), it);
            object = null;
        }
        return object;
    }

    private static final Object singleInstance_delegate$lambda$0(CompatLoader this$0) {
        return CollectionsKt.singleOrNull(this$0.getAllValidInstances());
    }

    @Repeatable
    @Retention(value=RetentionPolicy.RUNTIME)
    @java.lang.annotation.Repeatable(value=Container.class)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0087\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lmoe/nea/firmament/util/compatloader/CompatLoader$RequireMod;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "()Ljava/lang/String;", "Firmament"})
    public static @interface RequireMod {
        public String modId();

        @RepeatableContainer
        @Retention(value=RetentionPolicy.RUNTIME)
        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static @interface Container {
            public RequireMod[] value();
        }
    }
}

