/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.util.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\r\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0010\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J+\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\n\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\n\"\u0004\b\u0000\u0010\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0019\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ5\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\n\"\u0004\b\u0000\u0010\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010 \u001a\u00020\u001f\"\u0004\b\u0000\u0010\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b \u0010!J#\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\n\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lmoe/nea/firmament/util/math/GChainReconciliation;", "", "<init>", "()V", "T", "", "", "", "frequencies", "(Ljava/lang/Iterable;)Ljava/util/Map;", "", "leftChain", "rightChain", "findMostCommonlySharedElement", "(Ljava/util/List;Ljava/util/List;)Ljava/lang/Object;", "index", "getMod", "(Ljava/util/List;I)Ljava/lang/Object;", "offset", "rotated", "(Ljava/util/List;I)Ljava/util/List;", "list", "element", "shiftToFront", "(Ljava/util/List;Ljava/lang/Object;)Ljava/util/List;", "indexOfOrMaxInt", "(Ljava/util/List;Ljava/lang/Object;)I", "reconcileCycles", "(Ljava/util/List;Ljava/util/List;)Ljava/util/List;", "longList", "cycle", "", "isValidCycle", "(Ljava/util/List;Ljava/util/List;)Z", "shortenCycle", "(Ljava/util/List;)Ljava/util/List;", "Firmament"})
@SourceDebugExtension(value={"SMAP\nGChainReconciliation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GChainReconciliation.kt\nmoe/nea/firmament/util/math/GChainReconciliation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class GChainReconciliation {
    @NotNull
    public static final GChainReconciliation INSTANCE = new GChainReconciliation();

    private GChainReconciliation() {
    }

    @NotNull
    public final <T> Map<T, Integer> frequencies(@NotNull Iterable<? extends T> $this$frequencies) {
        Intrinsics.checkNotNullParameter($this$frequencies, (String)"<this>");
        Map acc = new LinkedHashMap();
        for (T t : $this$frequencies) {
            acc.compute(t, (arg_0, arg_1) -> GChainReconciliation.frequencies$lambda$1(GChainReconciliation::frequencies$lambda$0, arg_0, arg_1));
        }
        return acc;
    }

    public final <T> T findMostCommonlySharedElement(@NotNull List<? extends T> leftChain, @NotNull List<? extends T> rightChain) {
        Object mostCommonlySharedElement;
        Object v0;
        Intrinsics.checkNotNullParameter(leftChain, (String)"leftChain");
        Intrinsics.checkNotNullParameter(rightChain, (String)"rightChain");
        Map<T, Integer> lf = this.frequencies((Iterable)leftChain);
        Map<T, Integer> rf = this.frequencies((Iterable)rightChain);
        Iterable iterable = lf.entrySet();
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                Integer n2 = rf.get(it.getKey());
                int n3 = n2 != null ? n2 : 0;
                int n4 = Math.min(n, n3);
                do {
                    Object t2 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-GChainReconciliation$findMostCommonlySharedElement$mostCommonlySharedElement$1 = false;
                    int n5 = ((Number)it2.getValue()).intValue();
                    Integer n6 = rf.get(it2.getKey());
                    int n7 = n6 != null ? n6 : 0;
                    n = Math.min(n5, n7);
                    if (n4 >= n) continue;
                    t = t2;
                    n4 = n;
                } while (iterator2.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        Object object = mostCommonlySharedElement = entry != null ? entry.getKey() : null;
        if (mostCommonlySharedElement == null || !rf.containsKey(mostCommonlySharedElement)) {
            throw new IllegalStateException("Could not find a shared element".toString());
        }
        return (T)mostCommonlySharedElement;
    }

    public final <T> T getMod(@NotNull List<? extends T> $this$getMod, int index) {
        Intrinsics.checkNotNullParameter($this$getMod, (String)"<this>");
        int n = index;
        int n2 = $this$getMod.size();
        int n3 = n % n2;
        return $this$getMod.get(n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31));
    }

    @NotNull
    public final <T> List<T> rotated(@NotNull List<? extends T> $this$rotated, int offset) {
        Intrinsics.checkNotNullParameter($this$rotated, (String)"<this>");
        List newList = new ArrayList();
        int n = ((Collection)$this$rotated).size();
        for (int index = 0; index < n; ++index) {
            newList.add(this.getMod($this$rotated, index - offset));
        }
        return newList;
    }

    @NotNull
    public final <T> List<T> shiftToFront(@NotNull List<? extends T> list, T element) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        int shiftDistance = list.indexOf(element);
        if (!(shiftDistance >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.rotated(list, -shiftDistance);
    }

    public final <T> int indexOfOrMaxInt(@NotNull List<? extends T> $this$indexOfOrMaxInt, T element) {
        Intrinsics.checkNotNullParameter($this$indexOfOrMaxInt, (String)"<this>");
        Integer n = $this$indexOfOrMaxInt.indexOf(element);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it < 0) ? n : null;
        return n2 != null ? n2 : Integer.MAX_VALUE;
    }

    @NotNull
    public final <T> List<T> reconcileCycles(@NotNull List<? extends T> leftChain, @NotNull List<? extends T> rightChain) {
        Intrinsics.checkNotNullParameter(leftChain, (String)"leftChain");
        Intrinsics.checkNotNullParameter(rightChain, (String)"rightChain");
        T mostCommonElement = this.findMostCommonlySharedElement(leftChain, rightChain);
        List left = CollectionsKt.toMutableList((Collection)this.shiftToFront(leftChain, mostCommonElement));
        List right = CollectionsKt.toMutableList((Collection)this.shiftToFront(rightChain, mostCommonElement));
        int index = 0;
        while (index < left.size() && index < right.size()) {
            int nextRightInLeft;
            Object rightEl;
            Object leftEl = left.get(index);
            if (Intrinsics.areEqual(leftEl, rightEl = right.get(index))) {
                ++index;
                continue;
            }
            int nextLeftInRight = this.indexOfOrMaxInt(right.subList(index, right.size()), leftEl);
            if (nextLeftInRight < (nextRightInLeft = this.indexOfOrMaxInt(left.subList(index, left.size()), rightEl))) {
                left.add(index, rightEl);
                continue;
            }
            if (nextRightInLeft < nextLeftInRight) {
                right.add(index, leftEl);
                continue;
            }
            ++index;
        }
        return left.size() < right.size() ? right : left;
    }

    public final <T> boolean isValidCycle(@NotNull List<? extends T> longList, @NotNull List<? extends T> cycle) {
        Intrinsics.checkNotNullParameter(longList, (String)"longList");
        Intrinsics.checkNotNullParameter(cycle, (String)"cycle");
        Iterator iterator2 = ((Iterable)longList).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            Object value = iterator2.next();
            if (Intrinsics.areEqual(this.getMod(cycle, i2), value)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final <T> List<T> shortenCycle(@NotNull List<? extends T> $this$shortenCycle) {
        Intrinsics.checkNotNullParameter($this$shortenCycle, (String)"<this>");
        int n = $this$shortenCycle.size();
        for (int i2 = 1; i2 < n; ++i2) {
            if (!this.isValidCycle($this$shortenCycle, $this$shortenCycle.subList(0, i2))) continue;
            return $this$shortenCycle.subList(0, i2);
        }
        return $this$shortenCycle;
    }

    private static final Integer frequencies$lambda$0(Object object, Integer old) {
        Integer n = old;
        return (n != null ? n : 0) + 1;
    }

    private static final Integer frequencies$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }
}

