/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.lisp;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moe.nea.lisp.LispAst;
import moe.nea.lisp.LispData;
import moe.nea.lisp.LispExecutionContext;
import moe.nea.lisp.OutputCapture;
import moe.nea.lisp.StackFrame;
import moe.nea.lisp.TestFramework;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u001f !\"#$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J,\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006\u00a8\u0006%"}, d2={"Lmoe/nea/lisp/TestFramework;", "", "()V", "failTestBinding", "Lmoe/nea/lisp/LispData$LispExecutable;", "getFailTestBinding", "()Lmoe/nea/lisp/LispData$LispExecutable;", "realizedTestModule", "", "", "getRealizedTestModule", "()Ljava/util/Map;", "testBinding", "getTestBinding", "runTest", "", "context", "Lmoe/nea/lisp/LispExecutionContext;", "callsite", "Lmoe/nea/lisp/LispAst;", "stackFrame", "Lmoe/nea/lisp/StackFrame;", "args", "", "Lmoe/nea/lisp/LispAst$LispNode;", "setup", "Lmoe/nea/lisp/TestFramework$TestSuite;", "name", "testList", "isWhitelist", "", "ActiveTest", "ActiveTestMeta", "TestFailure", "TestResult", "TestSuite", "TestSuiteMeta", "nealisp"})
public final class TestFramework {
    @NotNull
    public static final TestFramework INSTANCE = new TestFramework();
    @NotNull
    private static final LispData.LispExecutable testBinding = LispData.Companion.externalRawCall("ntest.test", (Function4<? super LispExecutionContext, ? super LispAst.LispNode, ? super StackFrame, ? super List<? extends LispAst.LispNode>, ? extends LispData>)((Function4)testBinding.1.INSTANCE));
    @NotNull
    private static final LispData.LispExecutable failTestBinding = LispData.Companion.externalCall("ntest.fail", (Function2<? super List<? extends LispData>, ? super Function1<? super String, ? extends LispData>, ? extends LispData>)((Function2)failTestBinding.1.INSTANCE));
    @NotNull
    private static final Map<String, LispData.LispExecutable> realizedTestModule;

    private TestFramework() {
    }

    @NotNull
    public final LispData.LispExecutable getTestBinding() {
        return testBinding;
    }

    @NotNull
    public final LispData.LispExecutable getFailTestBinding() {
        return failTestBinding;
    }

    @NotNull
    public final Map<String, LispData.LispExecutable> getRealizedTestModule() {
        return realizedTestModule;
    }

    public final void runTest(@NotNull LispExecutionContext context, @NotNull LispAst callsite, @NotNull StackFrame stackFrame, @NotNull List<? extends LispAst.LispNode> args) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callsite, (String)"callsite");
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        TestSuite testSuite = (TestSuite)stackFrame.getMeta(TestSuiteMeta.INSTANCE);
        if (testSuite == null) {
            return;
        }
        TestSuite meta = testSuite;
        if (!meta.isTesting()) {
            return;
        }
        if (args.size() != 2) {
            stackFrame.reportError("Test case needs to be defined by a name and an executable", callsite);
            return;
        }
        LispAst.LispNode name = args.get(0);
        LispAst.LispNode prog = args.get(1);
        LispData n = context.resolveValue(stackFrame, name);
        if (n instanceof LispData.Atom) {
            string = ((LispData.Atom)n).getLabel();
        } else if (n instanceof LispData.LispString) {
            string = ((LispData.LispString)n).getString();
        } else {
            stackFrame.reportError("Test case needs an atom or string as name", name);
            return;
        }
        String testName = string;
        if (meta.getTestList().contains(testName) != meta.isWhitelist()) {
            meta.getAllTests().add(new TestResult(testName, CollectionsKt.emptyList(), true, ""));
            return;
        }
        StackFrame child = stackFrame.fork();
        ActiveTest test = new ActiveTest(testName, new ArrayList(), false, meta);
        OutputCapture.CapturedOutput output = OutputCapture.INSTANCE.captureOutput(child);
        child.setMeta(ActiveTestMeta.INSTANCE, test);
        context.resolveValue(child, prog);
        meta.getAllTests().add(new TestResult(test.getTestName(), test.getCurrentFailures(), false, output.getAsString()));
    }

    @NotNull
    public final TestSuite setup(@NotNull StackFrame stackFrame, @NotNull String name, @NotNull List<String> testList, boolean isWhitelist) {
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(testList, (String)"testList");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        TestSuite ts = new TestSuite(name, instant, true, new ArrayList(), testList, isWhitelist, null, 64, null);
        stackFrame.setMeta(TestSuiteMeta.INSTANCE, ts);
        return ts;
    }

    static {
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"ntest.test", (Object)testBinding);
        pairArray[1] = TuplesKt.to((Object)"ntest.fail", (Object)failTestBinding);
        realizedTestModule = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lmoe/nea/lisp/TestFramework$TestFailure;", "", "callsite", "Lmoe/nea/lisp/LispAst;", "message", "", "(Lmoe/nea/lisp/LispAst;Ljava/lang/String;)V", "getCallsite", "()Lmoe/nea/lisp/LispAst;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "nealisp"})
    public static final class TestFailure {
        @NotNull
        private final LispAst callsite;
        @NotNull
        private final String message;

        public TestFailure(@NotNull LispAst callsite, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)callsite, (String)"callsite");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.callsite = callsite;
            this.message = message;
        }

        @NotNull
        public final LispAst getCallsite() {
            return this.callsite;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final LispAst component1() {
            return this.callsite;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final TestFailure copy(@NotNull LispAst callsite, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)callsite, (String)"callsite");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new TestFailure(callsite, message);
        }

        public static /* synthetic */ TestFailure copy$default(TestFailure testFailure, LispAst lispAst, String string, int n, Object object) {
            if ((n & 1) != 0) {
                lispAst = testFailure.callsite;
            }
            if ((n & 2) != 0) {
                string = testFailure.message;
            }
            return testFailure.copy(lispAst, string);
        }

        @NotNull
        public String toString() {
            return "TestFailure(callsite=" + this.callsite + ", message=" + this.message + ')';
        }

        public int hashCode() {
            int result = this.callsite.hashCode();
            result = result * 31 + this.message.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TestFailure)) {
                return false;
            }
            TestFailure testFailure = (TestFailure)other;
            if (!Intrinsics.areEqual((Object)this.callsite, (Object)testFailure.callsite)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)testFailure.message);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J7\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lmoe/nea/lisp/TestFramework$TestResult;", "", "name", "", "failures", "", "Lmoe/nea/lisp/TestFramework$TestFailure;", "wasSkipped", "", "stdout", "(Ljava/lang/String;Ljava/util/List;ZLjava/lang/String;)V", "getFailures", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getStdout", "getWasSkipped", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "nealisp"})
    public static final class TestResult {
        @NotNull
        private final String name;
        @NotNull
        private final List<TestFailure> failures;
        private final boolean wasSkipped;
        @NotNull
        private final String stdout;

        public TestResult(@NotNull String name, @NotNull List<TestFailure> failures, boolean wasSkipped, @NotNull String stdout) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(failures, (String)"failures");
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            this.name = name;
            this.failures = failures;
            this.wasSkipped = wasSkipped;
            this.stdout = stdout;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<TestFailure> getFailures() {
            return this.failures;
        }

        public final boolean getWasSkipped() {
            return this.wasSkipped;
        }

        @NotNull
        public final String getStdout() {
            return this.stdout;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<TestFailure> component2() {
            return this.failures;
        }

        public final boolean component3() {
            return this.wasSkipped;
        }

        @NotNull
        public final String component4() {
            return this.stdout;
        }

        @NotNull
        public final TestResult copy(@NotNull String name, @NotNull List<TestFailure> failures, boolean wasSkipped, @NotNull String stdout) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(failures, (String)"failures");
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            return new TestResult(name, failures, wasSkipped, stdout);
        }

        public static /* synthetic */ TestResult copy$default(TestResult testResult, String string, List list, boolean bl, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = testResult.name;
            }
            if ((n & 2) != 0) {
                list = testResult.failures;
            }
            if ((n & 4) != 0) {
                bl = testResult.wasSkipped;
            }
            if ((n & 8) != 0) {
                string2 = testResult.stdout;
            }
            return testResult.copy(string, list, bl, string2);
        }

        @NotNull
        public String toString() {
            return "TestResult(name=" + this.name + ", failures=" + this.failures + ", wasSkipped=" + this.wasSkipped + ", stdout=" + this.stdout + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + ((Object)this.failures).hashCode();
            int n = this.wasSkipped ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + this.stdout.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TestResult)) {
                return false;
            }
            TestResult testResult = (TestResult)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)testResult.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.failures, testResult.failures)) {
                return false;
            }
            if (this.wasSkipped != testResult.wasSkipped) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stdout, (Object)testResult.stdout);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J[\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\b\b\u0002\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0016\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011\u00a8\u0006*"}, d2={"Lmoe/nea/lisp/TestFramework$TestSuite;", "", "name", "", "startTime", "Ljava/time/Instant;", "isTesting", "", "allTests", "", "Lmoe/nea/lisp/TestFramework$TestResult;", "testList", "", "isWhitelist", "otherOutput", "(Ljava/lang/String;Ljava/time/Instant;ZLjava/util/List;Ljava/util/List;ZLjava/lang/String;)V", "getAllTests", "()Ljava/util/List;", "()Z", "setTesting", "(Z)V", "getName", "()Ljava/lang/String;", "getOtherOutput", "setOtherOutput", "(Ljava/lang/String;)V", "getStartTime", "()Ljava/time/Instant;", "getTestList", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "nealisp"})
    public static final class TestSuite {
        @NotNull
        private final String name;
        @NotNull
        private final Instant startTime;
        private boolean isTesting;
        @NotNull
        private final List<TestResult> allTests;
        @NotNull
        private final List<String> testList;
        private final boolean isWhitelist;
        @NotNull
        private String otherOutput;

        public TestSuite(@NotNull String name, @NotNull Instant startTime, boolean isTesting, @NotNull List<TestResult> allTests, @NotNull List<String> testList, boolean isWhitelist, @NotNull String otherOutput) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            Intrinsics.checkNotNullParameter(allTests, (String)"allTests");
            Intrinsics.checkNotNullParameter(testList, (String)"testList");
            Intrinsics.checkNotNullParameter((Object)otherOutput, (String)"otherOutput");
            this.name = name;
            this.startTime = startTime;
            this.isTesting = isTesting;
            this.allTests = allTests;
            this.testList = testList;
            this.isWhitelist = isWhitelist;
            this.otherOutput = otherOutput;
        }

        public /* synthetic */ TestSuite(String string, Instant instant, boolean bl, List list, List list2, boolean bl2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x40) != 0) {
                string2 = "";
            }
            this(string, instant, bl, list, list2, bl2, string2);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Instant getStartTime() {
            return this.startTime;
        }

        public final boolean isTesting() {
            return this.isTesting;
        }

        public final void setTesting(boolean bl) {
            this.isTesting = bl;
        }

        @NotNull
        public final List<TestResult> getAllTests() {
            return this.allTests;
        }

        @NotNull
        public final List<String> getTestList() {
            return this.testList;
        }

        public final boolean isWhitelist() {
            return this.isWhitelist;
        }

        @NotNull
        public final String getOtherOutput() {
            return this.otherOutput;
        }

        public final void setOtherOutput(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.otherOutput = string;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Instant component2() {
            return this.startTime;
        }

        public final boolean component3() {
            return this.isTesting;
        }

        @NotNull
        public final List<TestResult> component4() {
            return this.allTests;
        }

        @NotNull
        public final List<String> component5() {
            return this.testList;
        }

        public final boolean component6() {
            return this.isWhitelist;
        }

        @NotNull
        public final String component7() {
            return this.otherOutput;
        }

        @NotNull
        public final TestSuite copy(@NotNull String name, @NotNull Instant startTime, boolean isTesting, @NotNull List<TestResult> allTests, @NotNull List<String> testList, boolean isWhitelist, @NotNull String otherOutput) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            Intrinsics.checkNotNullParameter(allTests, (String)"allTests");
            Intrinsics.checkNotNullParameter(testList, (String)"testList");
            Intrinsics.checkNotNullParameter((Object)otherOutput, (String)"otherOutput");
            return new TestSuite(name, startTime, isTesting, allTests, testList, isWhitelist, otherOutput);
        }

        public static /* synthetic */ TestSuite copy$default(TestSuite testSuite, String string, Instant instant, boolean bl, List list, List list2, boolean bl2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = testSuite.name;
            }
            if ((n & 2) != 0) {
                instant = testSuite.startTime;
            }
            if ((n & 4) != 0) {
                bl = testSuite.isTesting;
            }
            if ((n & 8) != 0) {
                list = testSuite.allTests;
            }
            if ((n & 0x10) != 0) {
                list2 = testSuite.testList;
            }
            if ((n & 0x20) != 0) {
                bl2 = testSuite.isWhitelist;
            }
            if ((n & 0x40) != 0) {
                string2 = testSuite.otherOutput;
            }
            return testSuite.copy(string, instant, bl, list, list2, bl2, string2);
        }

        @NotNull
        public String toString() {
            return "TestSuite(name=" + this.name + ", startTime=" + this.startTime + ", isTesting=" + this.isTesting + ", allTests=" + this.allTests + ", testList=" + this.testList + ", isWhitelist=" + this.isWhitelist + ", otherOutput=" + this.otherOutput + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.startTime.hashCode();
            int n = this.isTesting ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + ((Object)this.allTests).hashCode();
            result = result * 31 + ((Object)this.testList).hashCode();
            int n2 = this.isWhitelist ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + this.otherOutput.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TestSuite)) {
                return false;
            }
            TestSuite testSuite = (TestSuite)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)testSuite.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.startTime, (Object)testSuite.startTime)) {
                return false;
            }
            if (this.isTesting != testSuite.isTesting) {
                return false;
            }
            if (!Intrinsics.areEqual(this.allTests, testSuite.allTests)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.testList, testSuite.testList)) {
                return false;
            }
            if (this.isWhitelist != testSuite.isWhitelist) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.otherOutput, (Object)testSuite.otherOutput);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J7\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lmoe/nea/lisp/TestFramework$ActiveTest;", "", "testName", "", "currentFailures", "", "Lmoe/nea/lisp/TestFramework$TestFailure;", "canMultifail", "", "suite", "Lmoe/nea/lisp/TestFramework$TestSuite;", "(Ljava/lang/String;Ljava/util/List;ZLmoe/nea/lisp/TestFramework$TestSuite;)V", "getCanMultifail", "()Z", "setCanMultifail", "(Z)V", "getCurrentFailures", "()Ljava/util/List;", "getSuite", "()Lmoe/nea/lisp/TestFramework$TestSuite;", "getTestName", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "nealisp"})
    public static final class ActiveTest {
        @NotNull
        private final String testName;
        @NotNull
        private final List<TestFailure> currentFailures;
        private boolean canMultifail;
        @NotNull
        private final TestSuite suite;

        public ActiveTest(@NotNull String testName, @NotNull List<TestFailure> currentFailures, boolean canMultifail, @NotNull TestSuite suite) {
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter(currentFailures, (String)"currentFailures");
            Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
            this.testName = testName;
            this.currentFailures = currentFailures;
            this.canMultifail = canMultifail;
            this.suite = suite;
        }

        @NotNull
        public final String getTestName() {
            return this.testName;
        }

        @NotNull
        public final List<TestFailure> getCurrentFailures() {
            return this.currentFailures;
        }

        public final boolean getCanMultifail() {
            return this.canMultifail;
        }

        public final void setCanMultifail(boolean bl) {
            this.canMultifail = bl;
        }

        @NotNull
        public final TestSuite getSuite() {
            return this.suite;
        }

        @NotNull
        public final String component1() {
            return this.testName;
        }

        @NotNull
        public final List<TestFailure> component2() {
            return this.currentFailures;
        }

        public final boolean component3() {
            return this.canMultifail;
        }

        @NotNull
        public final TestSuite component4() {
            return this.suite;
        }

        @NotNull
        public final ActiveTest copy(@NotNull String testName, @NotNull List<TestFailure> currentFailures, boolean canMultifail, @NotNull TestSuite suite) {
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter(currentFailures, (String)"currentFailures");
            Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
            return new ActiveTest(testName, currentFailures, canMultifail, suite);
        }

        public static /* synthetic */ ActiveTest copy$default(ActiveTest activeTest, String string, List list, boolean bl, TestSuite testSuite, int n, Object object) {
            if ((n & 1) != 0) {
                string = activeTest.testName;
            }
            if ((n & 2) != 0) {
                list = activeTest.currentFailures;
            }
            if ((n & 4) != 0) {
                bl = activeTest.canMultifail;
            }
            if ((n & 8) != 0) {
                testSuite = activeTest.suite;
            }
            return activeTest.copy(string, list, bl, testSuite);
        }

        @NotNull
        public String toString() {
            return "ActiveTest(testName=" + this.testName + ", currentFailures=" + this.currentFailures + ", canMultifail=" + this.canMultifail + ", suite=" + this.suite + ')';
        }

        public int hashCode() {
            int result = this.testName.hashCode();
            result = result * 31 + ((Object)this.currentFailures).hashCode();
            int n = this.canMultifail ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + this.suite.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActiveTest)) {
                return false;
            }
            ActiveTest activeTest = (ActiveTest)other;
            if (!Intrinsics.areEqual((Object)this.testName, (Object)activeTest.testName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.currentFailures, activeTest.currentFailures)) {
                return false;
            }
            if (this.canMultifail != activeTest.canMultifail) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.suite, (Object)activeTest.suite);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lmoe/nea/lisp/TestFramework$TestSuiteMeta;", "Lmoe/nea/lisp/StackFrame$MetaKey;", "Lmoe/nea/lisp/TestFramework$TestSuite;", "()V", "nealisp"})
    public static final class TestSuiteMeta
    implements StackFrame.MetaKey<TestSuite> {
        @NotNull
        public static final TestSuiteMeta INSTANCE = new TestSuiteMeta();

        private TestSuiteMeta() {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lmoe/nea/lisp/TestFramework$ActiveTestMeta;", "Lmoe/nea/lisp/StackFrame$MetaKey;", "Lmoe/nea/lisp/TestFramework$ActiveTest;", "()V", "nealisp"})
    public static final class ActiveTestMeta
    implements StackFrame.MetaKey<ActiveTest> {
        @NotNull
        public static final ActiveTestMeta INSTANCE = new ActiveTestMeta();

        private ActiveTestMeta() {
        }
    }
}

