/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.moulconfig.gui.editors;

import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import moe.nea.firmament.deps.moulconfig.Config;
import moe.nea.firmament.deps.moulconfig.GuiTextures;
import moe.nea.firmament.deps.moulconfig.common.text.StructuredText;
import moe.nea.firmament.deps.moulconfig.gui.GuiComponent;
import moe.nea.firmament.deps.moulconfig.gui.GuiImmediateContext;
import moe.nea.firmament.deps.moulconfig.gui.MouseEvent;
import moe.nea.firmament.deps.moulconfig.gui.editors.ComponentEditor;
import moe.nea.firmament.deps.moulconfig.internal.TypeUtils;
import moe.nea.firmament.deps.moulconfig.internal.Warnings;
import moe.nea.firmament.deps.moulconfig.processor.ProcessedOption;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorButton
extends ComponentEditor {
    private final int runnableId;
    private StructuredText buttonText;
    private final Config config;
    final DispatchStyle dispatchStyle;
    private final GuiComponent delegate = this.wrapComponent(new GuiComponent(){

        @Override
        public int getWidth() {
            return 48;
        }

        @Override
        public int getHeight() {
            return 16;
        }

        @Override
        public void render(@NotNull GuiImmediateContext context) {
            context.getRenderContext().drawTexturedRect(GuiTextures.BUTTON, 0.0f, 0.0f, context.getWidth(), context.getHeight());
            context.getRenderContext().drawStringCenteredScaledMaxWidth(GuiOptionEditorButton.this.buttonText, context.getRenderContext().getMinecraft().getDefaultFontRenderer(), (float)context.getWidth() / 2.0f, (float)context.getHeight() / 2.0f, false, context.getWidth() - 4, -13619152);
        }

        @Override
        public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
            MouseEvent.Click click;
            if (mouseEvent instanceof MouseEvent.Click && (click = (MouseEvent.Click)mouseEvent).getMouseState() && context.isHovered() && click.getMouseButton() == 0) {
                GuiOptionEditorButton.this.onClick();
                return true;
            }
            return super.mouseEvent(mouseEvent, context);
        }
    });

    public GuiOptionEditorButton(ProcessedOption option, int runnableId, StructuredText buttonText, Config config) {
        super(option);
        this.runnableId = runnableId;
        this.config = config;
        this.buttonText = buttonText;
        Type type = option.getType();
        if (TypeUtils.doesAExtendB(type, Runnable.class)) {
            this.dispatchStyle = DispatchStyle.RUNNABLE;
        } else if (TypeUtils.doesAExtendB(type, Function0.class)) {
            this.dispatchStyle = DispatchStyle.KRUNNABLE;
        } else {
            this.dispatchStyle = DispatchStyle.BY_ID;
            if (!config.isValidRunnable(this.runnableId)) {
                Warnings.warn("Invalid use of runnable id " + runnableId + " by " + this.getDebugDeclarationLocation());
            }
        }
        if (this.buttonText == null) {
            Warnings.warn("Empty button text by " + this.getDebugDeclarationLocation());
            this.buttonText = StructuredText.empty();
        }
    }

    public void onClick() {
        this.dispatchStyle.dispatch(this);
    }

    @Override
    public boolean fulfillsSearch(String word) {
        return super.fulfillsSearch(word) || this.buttonText.getText().toLowerCase(Locale.ROOT).contains(word);
    }

    @Override
    public GuiComponent getDelegate() {
        return this.delegate;
    }

    static enum DispatchStyle {
        KRUNNABLE{

            @Override
            void dispatch(GuiOptionEditorButton $this) {
                Object v = ((Function0)$this.option.get()).invoke();
                if (!Objects.equals(v, Unit.INSTANCE)) {
                    Warnings.warn("KRunnable dispatch of button " + $this.getDebugDeclarationLocation() + " returned non unit value " + v);
                }
            }
        }
        ,
        RUNNABLE{

            @Override
            void dispatch(GuiOptionEditorButton $this) {
                ((Runnable)$this.option.get()).run();
            }
        }
        ,
        BY_ID{

            @Override
            void dispatch(GuiOptionEditorButton $this) {
                $this.config.executeRunnable($this.runnableId);
            }
        };


        abstract void dispatch(GuiOptionEditorButton var1);
    }
}

