/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.repo.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import moe.nea.firmament.deps.repo.data.NEUIngredient;
import moe.nea.firmament.deps.repo.data.NEUItem;
import moe.nea.firmament.deps.repo.data.NEURecipe;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NEUCraftingRecipe
implements NEURecipe {
    NEUIngredient[] inputs;
    @Nullable String extraText;
    NEUIngredient output;
    int outputCount;

    @Override
    public void fillItemInfo(NEUItem item) {
        if (this.extraText == null) {
            this.extraText = item.crafttext;
        }
        if (this.output == null) {
            this.output = NEUIngredient.fromString(item.skyblockItemId);
        }
        if (this.outputCount > 0) {
            this.output.amount = this.outputCount;
        }
    }

    @Override
    public Collection<NEUIngredient> getAllOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public Collection<NEUIngredient> getAllInputs() {
        ArrayList<NEUIngredient> ingredientList = new ArrayList<NEUIngredient>();
        for (NEUIngredient ingredient : this.inputs) {
            if (ingredient == null) continue;
            ingredientList.add(ingredient);
        }
        return ingredientList;
    }

    public NEUIngredient[] getInputs() {
        return this.inputs;
    }

    public @Nullable String getExtraText() {
        return this.extraText;
    }

    public NEUIngredient getOutput() {
        return this.output;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public static class Serializer
    implements JsonDeserializer<NEUCraftingRecipe> {
        public NEUCraftingRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            NEUCraftingRecipe cr = new NEUCraftingRecipe();
            JsonObject recipe = json.getAsJsonObject();
            String[] x = new String[]{"1", "2", "3"};
            String[] y = new String[]{"A", "B", "C"};
            cr.inputs = new NEUIngredient[9];
            for (int i2 = 0; i2 < 9; ++i2) {
                String name = y[i2 / 3] + x[i2 % 3];
                if (!recipe.has(name)) continue;
                String item = recipe.get(name).getAsString();
                cr.inputs[i2] = item == null || item.isEmpty() ? NEUIngredient.SENTINEL_EMPTY : NEUIngredient.fromString(item);
            }
            cr.outputCount = -1;
            if (recipe.has("count")) {
                cr.outputCount = recipe.get("count").getAsInt();
            }
            if (recipe.has("crafttext")) {
                cr.extraText = recipe.get("crafttext").getAsString();
            }
            if (recipe.has("overrideOutputId")) {
                cr.output = NEUIngredient.fromString(recipe.get("overrideOutputId").getAsString());
            }
            return cr;
        }
    }
}

