/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.repo.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import moe.nea.firmament.deps.repo.data.NEUIngredient;
import moe.nea.firmament.deps.repo.data.NEUItem;
import moe.nea.firmament.deps.repo.data.NEURecipe;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NEUMobDropRecipe
implements NEURecipe {
    @SerializedName(value="combat_xp")
    int combatExperience;
    int coins;
    @SerializedName(value="xp")
    int enchantingExperience;
    String name;
    String render;
    String panorama;
    int level;
    List<String> extra;
    List<Drop> drops;
    transient NEUItem dropsFrom;

    @Override
    public void fillItemInfo(NEUItem item) {
        this.dropsFrom = item;
    }

    @Override
    public Collection<NEUIngredient> getAllInputs() {
        return Collections.singletonList(NEUIngredient.fromItem(this.dropsFrom, 1));
    }

    @Override
    public Collection<NEUIngredient> getAllOutputs() {
        ArrayList<NEUIngredient> l = new ArrayList<NEUIngredient>();
        for (Drop drop : this.drops) {
            l.add(drop.getDropItem());
        }
        return l;
    }

    public int getCombatExperience() {
        return this.combatExperience;
    }

    public int getCoins() {
        return this.coins;
    }

    public int getEnchantingExperience() {
        return this.enchantingExperience;
    }

    public String getName() {
        return this.name;
    }

    public String getRender() {
        return this.render;
    }

    public String getPanorama() {
        return this.panorama;
    }

    public int getLevel() {
        return this.level;
    }

    public List<String> getExtra() {
        return this.extra;
    }

    public List<Drop> getDrops() {
        return this.drops;
    }

    public NEUItem getDropsFrom() {
        return this.dropsFrom;
    }

    public static class Drop {
        NEUIngredient dropItem;
        @Nullable String chance;
        List<String> extra;

        public NEUIngredient getDropItem() {
            return this.dropItem;
        }

        public @Nullable String getChance() {
            return this.chance;
        }

        public List<String> getExtra() {
            return this.extra;
        }

        public void setDropItem(NEUIngredient dropItem) {
            this.dropItem = dropItem;
        }

        public void setChance(@Nullable String chance) {
            this.chance = chance;
        }

        public void setExtra(List<String> extra) {
            this.extra = extra;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Drop)) {
                return false;
            }
            Drop other = (Drop)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NEUIngredient this$dropItem = this.getDropItem();
            NEUIngredient other$dropItem = other.getDropItem();
            if (this$dropItem == null ? other$dropItem != null : !this$dropItem.equals(other$dropItem)) {
                return false;
            }
            String this$chance = this.getChance();
            String other$chance = other.getChance();
            if (this$chance == null ? other$chance != null : !this$chance.equals(other$chance)) {
                return false;
            }
            List<String> this$extra = this.getExtra();
            List<String> other$extra = other.getExtra();
            return !(this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Drop;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NEUIngredient $dropItem = this.getDropItem();
            result = result * 59 + ($dropItem == null ? 43 : $dropItem.hashCode());
            String $chance = this.getChance();
            result = result * 59 + ($chance == null ? 43 : $chance.hashCode());
            List<String> $extra = this.getExtra();
            result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
            return result;
        }

        public String toString() {
            return "NEUMobDropRecipe.Drop(dropItem=" + this.getDropItem() + ", chance=" + this.getChance() + ", extra=" + this.getExtra() + ")";
        }

        public Drop(NEUIngredient dropItem, @Nullable String chance, List<String> extra) {
            this.dropItem = dropItem;
            this.chance = chance;
            this.extra = extra;
        }

        public static class Serializer
        implements JsonDeserializer<Drop> {
            public Drop deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json.isJsonPrimitive()) {
                    return new Drop(NEUIngredient.fromString(json.getAsString()), null, Collections.emptyList());
                }
                JsonObject d = json.getAsJsonObject();
                return new Drop(NEUIngredient.fromString(d.get("id").getAsString()), d.has("chance") ? d.get("chance").getAsString() : null, d.has("extra") ? (List)context.deserialize(d.get("extra"), new TypeToken<List<String>>(){}.getType()) : Collections.emptyList());
            }
        }
    }
}

