/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.features.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import moe.nea.firmament.deps.repo.constants.PetLevelingBehaviourOverride;
import moe.nea.firmament.deps.repo.data.NEUItem;
import moe.nea.firmament.features.inventory.ParsedPet;
import moe.nea.firmament.repo.ExpLadders;
import moe.nea.firmament.repo.ItemCache;
import moe.nea.firmament.repo.RepoManager;
import moe.nea.firmament.util.HypixelPetInfo;
import moe.nea.firmament.util.RegexKt;
import moe.nea.firmament.util.ScoreboardUtilKt;
import moe.nea.firmament.util.SkyblockId;
import moe.nea.firmament.util.SkyblockIdKt;
import moe.nea.firmament.util.TextutilKt;
import moe.nea.firmament.util.skyblock.Rarity;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u0004\u0018\u00010\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0017R#\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R3\u0010%\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020#0\"j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020#`$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lmoe/nea/firmament/features/inventory/PetParser;", "", "<init>", "()V", "", "name", "rarityCode", "", "level", "Lmoe/nea/firmament/features/inventory/ParsedPet;", "parsePetChatMessage", "(Ljava/lang/String;Ljava/lang/String;I)Lmoe/nea/firmament/features/inventory/ParsedPet;", "", "Lnet/minecraft/class_2561;", "lines", "parseTabWidget", "(Ljava/util/List;)Lmoe/nea/firmament/features/inventory/ParsedPet;", "Lnet/minecraft/class_1799;", "stack", "parsePetMenuSlot", "(Lnet/minecraft/class_1799;)Lmoe/nea/firmament/features/inventory/ParsedPet;", "Ljava/util/regex/Pattern;", "petNamePattern", "Ljava/util/regex/Pattern;", "petItemPattern", "petExpPattern", "petOverflowExpPattern", "katPattern", "", "Lmoe/nea/firmament/util/skyblock/Rarity;", "reversePetColourMap", "Ljava/util/Map;", "getReversePetColourMap", "()Ljava/util/Map;", "Ljava/util/HashMap;", "Ljava/util/regex/Matcher;", "Lkotlin/collections/HashMap;", "found", "Ljava/util/HashMap;", "getFound", "()Ljava/util/HashMap;", "Firmament"})
public final class PetParser {
    @NotNull
    public static final PetParser INSTANCE = new PetParser();
    @NotNull
    private static final Pattern petNamePattern;
    @NotNull
    private static final Pattern petItemPattern;
    @NotNull
    private static final Pattern petExpPattern;
    @NotNull
    private static final Pattern petOverflowExpPattern;
    @NotNull
    private static final Pattern katPattern;
    @NotNull
    private static final Map<String, Rarity> reversePetColourMap;
    @NotNull
    private static final HashMap<String, Matcher> found;

    private PetParser() {
    }

    @NotNull
    public final Map<String, Rarity> getReversePetColourMap() {
        return reversePetColourMap;
    }

    @NotNull
    public final HashMap<String, Matcher> getFound() {
        return found;
    }

    @Nullable
    public final ParsedPet parsePetChatMessage(@NotNull String name, @NotNull String rarityCode, int level) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rarityCode, (String)"rarityCode");
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String petId = StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null);
        Rarity rarity = reversePetColourMap.get(rarityCode);
        if (rarity == null) {
            rarity = Rarity.COMMON;
        }
        Rarity petRarity = rarity;
        moe.nea.firmament.deps.repo.data.Rarity rarity2 = petRarity.getNeuRepoRarity();
        if (rarity2 == null) {
            return null;
        }
        moe.nea.firmament.deps.repo.data.Rarity neuRarity = rarity2;
        ExpLadders.ExpLadder expLadder = ExpLadders.INSTANCE.getExpLadder(petId, neuRarity);
        double currentExp = 0.0;
        double expForNextLevel = 0.0;
        if (found.containsKey("exp")) {
            String string2 = ((Matcher)MapsKt.getValue((Map)found, (Object)"exp")).group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            currentExp = RegexKt.parseShortNumber(string2);
            String string3 = ((Matcher)MapsKt.getValue((Map)found, (Object)"exp")).group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
            expForNextLevel = RegexKt.parseShortNumber(string3);
        } else {
            expForNextLevel = (double)expLadder.getPetExpForLevel(level + 1) - (double)expLadder.getPetExpForLevel(level);
        }
        double totalExpBeforeLevel = expLadder.getPetExpForLevel(level);
        double totalExp = totalExpBeforeLevel + currentExp;
        Object object = RepoManager.INSTANCE.getNeuRepo().getConstants().getPetLevelingData().getPetLevelingBehaviourOverrides().get(petId);
        int maxLevel = object != null && (object = ((PetLevelingBehaviourOverride)object).getMaxLevel()) != null ? (Integer)object : 100;
        double expForMax = expLadder.getPetExpForLevel(maxLevel);
        Lazy petItemStack = LazyKt.lazy(() -> PetParser.parsePetChatMessage$lambda$0(petId, petRarity));
        return new ParsedPet(name, petRarity, level, -1, expLadder, currentExp, expForNextLevel, totalExp, totalExpBeforeLevel, expForMax, 0.0, "Unknown", (Lazy<class_1799>)petItemStack, false);
    }

    @Nullable
    public final ParsedPet parseTabWidget(@NotNull List<? extends class_2561> lines) {
        double d;
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        found.clear();
        for (class_2561 line : CollectionsKt.reversed((Iterable)lines)) {
            Matcher matcher;
            if (!found.containsKey("kat") && (matcher = katPattern.matcher(ScoreboardUtilKt.formattedString(line))).matches()) {
                ((Map)found).put("kat", matcher);
                continue;
            }
            if (!found.containsKey("exp") && (matcher = petExpPattern.matcher(ScoreboardUtilKt.formattedString(line))).matches()) {
                ((Map)found).put("exp", matcher);
                continue;
            }
            if (!found.containsKey("exp") && (matcher = petOverflowExpPattern.matcher(ScoreboardUtilKt.formattedString(line))).matches()) {
                ((Map)found).put("overflow", matcher);
                continue;
            }
            if (!found.containsKey("item") && (matcher = petItemPattern.matcher(ScoreboardUtilKt.formattedString(line))).matches()) {
                ((Map)found).put("item", matcher);
                continue;
            }
            if (found.containsKey("name") || !(matcher = petNamePattern.matcher(ScoreboardUtilKt.formattedString(line))).matches()) continue;
            ((Map)found).put("name", matcher);
        }
        if (!found.containsKey("name")) {
            return null;
        }
        String string = ((Matcher)MapsKt.getValue((Map)found, (Object)"name")).group(3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        String petName = TextutilKt.titleCase(string);
        Rarity petRarity = (Rarity)((Object)MapsKt.getValue(reversePetColourMap, (Object)((Matcher)MapsKt.getValue((Map)found, (Object)"name")).group(2)));
        String string2 = petName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String petId = StringsKt.replace$default((String)string2, (String)" ", (String)"_", (boolean)false, (int)4, null);
        String string3 = ((Matcher)MapsKt.getValue((Map)found, (Object)"name")).group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
        int petLevel = Integer.parseInt(string3);
        moe.nea.firmament.deps.repo.data.Rarity rarity = petRarity.getNeuRepoRarity();
        if (rarity == null) {
            return null;
        }
        moe.nea.firmament.deps.repo.data.Rarity neuRarity = rarity;
        ExpLadders.ExpLadder expLadder = ExpLadders.INSTANCE.getExpLadder(petId, neuRarity);
        double currentExp = 0.0;
        double expForNextLevel = 0.0;
        if (found.containsKey("exp")) {
            String string4 = ((Matcher)MapsKt.getValue((Map)found, (Object)"exp")).group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
            currentExp = RegexKt.parseShortNumber(string4);
            String string5 = ((Matcher)MapsKt.getValue((Map)found, (Object)"exp")).group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"group(...)");
            expForNextLevel = RegexKt.parseShortNumber(string5);
        } else {
            expForNextLevel = (double)expLadder.getPetExpForLevel(petLevel + 1) - (double)expLadder.getPetExpForLevel(petLevel);
        }
        if (found.containsKey("overflow")) {
            String string6 = ((Matcher)MapsKt.getValue((Map)found, (Object)"overflow")).group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"group(...)");
            d = RegexKt.parseShortNumber(string6);
        } else {
            d = 0.0;
        }
        double overflowExp = d;
        double totalExpBeforeLevel = expLadder.getPetExpForLevel(petLevel);
        double totalExp = totalExpBeforeLevel + currentExp;
        Object object = RepoManager.INSTANCE.getNeuRepo().getConstants().getPetLevelingData().getPetLevelingBehaviourOverrides().get(petId);
        int maxLevel = object != null && (object = ((PetLevelingBehaviourOverride)object).getMaxLevel()) != null ? (Integer)object : 100;
        double expForMax = expLadder.getPetExpForLevel(maxLevel);
        Lazy petItemStack = LazyKt.lazy(() -> PetParser.parseTabWidget$lambda$0(petId, petRarity));
        String petItem = "Unknown";
        if (found.containsKey("item")) {
            String string7 = ((Matcher)MapsKt.getValue((Map)found, (Object)"item")).group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"group(...)");
            petItem = string7;
        }
        return new ParsedPet(petName, petRarity, petLevel, maxLevel, expLadder, currentExp, expForNextLevel, totalExp, totalExpBeforeLevel, expForMax, overflowExp, petItem, (Lazy<class_1799>)petItemStack, false);
    }

    @Nullable
    public final ParsedPet parsePetMenuSlot(@NotNull class_1799 stack) {
        String string;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        HypixelPetInfo hypixelPetInfo = SkyblockIdKt.getPetData(stack);
        if (hypixelPetInfo == null) {
            return null;
        }
        HypixelPetInfo petData = hypixelPetInfo;
        ExpLadders.PetLevel expData = petData.getLevel();
        double overflow = expData.getExpTotal() - (float)expData.getExpRequiredForMaxLevel() > 0.0f ? (double)(expData.getExpTotal() - (float)expData.getExpRequiredForMaxLevel()) : 0.0;
        HypixelPetInfo hypixelPetInfo2 = SkyblockIdKt.getPetData(stack);
        if ((hypixelPetInfo2 != null ? hypixelPetInfo2.getHeldItem() : null) != null) {
            Map<String, NEUItem> map = RepoManager.INSTANCE.getNeuRepo().getItems().getItems();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getItems(...)");
            HypixelPetInfo hypixelPetInfo3 = SkyblockIdKt.getPetData(stack);
            string = ((NEUItem)MapsKt.getValue(map, (Object)(hypixelPetInfo3 != null ? hypixelPetInfo3.getHeldItem() : null))).getDisplayName();
        } else {
            string = "None";
        }
        String petItem = string;
        String string2 = TextutilKt.titleCase(petData.getType());
        Rarity rarity = Rarity.Companion.fromNeuRepo(petData.getTier());
        if (rarity == null) {
            rarity = Rarity.COMMON;
        }
        int n = expData.getCurrentLevel();
        int n2 = expData.getMaxLevel();
        ExpLadders.ExpLadder expLadder = ExpLadders.INSTANCE.getExpLadder(SkyblockId.toString-impl(petData.getSkyblockId-RS9x2LM()), petData.getTier());
        double d = expData.getExpInCurrentLevel();
        double d2 = expData.getExpRequiredForNextLevel();
        double d3 = expData.getExpTotal();
        double d4 = (double)expData.getExpTotal() - (double)expData.getExpInCurrentLevel();
        double d5 = expData.getExpRequiredForMaxLevel();
        Intrinsics.checkNotNull((Object)petItem);
        return new ParsedPet(string2, rarity, n, n2, expLadder, d, d2, d3, d4, d5, overflow, petItem, (Lazy<class_1799>)LazyKt.lazy(() -> PetParser.parsePetMenuSlot$lambda$0(stack)), true);
    }

    private static final class_1799 parsePetChatMessage$lambda$0(String $petId, Rarity $petRarity) {
        return ItemCache.asItemStack-y8cp9ps$default(ItemCache.INSTANCE, RepoManager.INSTANCE.getNeuRepo().getItems().getItems().get($petId + ";" + $petRarity.ordinal()), null, null, 3, null);
    }

    private static final class_1799 parseTabWidget$lambda$0(String $petId, Rarity $petRarity) {
        return ItemCache.asItemStack-y8cp9ps$default(ItemCache.INSTANCE, RepoManager.INSTANCE.getNeuRepo().getItems().getItems().get($petId + ";" + $petRarity.ordinal()), null, null, 3, null);
    }

    private static final class_1799 parsePetMenuSlot$lambda$0(class_1799 $stack) {
        return $stack;
    }

    static {
        Pair[] pairArray = " \u00a77\\[Lvl (\\d{1,3})] \u00a7([fa956d])([\\w\\s]+)";
        int n = 0;
        Pattern pattern = Pattern.compile((String)pairArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        petNamePattern = pattern;
        pairArray = " (\u00a7[fa956dbc4][\\s\\w]+)";
        n = 0;
        Pattern pattern2 = Pattern.compile((String)pairArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        petItemPattern = pattern2;
        pairArray = " \u00a7e((?:\\d{1,3}[,.]?)+\\d*[kM]?)\u00a76\\/\u00a7e((?:\\d{1,3}[,.]?)+\\d*[kM]?) XP \u00a76\\(\\d+(?:.\\d+)?%\\)";
        n = 0;
        Pattern pattern3 = Pattern.compile((String)pairArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        petExpPattern = pattern3;
        pairArray = " \u00a76\\+\u00a7e((?:\\d{1,3}[,.])+\\d*[kM]?) XP";
        n = 0;
        Pattern pattern4 = Pattern.compile((String)pairArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        petOverflowExpPattern = pattern4;
        pairArray = " Kat:.*";
        n = 0;
        Pattern pattern5 = Pattern.compile((String)pairArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern5, (String)"compile(...)");
        katPattern = pattern5;
        pairArray = new Pair[]{TuplesKt.to((Object)"f", (Object)((Object)Rarity.COMMON)), TuplesKt.to((Object)"a", (Object)((Object)Rarity.UNCOMMON)), TuplesKt.to((Object)"9", (Object)((Object)Rarity.RARE)), TuplesKt.to((Object)"5", (Object)((Object)Rarity.EPIC)), TuplesKt.to((Object)"6", (Object)((Object)Rarity.LEGENDARY)), TuplesKt.to((Object)"d", (Object)((Object)Rarity.MYTHIC))};
        reversePetColourMap = MapsKt.mapOf((Pair[])pairArray);
        found = new HashMap();
    }
}

