/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.init;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import moe.nea.firmament.util.compatloader.ICompatMeta;

public class AutoDiscoveryPlugin {
    private static final List<AutoDiscoveryPlugin> mixinPlugins = new ArrayList<AutoDiscoveryPlugin>();
    private String mixinPackage;
    private List<String> mixins = null;

    public static List<String> getDefaultAllMixinClassesFQNs() {
        String defaultName = "moe.nea.firmament.mixins";
        AutoDiscoveryPlugin plugin = new AutoDiscoveryPlugin();
        plugin.setMixinPackage(defaultName);
        List<String> mixins = plugin.getMixins();
        return mixins.stream().map(it -> defaultName + "." + it).toList();
    }

    public static List<AutoDiscoveryPlugin> getMixinPlugins() {
        return mixinPlugins;
    }

    public void setMixinPackage(String mixinPackage) {
        this.mixinPackage = mixinPackage;
        mixinPlugins.add(this);
    }

    public URL getBaseUrlForClassUrl(URL classUrl) {
        String string = classUrl.toString();
        if (classUrl.getProtocol().equals("jar")) {
            try {
                return new URL(string.substring(4).split("!")[0]);
            }
            catch (MalformedURLException e2) {
                throw new RuntimeException(e2);
            }
        }
        if (string.endsWith(".class")) {
            try {
                return new URL(string.replace("\\", "/").replace(this.getClass().getCanonicalName().replace(".", "/") + ".class", ""));
            }
            catch (MalformedURLException e3) {
                throw new RuntimeException(e3);
            }
        }
        return classUrl;
    }

    public String getMixinPackage() {
        return this.mixinPackage;
    }

    public String getMixinBaseDir() {
        return this.mixinPackage.replace(".", "/");
    }

    public void tryAddMixinClass(String className) {
        if (!className.endsWith(".class")) {
            return;
        }
        String norm = className.substring(0, className.length() - ".class".length()).replace("\\", "/").replace("/", ".");
        if (norm.startsWith(this.getMixinPackage() + ".") && !norm.endsWith(".") && ICompatMeta.Companion.shouldLoad(norm)) {
            this.mixins.add(norm.substring(this.getMixinPackage().length() + 1));
        }
    }

    private void tryDiscoverFromContentFile(URL url) {
        Path file;
        try {
            file = Paths.get(this.getBaseUrlForClassUrl(url).toURI());
        }
        catch (URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
        System.out.println("Base directory found at " + String.valueOf(file));
        if (!Files.exists(file, new LinkOption[0])) {
            System.out.println("Skipping non-existing mixin root: " + String.valueOf(file));
            return;
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            this.walkDir(file);
        } else {
            this.walkJar(file);
        }
        System.out.println("Found mixins: " + String.valueOf(this.mixins));
    }

    public List<String> getMixins() {
        if (this.mixins != null) {
            return this.mixins;
        }
        try {
            System.out.println("Trying to discover mixins");
            this.mixins = new ArrayList<String>();
            URL classUrl = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            System.out.println("Found classes at " + String.valueOf(classUrl));
            this.tryDiscoverFromContentFile(classUrl);
            String classRoots = System.getProperty("firmament.classroots");
            if (classRoots != null && !classRoots.isBlank()) {
                System.out.println("Found firmament class roots: " + classRoots);
                for (String s : classRoots.split(File.pathSeparator)) {
                    if (s.isBlank()) continue;
                    this.tryDiscoverFromContentFile(new File(s).toURI().toURL());
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        return this.mixins;
    }

    private void walkDir(Path classRoot) {
        System.out.println("Trying to find mixins from directory");
        Path path = classRoot.resolve(this.getMixinBaseDir());
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> classes = Files.walk(path, new FileVisitOption[0]);){
            classes.map(it -> classRoot.relativize((Path)it).toString()).forEach(this::tryAddMixinClass);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void walkJar(Path file) {
        System.out.println("Trying to find mixins from jar file");
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(file, new OpenOption[0]));){
            ZipEntry next;
            while ((next = zis.getNextEntry()) != null) {
                this.tryAddMixinClass(next.getName());
                zis.closeEntry();
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }
}

