/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.repo;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import moe.nea.firmament.deps.repo.IReloadable;
import moe.nea.firmament.deps.repo.NEURepository;
import moe.nea.firmament.deps.repo.constants.PetLevelingBehaviourOverride;
import moe.nea.firmament.deps.repo.constants.PetLevelingData;
import moe.nea.firmament.deps.repo.data.Rarity;
import moe.nea.firmament.repo.ExpLadders;
import moe.nea.firmament.repo.RepoManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fRT\u0010\u0013\u001aB\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\r0\r \u0012* \u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\r0\r\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lmoe/nea/firmament/repo/ExpLadders;", "Lmoe/nea/firmament/deps/repo/IReloadable;", "<init>", "()V", "Lmoe/nea/firmament/deps/repo/NEURepository;", "repository", "", "reload", "(Lio/github/moulberry/repo/NEURepository;)V", "", "petId", "Lmoe/nea/firmament/deps/repo/data/Rarity;", "rarity", "Lmoe/nea/firmament/repo/ExpLadders$ExpLadder;", "getExpLadder", "(Ljava/lang/String;Lio/github/moulberry/repo/data/Rarity;)Lmoe/nea/firmament/repo/ExpLadders$ExpLadder;", "Lcom/google/common/cache/LoadingCache;", "Lmoe/nea/firmament/repo/ExpLadders$Key;", "kotlin.jvm.PlatformType", "expLadders", "Lcom/google/common/cache/LoadingCache;", "PetLevel", "ExpLadder", "Key", "Firmament"})
public final class ExpLadders
implements IReloadable {
    @NotNull
    public static final ExpLadders INSTANCE = new ExpLadders();
    private static final LoadingCache<Key, ExpLadder> expLadders = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Key, ExpLadder>(){

        /*
         * WARNING - void declaration
         */
        public ExpLadder load(Key key) {
            void $this$mapTo$iv$iv;
            List list;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            PetLevelingData pld = RepoManager.INSTANCE.getNeuRepo().getConstants().getPetLevelingData();
            List exp = pld.getPetExpCostForLevel();
            Integer n = pld.getPetLevelStartOffset().get((Object)((Object)key.getRarity()));
            Intrinsics.checkNotNull((Object)n);
            int offset = ((Number)n).intValue();
            int maxLevel = 100;
            PetLevelingBehaviourOverride override = pld.getPetLevelingBehaviourOverrides().get(key.getPetIdWithoutRarity());
            if (override != null) {
                Integer n2 = override.getMaxLevel();
                maxLevel = n2 != null ? n2 : maxLevel;
                Map<Rarity, Integer> map = override.getPetLevelStartOffset();
                offset = map != null && (map = map.get((Object)((Object)key.getRarity()))) != null ? (Integer)((Object)map) : offset;
                PetLevelingBehaviourOverride.PetExpModifierType petExpModifierType = override.getPetExpCostModifierType();
                switch (petExpModifierType == null ? -1 : expLadders.WhenMappings.$EnumSwitchMapping$0[petExpModifierType.ordinal()]) {
                    case 1: {
                        list = exp;
                        Intrinsics.checkNotNull(list);
                        Collection collection = list;
                        List<Integer> list2 = override.getPetExpCostModifier();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getPetExpCostModifier(...)");
                        exp = CollectionsKt.plus((Collection)collection, (Iterable)list2);
                        break;
                    }
                    case 2: {
                        exp = override.getPetExpCostModifier();
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            List list3 = exp;
            Intrinsics.checkNotNull(list3);
            List $this$map$iv = CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)list3, (int)offset), (int)(maxLevel - 1));
            boolean $i$f$map = false;
            list = $this$map$iv;
            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Integer n3 = (Integer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Long.valueOf(it.intValue()));
            }
            List list4 = (List)destination$iv$iv;
            return new ExpLadder(list4);
        }
    });

    private ExpLadders() {
    }

    @Override
    public void reload(@Nullable NEURepository repository) {
        expLadders.invalidateAll();
    }

    @NotNull
    public final ExpLadder getExpLadder(@NotNull String petId, @NotNull Rarity rarity) {
        Intrinsics.checkNotNullParameter((Object)petId, (String)"petId");
        Intrinsics.checkNotNullParameter((Object)((Object)rarity), (String)"rarity");
        Object object = expLadders.get((Object)new Key(petId, rarity));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ExpLadder)object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J \u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\fH\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b\u001e\u0010\u0011R\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001d\u001a\u0004\b \u0010\u0011\u00a8\u0006!"}, d2={"Lmoe/nea/firmament/repo/ExpLadders$ExpLadder;", "", "", "", "individualLevelCost", "<init>", "(Ljava/util/List;)V", "", "currentExp", "Lmoe/nea/firmament/repo/ExpLadders$PetLevel;", "getPetLevel", "(D)Lmoe/nea/firmament/repo/ExpLadders$PetLevel;", "", "level", "getPetExpForLevel", "(I)J", "component1", "()Ljava/util/List;", "copy", "(Ljava/util/List;)Lmoe/nea/firmament/repo/ExpLadders$ExpLadder;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getIndividualLevelCost", "cumulativeLevelCost", "getCumulativeLevelCost", "Firmament"})
    @SourceDebugExtension(value={"SMAP\nExpLadder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpLadder.kt\nmoe/nea/firmament/repo/ExpLadders$ExpLadder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n2967#2,3:97\n2970#2,6:101\n1563#2:107\n1634#2,3:108\n388#2,7:111\n1#3:100\n*S KotlinDebug\n*F\n+ 1 ExpLadder.kt\nmoe/nea/firmament/repo/ExpLadders$ExpLadder\n*L\n29#1:97,3\n29#1:101,6\n29#1:107\n29#1:108,3\n31#1:111,7\n29#1:100\n*E\n"})
    public static final class ExpLadder {
        @NotNull
        private final List<Long> individualLevelCost;
        @NotNull
        private final List<Long> cumulativeLevelCost;

        /*
         * WARNING - void declaration
         */
        public ExpLadder(@NotNull List<Long> individualLevelCost) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list;
            Iterable $this$runningFold$iv;
            Intrinsics.checkNotNullParameter(individualLevelCost, (String)"individualLevelCost");
            this.individualLevelCost = individualLevelCost;
            Iterable iterable = this.individualLevelCost;
            Float f = Float.valueOf(0.0f);
            ExpLadder expLadder = this;
            boolean $i$f$runningFold22 = false;
            int estimatedSize$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFold$iv, (int)9);
            if (estimatedSize$iv == 0) {
                list = CollectionsKt.listOf((Object)initial$iv);
            } else {
                ArrayList<Object> arrayList;
                ArrayList<Object> $this$runningFold_u24lambda_u240$iv = arrayList = new ArrayList<Object>(estimatedSize$iv + 1);
                boolean bl = false;
                $this$runningFold_u24lambda_u240$iv.add(initial$iv);
                ArrayList<Object> result$iv = arrayList;
                Float accumulator$iv = initial$iv;
                for (Object element$iv : $this$runningFold$iv) {
                    void b;
                    long l = ((Number)element$iv).longValue();
                    float a = ((Number)accumulator$iv).floatValue();
                    boolean bl2 = false;
                    accumulator$iv = Float.valueOf(a + (float)b);
                    result$iv.add(accumulator$iv);
                }
                list = result$iv;
            }
            $this$runningFold$iv = list;
            boolean $i$f$map = false;
            void $i$f$runningFold22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                float result$iv = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((long)it);
            }
            expLadder.cumulativeLevelCost = (List)destination$iv$iv;
        }

        @NotNull
        public final List<Long> getIndividualLevelCost() {
            return this.individualLevelCost;
        }

        @NotNull
        public final List<Long> getCumulativeLevelCost() {
            return this.cumulativeLevelCost;
        }

        @NotNull
        public final PetLevel getPetLevel(double currentExp) {
            int n;
            block1: {
                List<Long> $this$indexOfLast$iv = this.cumulativeLevelCost;
                boolean $i$f$indexOfLast = false;
                ListIterator<Long> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    long it = ((Number)iterator$iv.previous()).longValue();
                    boolean bl = false;
                    if (!((double)it <= currentExp)) continue;
                    n = iterator$iv.nextIndex();
                    break block1;
                }
                n = -1;
            }
            int currentOneIndexedLevel = n + 1;
            long expForNextLevel = currentOneIndexedLevel > this.individualLevelCost.size() ? ((Number)CollectionsKt.last(this.individualLevelCost)).longValue() : ((Number)this.individualLevelCost.get(currentOneIndexedLevel - 1)).longValue();
            float expInCurrentLevel = currentOneIndexedLevel >= this.cumulativeLevelCost.size() ? (float)currentExp - ((Number)CollectionsKt.last(this.cumulativeLevelCost)).floatValue() : RangesKt.coerceAtLeast((float)((float)expForNextLevel - (((Number)this.cumulativeLevelCost.get(currentOneIndexedLevel)).floatValue() - (float)currentExp)), (float)0.0f);
            return new PetLevel(currentOneIndexedLevel, this.cumulativeLevelCost.size(), expForNextLevel, ((Number)CollectionsKt.last(this.cumulativeLevelCost)).longValue(), expInCurrentLevel, (float)currentExp);
        }

        public final long getPetExpForLevel(int level) {
            if (level < 2) {
                return 0L;
            }
            if (level >= this.cumulativeLevelCost.size()) {
                return ((Number)CollectionsKt.last(this.cumulativeLevelCost)).longValue();
            }
            return ((Number)this.cumulativeLevelCost.get(level - 1)).longValue();
        }

        @NotNull
        public final List<Long> component1() {
            return this.individualLevelCost;
        }

        @NotNull
        public final ExpLadder copy(@NotNull List<Long> individualLevelCost) {
            Intrinsics.checkNotNullParameter(individualLevelCost, (String)"individualLevelCost");
            return new ExpLadder(individualLevelCost);
        }

        public static /* synthetic */ ExpLadder copy$default(ExpLadder expLadder, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = expLadder.individualLevelCost;
            }
            return expLadder.copy(list);
        }

        @NotNull
        public String toString() {
            return "ExpLadder(individualLevelCost=" + this.individualLevelCost + ")";
        }

        public int hashCode() {
            return ((Object)this.individualLevelCost).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpLadder)) {
                return false;
            }
            ExpLadder expLadder = (ExpLadder)other;
            return Intrinsics.areEqual(this.individualLevelCost, expLadder.individualLevelCost);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lmoe/nea/firmament/repo/ExpLadders$Key;", "", "", "petIdWithoutRarity", "Lmoe/nea/firmament/deps/repo/data/Rarity;", "rarity", "<init>", "(Ljava/lang/String;Lio/github/moulberry/repo/data/Rarity;)V", "component1", "()Ljava/lang/String;", "component2", "()Lio/github/moulberry/repo/data/Rarity;", "copy", "(Ljava/lang/String;Lio/github/moulberry/repo/data/Rarity;)Lmoe/nea/firmament/repo/ExpLadders$Key;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getPetIdWithoutRarity", "Lmoe/nea/firmament/deps/repo/data/Rarity;", "getRarity", "Firmament"})
    private static final class Key {
        @NotNull
        private final String petIdWithoutRarity;
        @NotNull
        private final Rarity rarity;

        public Key(@NotNull String petIdWithoutRarity, @NotNull Rarity rarity) {
            Intrinsics.checkNotNullParameter((Object)petIdWithoutRarity, (String)"petIdWithoutRarity");
            Intrinsics.checkNotNullParameter((Object)((Object)rarity), (String)"rarity");
            this.petIdWithoutRarity = petIdWithoutRarity;
            this.rarity = rarity;
        }

        @NotNull
        public final String getPetIdWithoutRarity() {
            return this.petIdWithoutRarity;
        }

        @NotNull
        public final Rarity getRarity() {
            return this.rarity;
        }

        @NotNull
        public final String component1() {
            return this.petIdWithoutRarity;
        }

        @NotNull
        public final Rarity component2() {
            return this.rarity;
        }

        @NotNull
        public final Key copy(@NotNull String petIdWithoutRarity, @NotNull Rarity rarity) {
            Intrinsics.checkNotNullParameter((Object)petIdWithoutRarity, (String)"petIdWithoutRarity");
            Intrinsics.checkNotNullParameter((Object)((Object)rarity), (String)"rarity");
            return new Key(petIdWithoutRarity, rarity);
        }

        public static /* synthetic */ Key copy$default(Key key, String string, Rarity rarity, int n, Object object) {
            if ((n & 1) != 0) {
                string = key.petIdWithoutRarity;
            }
            if ((n & 2) != 0) {
                rarity = key.rarity;
            }
            return key.copy(string, rarity);
        }

        @NotNull
        public String toString() {
            return "Key(petIdWithoutRarity=" + this.petIdWithoutRarity + ", rarity=" + this.rarity + ")";
        }

        public int hashCode() {
            int result = this.petIdWithoutRarity.hashCode();
            result = result * 31 + this.rarity.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual((Object)this.petIdWithoutRarity, (Object)key.petIdWithoutRarity)) {
                return false;
            }
            return this.rarity == key.rarity;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0014JL\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u000eJ\u0010\u0010\u001e\u001a\u00020\u001dH\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\u000eR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b\"\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010#\u001a\u0004\b$\u0010\u0011R\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010#\u001a\u0004\b%\u0010\u0011R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010&\u001a\u0004\b'\u0010\u0014R\"\u0010\n\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010&\u001a\u0004\b(\u0010\u0014\"\u0004\b)\u0010*R\u0017\u0010+\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b+\u0010&\u001a\u0004\b,\u0010\u0014R\u0017\u0010-\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b-\u0010&\u001a\u0004\b.\u0010\u0014\u00a8\u0006/"}, d2={"Lmoe/nea/firmament/repo/ExpLadders$PetLevel;", "", "", "currentLevel", "maxLevel", "", "expRequiredForNextLevel", "expRequiredForMaxLevel", "", "expInCurrentLevel", "expTotal", "<init>", "(IIJJFF)V", "component1", "()I", "component2", "component3", "()J", "component4", "component5", "()F", "component6", "copy", "(IIJJFF)Lmoe/nea/firmament/repo/ExpLadders$PetLevel;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getCurrentLevel", "getMaxLevel", "J", "getExpRequiredForNextLevel", "getExpRequiredForMaxLevel", "F", "getExpInCurrentLevel", "getExpTotal", "setExpTotal", "(F)V", "percentageToNextLevel", "getPercentageToNextLevel", "percentageToMaxLevel", "getPercentageToMaxLevel", "Firmament"})
    public static final class PetLevel {
        private final int currentLevel;
        private final int maxLevel;
        private final long expRequiredForNextLevel;
        private final long expRequiredForMaxLevel;
        private final float expInCurrentLevel;
        private float expTotal;
        private final float percentageToNextLevel;
        private final float percentageToMaxLevel;

        public PetLevel(int currentLevel, int maxLevel, long expRequiredForNextLevel, long expRequiredForMaxLevel, float expInCurrentLevel, float expTotal) {
            this.currentLevel = currentLevel;
            this.maxLevel = maxLevel;
            this.expRequiredForNextLevel = expRequiredForNextLevel;
            this.expRequiredForMaxLevel = expRequiredForMaxLevel;
            this.expInCurrentLevel = expInCurrentLevel;
            this.expTotal = expTotal;
            this.percentageToNextLevel = this.expInCurrentLevel / (float)this.expRequiredForNextLevel;
            this.percentageToMaxLevel = this.expTotal / (float)this.expRequiredForMaxLevel;
        }

        public final int getCurrentLevel() {
            return this.currentLevel;
        }

        public final int getMaxLevel() {
            return this.maxLevel;
        }

        public final long getExpRequiredForNextLevel() {
            return this.expRequiredForNextLevel;
        }

        public final long getExpRequiredForMaxLevel() {
            return this.expRequiredForMaxLevel;
        }

        public final float getExpInCurrentLevel() {
            return this.expInCurrentLevel;
        }

        public final float getExpTotal() {
            return this.expTotal;
        }

        public final void setExpTotal(float f) {
            this.expTotal = f;
        }

        public final float getPercentageToNextLevel() {
            return this.percentageToNextLevel;
        }

        public final float getPercentageToMaxLevel() {
            return this.percentageToMaxLevel;
        }

        public final int component1() {
            return this.currentLevel;
        }

        public final int component2() {
            return this.maxLevel;
        }

        public final long component3() {
            return this.expRequiredForNextLevel;
        }

        public final long component4() {
            return this.expRequiredForMaxLevel;
        }

        public final float component5() {
            return this.expInCurrentLevel;
        }

        public final float component6() {
            return this.expTotal;
        }

        @NotNull
        public final PetLevel copy(int currentLevel, int maxLevel, long expRequiredForNextLevel, long expRequiredForMaxLevel, float expInCurrentLevel, float expTotal) {
            return new PetLevel(currentLevel, maxLevel, expRequiredForNextLevel, expRequiredForMaxLevel, expInCurrentLevel, expTotal);
        }

        public static /* synthetic */ PetLevel copy$default(PetLevel petLevel, int n, int n2, long l, long l2, float f, float f2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = petLevel.currentLevel;
            }
            if ((n3 & 2) != 0) {
                n2 = petLevel.maxLevel;
            }
            if ((n3 & 4) != 0) {
                l = petLevel.expRequiredForNextLevel;
            }
            if ((n3 & 8) != 0) {
                l2 = petLevel.expRequiredForMaxLevel;
            }
            if ((n3 & 0x10) != 0) {
                f = petLevel.expInCurrentLevel;
            }
            if ((n3 & 0x20) != 0) {
                f2 = petLevel.expTotal;
            }
            return petLevel.copy(n, n2, l, l2, f, f2);
        }

        @NotNull
        public String toString() {
            return "PetLevel(currentLevel=" + this.currentLevel + ", maxLevel=" + this.maxLevel + ", expRequiredForNextLevel=" + this.expRequiredForNextLevel + ", expRequiredForMaxLevel=" + this.expRequiredForMaxLevel + ", expInCurrentLevel=" + this.expInCurrentLevel + ", expTotal=" + this.expTotal + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.currentLevel);
            result = result * 31 + Integer.hashCode(this.maxLevel);
            result = result * 31 + Long.hashCode(this.expRequiredForNextLevel);
            result = result * 31 + Long.hashCode(this.expRequiredForMaxLevel);
            result = result * 31 + Float.hashCode(this.expInCurrentLevel);
            result = result * 31 + Float.hashCode(this.expTotal);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PetLevel)) {
                return false;
            }
            PetLevel petLevel = (PetLevel)other;
            if (this.currentLevel != petLevel.currentLevel) {
                return false;
            }
            if (this.maxLevel != petLevel.maxLevel) {
                return false;
            }
            if (this.expRequiredForNextLevel != petLevel.expRequiredForNextLevel) {
                return false;
            }
            if (this.expRequiredForMaxLevel != petLevel.expRequiredForMaxLevel) {
                return false;
            }
            if (Float.compare(this.expInCurrentLevel, petLevel.expInCurrentLevel) != 0) {
                return false;
            }
            return Float.compare(this.expTotal, petLevel.expTotal) == 0;
        }
    }
}

