/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.lisp;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import moe.nea.lisp.HasLispPosition;
import moe.nea.lisp.LispAst;
import moe.nea.lisp.LispPosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007\u0005\u0006\u0007\b\t\n\u000bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lmoe/nea/lisp/LispAst;", "Lmoe/nea/lisp/HasLispPosition;", "()V", "toSource", "", "Atom", "LispNode", "NumberLiteral", "Parenthesis", "Program", "Reference", "StringLiteral", "Lmoe/nea/lisp/LispAst$LispNode;", "Lmoe/nea/lisp/LispAst$Program;", "nealisp"})
public abstract class LispAst
implements HasLispPosition {
    private LispAst() {
    }

    @NotNull
    public abstract String toSource();

    public /* synthetic */ LispAst(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lmoe/nea/lisp/LispAst$Program;", "Lmoe/nea/lisp/LispAst;", "position", "Lmoe/nea/lisp/LispPosition;", "nodes", "", "Lmoe/nea/lisp/LispAst$LispNode;", "(Lmoe/nea/lisp/LispPosition;Ljava/util/List;)V", "getNodes", "()Ljava/util/List;", "getPosition", "()Lmoe/nea/lisp/LispPosition;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toSource", "", "toString", "nealisp"})
    public static final class Program
    extends LispAst {
        @NotNull
        private final LispPosition position;
        @NotNull
        private final List<LispNode> nodes;

        public Program(@NotNull LispPosition position, @NotNull List<? extends LispNode> nodes) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            super(null);
            this.position = position;
            this.nodes = nodes;
        }

        @Override
        @NotNull
        public LispPosition getPosition() {
            return this.position;
        }

        @NotNull
        public final List<LispNode> getNodes() {
            return this.nodes;
        }

        @Override
        @NotNull
        public String toSource() {
            return CollectionsKt.joinToString$default((Iterable)this.nodes, (CharSequence)"\n", null, null, (int)0, null, (Function1)toSource.1.INSTANCE, (int)30, null);
        }

        @NotNull
        public final LispPosition component1() {
            return this.getPosition();
        }

        @NotNull
        public final List<LispNode> component2() {
            return this.nodes;
        }

        @NotNull
        public final Program copy(@NotNull LispPosition position, @NotNull List<? extends LispNode> nodes) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            return new Program(position, nodes);
        }

        public static /* synthetic */ Program copy$default(Program program, LispPosition lispPosition, List list, int n, Object object) {
            if ((n & 1) != 0) {
                lispPosition = program.getPosition();
            }
            if ((n & 2) != 0) {
                list = program.nodes;
            }
            return program.copy(lispPosition, list);
        }

        @NotNull
        public String toString() {
            return "Program(position=" + this.getPosition() + ", nodes=" + this.nodes + ')';
        }

        public int hashCode() {
            int result = this.getPosition().hashCode();
            result = result * 31 + ((Object)this.nodes).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Program)) {
                return false;
            }
            Program program = (Program)other;
            if (!Intrinsics.areEqual((Object)this.getPosition(), (Object)program.getPosition())) {
                return false;
            }
            return Intrinsics.areEqual(this.nodes, program.nodes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0005\u0003\u0004\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Lmoe/nea/lisp/LispAst$LispNode;", "Lmoe/nea/lisp/LispAst;", "()V", "Lmoe/nea/lisp/LispAst$Atom;", "Lmoe/nea/lisp/LispAst$NumberLiteral;", "Lmoe/nea/lisp/LispAst$Parenthesis;", "Lmoe/nea/lisp/LispAst$Reference;", "Lmoe/nea/lisp/LispAst$StringLiteral;", "nealisp"})
    public static abstract class LispNode
    extends LispAst {
        private LispNode() {
            super(null);
        }

        public /* synthetic */ LispNode(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lmoe/nea/lisp/LispAst$Atom;", "Lmoe/nea/lisp/LispAst$LispNode;", "position", "Lmoe/nea/lisp/LispPosition;", "label", "", "(Lmoe/nea/lisp/LispPosition;Ljava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "getPosition", "()Lmoe/nea/lisp/LispPosition;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toSource", "toString", "nealisp"})
    public static final class Atom
    extends LispNode {
        @NotNull
        private final LispPosition position;
        @NotNull
        private final String label;

        public Atom(@NotNull LispPosition position, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            super(null);
            this.position = position;
            this.label = label;
        }

        @Override
        @NotNull
        public LispPosition getPosition() {
            return this.position;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @Override
        @NotNull
        public String toSource() {
            return ':' + this.label;
        }

        @NotNull
        public final LispPosition component1() {
            return this.getPosition();
        }

        @NotNull
        public final String component2() {
            return this.label;
        }

        @NotNull
        public final Atom copy(@NotNull LispPosition position, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            return new Atom(position, label);
        }

        public static /* synthetic */ Atom copy$default(Atom atom, LispPosition lispPosition, String string, int n, Object object) {
            if ((n & 1) != 0) {
                lispPosition = atom.getPosition();
            }
            if ((n & 2) != 0) {
                string = atom.label;
            }
            return atom.copy(lispPosition, string);
        }

        @NotNull
        public String toString() {
            return "Atom(position=" + this.getPosition() + ", label=" + this.label + ')';
        }

        public int hashCode() {
            int result = this.getPosition().hashCode();
            result = result * 31 + this.label.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Atom)) {
                return false;
            }
            Atom atom = (Atom)other;
            if (!Intrinsics.areEqual((Object)this.getPosition(), (Object)atom.getPosition())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.label, (Object)atom.label);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lmoe/nea/lisp/LispAst$Reference;", "Lmoe/nea/lisp/LispAst$LispNode;", "position", "Lmoe/nea/lisp/LispPosition;", "label", "", "(Lmoe/nea/lisp/LispPosition;Ljava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "getPosition", "()Lmoe/nea/lisp/LispPosition;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toSource", "toString", "nealisp"})
    public static final class Reference
    extends LispNode {
        @NotNull
        private final LispPosition position;
        @NotNull
        private final String label;

        public Reference(@NotNull LispPosition position, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            super(null);
            this.position = position;
            this.label = label;
        }

        @Override
        @NotNull
        public LispPosition getPosition() {
            return this.position;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @Override
        @NotNull
        public String toSource() {
            return this.label;
        }

        @NotNull
        public final LispPosition component1() {
            return this.getPosition();
        }

        @NotNull
        public final String component2() {
            return this.label;
        }

        @NotNull
        public final Reference copy(@NotNull LispPosition position, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            return new Reference(position, label);
        }

        public static /* synthetic */ Reference copy$default(Reference reference, LispPosition lispPosition, String string, int n, Object object) {
            if ((n & 1) != 0) {
                lispPosition = reference.getPosition();
            }
            if ((n & 2) != 0) {
                string = reference.label;
            }
            return reference.copy(lispPosition, string);
        }

        @NotNull
        public String toString() {
            return "Reference(position=" + this.getPosition() + ", label=" + this.label + ')';
        }

        public int hashCode() {
            int result = this.getPosition().hashCode();
            result = result * 31 + this.label.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Reference)) {
                return false;
            }
            Reference reference = (Reference)other;
            if (!Intrinsics.areEqual((Object)this.getPosition(), (Object)reference.getPosition())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.label, (Object)reference.label);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lmoe/nea/lisp/LispAst$Parenthesis;", "Lmoe/nea/lisp/LispAst$LispNode;", "position", "Lmoe/nea/lisp/LispPosition;", "items", "", "(Lmoe/nea/lisp/LispPosition;Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "getPosition", "()Lmoe/nea/lisp/LispPosition;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toSource", "", "toString", "nealisp"})
    public static final class Parenthesis
    extends LispNode {
        @NotNull
        private final LispPosition position;
        @NotNull
        private final List<LispNode> items;

        public Parenthesis(@NotNull LispPosition position, @NotNull List<? extends LispNode> items) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            super(null);
            this.position = position;
            this.items = items;
        }

        @Override
        @NotNull
        public LispPosition getPosition() {
            return this.position;
        }

        @NotNull
        public final List<LispNode> getItems() {
            return this.items;
        }

        @Override
        @NotNull
        public String toSource() {
            return CollectionsKt.joinToString$default((Iterable)this.items, (CharSequence)" ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)toSource.1.INSTANCE, (int)24, null);
        }

        @NotNull
        public final LispPosition component1() {
            return this.getPosition();
        }

        @NotNull
        public final List<LispNode> component2() {
            return this.items;
        }

        @NotNull
        public final Parenthesis copy(@NotNull LispPosition position, @NotNull List<? extends LispNode> items) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            return new Parenthesis(position, items);
        }

        public static /* synthetic */ Parenthesis copy$default(Parenthesis parenthesis, LispPosition lispPosition, List list, int n, Object object) {
            if ((n & 1) != 0) {
                lispPosition = parenthesis.getPosition();
            }
            if ((n & 2) != 0) {
                list = parenthesis.items;
            }
            return parenthesis.copy(lispPosition, list);
        }

        @NotNull
        public String toString() {
            return "Parenthesis(position=" + this.getPosition() + ", items=" + this.items + ')';
        }

        public int hashCode() {
            int result = this.getPosition().hashCode();
            result = result * 31 + ((Object)this.items).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parenthesis)) {
                return false;
            }
            Parenthesis parenthesis = (Parenthesis)other;
            if (!Intrinsics.areEqual((Object)this.getPosition(), (Object)parenthesis.getPosition())) {
                return false;
            }
            return Intrinsics.areEqual(this.items, parenthesis.items);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lmoe/nea/lisp/LispAst$NumberLiteral;", "Lmoe/nea/lisp/LispAst$LispNode;", "position", "Lmoe/nea/lisp/LispPosition;", "numberValue", "", "(Lmoe/nea/lisp/LispPosition;D)V", "getNumberValue", "()D", "getPosition", "()Lmoe/nea/lisp/LispPosition;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toSource", "", "toString", "nealisp"})
    public static final class NumberLiteral
    extends LispNode {
        @NotNull
        private final LispPosition position;
        private final double numberValue;

        public NumberLiteral(@NotNull LispPosition position, double numberValue) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            super(null);
            this.position = position;
            this.numberValue = numberValue;
        }

        @Override
        @NotNull
        public LispPosition getPosition() {
            return this.position;
        }

        public final double getNumberValue() {
            return this.numberValue;
        }

        @Override
        @NotNull
        public String toSource() {
            return String.valueOf(this.numberValue);
        }

        @NotNull
        public final LispPosition component1() {
            return this.getPosition();
        }

        public final double component2() {
            return this.numberValue;
        }

        @NotNull
        public final NumberLiteral copy(@NotNull LispPosition position, double numberValue) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return new NumberLiteral(position, numberValue);
        }

        public static /* synthetic */ NumberLiteral copy$default(NumberLiteral numberLiteral, LispPosition lispPosition, double d, int n, Object object) {
            if ((n & 1) != 0) {
                lispPosition = numberLiteral.getPosition();
            }
            if ((n & 2) != 0) {
                d = numberLiteral.numberValue;
            }
            return numberLiteral.copy(lispPosition, d);
        }

        @NotNull
        public String toString() {
            return "NumberLiteral(position=" + this.getPosition() + ", numberValue=" + this.numberValue + ')';
        }

        public int hashCode() {
            int result = this.getPosition().hashCode();
            result = result * 31 + Double.hashCode(this.numberValue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NumberLiteral)) {
                return false;
            }
            NumberLiteral numberLiteral = (NumberLiteral)other;
            if (!Intrinsics.areEqual((Object)this.getPosition(), (Object)numberLiteral.getPosition())) {
                return false;
            }
            return Double.compare(this.numberValue, numberLiteral.numberValue) == 0;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lmoe/nea/lisp/LispAst$StringLiteral;", "Lmoe/nea/lisp/LispAst$LispNode;", "position", "Lmoe/nea/lisp/LispPosition;", "parsedString", "", "(Lmoe/nea/lisp/LispPosition;Ljava/lang/String;)V", "getParsedString", "()Ljava/lang/String;", "getPosition", "()Lmoe/nea/lisp/LispPosition;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toSource", "toString", "nealisp"})
    public static final class StringLiteral
    extends LispNode {
        @NotNull
        private final LispPosition position;
        @NotNull
        private final String parsedString;

        public StringLiteral(@NotNull LispPosition position, @NotNull String parsedString) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)parsedString, (String)"parsedString");
            super(null);
            this.position = position;
            this.parsedString = parsedString;
        }

        @Override
        @NotNull
        public LispPosition getPosition() {
            return this.position;
        }

        @NotNull
        public final String getParsedString() {
            return this.parsedString;
        }

        @Override
        @NotNull
        public String toSource() {
            return '\"' + StringsKt.replace$default((String)StringsKt.replace$default((String)this.parsedString, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + '\"';
        }

        @NotNull
        public final LispPosition component1() {
            return this.getPosition();
        }

        @NotNull
        public final String component2() {
            return this.parsedString;
        }

        @NotNull
        public final StringLiteral copy(@NotNull LispPosition position, @NotNull String parsedString) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)parsedString, (String)"parsedString");
            return new StringLiteral(position, parsedString);
        }

        public static /* synthetic */ StringLiteral copy$default(StringLiteral stringLiteral, LispPosition lispPosition, String string, int n, Object object) {
            if ((n & 1) != 0) {
                lispPosition = stringLiteral.getPosition();
            }
            if ((n & 2) != 0) {
                string = stringLiteral.parsedString;
            }
            return stringLiteral.copy(lispPosition, string);
        }

        @NotNull
        public String toString() {
            return "StringLiteral(position=" + this.getPosition() + ", parsedString=" + this.parsedString + ')';
        }

        public int hashCode() {
            int result = this.getPosition().hashCode();
            result = result * 31 + this.parsedString.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StringLiteral)) {
                return false;
            }
            StringLiteral stringLiteral = (StringLiteral)other;
            if (!Intrinsics.areEqual((Object)this.getPosition(), (Object)stringLiteral.getPosition())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parsedString, (Object)stringLiteral.parsedString);
        }
    }
}

