/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.moulconfig.common.text;

import java.util.function.Function;
import java.util.stream.Stream;
import moe.nea.firmament.deps.moulconfig.common.IMinecraft;
import moe.nea.firmament.deps.moulconfig.common.text.DefaultFormattingColour;
import moe.nea.firmament.deps.moulconfig.common.text.StructuredStyle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface StructuredText {
    @NotNull
    public static Mutable of(@NotNull String text) {
        return IMinecraft.INSTANCE.createLiteral(text);
    }

    @NotNull
    public static Mutable empty() {
        return StructuredText.of("");
    }

    @NotNull
    public static Mutable translatable(@NotNull String translationKey, StructuredText ... args) {
        return IMinecraft.INSTANCE.createTranslatable(translationKey, args);
    }

    public Mutable copyShallow();

    @NotNull
    public String getText();

    @NotNull
    public @NotNull Stream<@NotNull StructuredText> getChildren();

    @NotNull
    public StructuredStyle getStyle();

    public void setStyle(StructuredStyle var1);

    public static interface Mutable
    extends StructuredText {
        @NotNull
        public Mutable append(@NotNull StructuredText var1);

        @NotNull
        default public Mutable append(@NotNull String text) {
            return this.append(StructuredText.of(text));
        }

        @NotNull
        default public Mutable withStyle(@NotNull StructuredStyle style) {
            this.setStyle(style);
            return this;
        }

        @NotNull
        default public Mutable modifyStyle(@NotNull @NotNull Function<@NotNull StructuredStyle, @NotNull StructuredStyle> operator) {
            return this.withStyle(operator.apply(this.getStyle()));
        }

        @NotNull
        default public Mutable withColour(int rgb) {
            return this.modifyStyle(it -> it.withColour(rgb));
        }

        @NotNull
        default public Mutable withColour(@NotNull DefaultFormattingColour colour) {
            return this.withColour(colour.getRgb());
        }

        @NotNull
        default public Mutable bold() {
            return this.modifyStyle(it -> it.withBold(true));
        }

        @NotNull
        default public Mutable underlined() {
            return this.modifyStyle(it -> it.withUnderline(true));
        }

        @NotNull
        default public Mutable black() {
            return this.withColour(DefaultFormattingColour.BLACK);
        }

        @NotNull
        default public Mutable darkBlue() {
            return this.withColour(DefaultFormattingColour.DARK_BLUE);
        }

        @NotNull
        default public Mutable darkGreen() {
            return this.withColour(DefaultFormattingColour.DARK_GREEN);
        }

        @NotNull
        default public Mutable darkAqua() {
            return this.withColour(DefaultFormattingColour.DARK_AQUA);
        }

        @NotNull
        default public Mutable darkRed() {
            return this.withColour(DefaultFormattingColour.DARK_RED);
        }

        @NotNull
        default public Mutable darkPurple() {
            return this.withColour(DefaultFormattingColour.DARK_PURPLE);
        }

        @NotNull
        default public Mutable gold() {
            return this.withColour(DefaultFormattingColour.GOLD);
        }

        @NotNull
        default public Mutable grey() {
            return this.withColour(DefaultFormattingColour.GREY);
        }

        @NotNull
        default public Mutable darkGrey() {
            return this.withColour(DefaultFormattingColour.DARK_GREY);
        }

        @NotNull
        default public Mutable blue() {
            return this.withColour(DefaultFormattingColour.BLUE);
        }

        @NotNull
        default public Mutable green() {
            return this.withColour(DefaultFormattingColour.GREEN);
        }

        @NotNull
        default public Mutable aqua() {
            return this.withColour(DefaultFormattingColour.AQUA);
        }

        @NotNull
        default public Mutable red() {
            return this.withColour(DefaultFormattingColour.RED);
        }

        @NotNull
        default public Mutable lightPurple() {
            return this.withColour(DefaultFormattingColour.LIGHT_PURPLE);
        }

        @NotNull
        default public Mutable yellow() {
            return this.withColour(DefaultFormattingColour.YELLOW);
        }

        @NotNull
        default public Mutable white() {
            return this.withColour(DefaultFormattingColour.WHITE);
        }
    }
}

