/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.deps.repo;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import moe.nea.firmament.deps.repo.IReloadable;
import moe.nea.firmament.deps.repo.NEURepoFile;
import moe.nea.firmament.deps.repo.NEURepository;
import moe.nea.firmament.deps.repo.NEURepositoryException;
import moe.nea.firmament.deps.repo.constants.BazaarStocks;
import moe.nea.firmament.deps.repo.constants.Bonuses;
import moe.nea.firmament.deps.repo.constants.Enchants;
import moe.nea.firmament.deps.repo.constants.EssenceCosts;
import moe.nea.firmament.deps.repo.constants.FairySouls;
import moe.nea.firmament.deps.repo.constants.Islands;
import moe.nea.firmament.deps.repo.constants.Leveling;
import moe.nea.firmament.deps.repo.constants.Misc;
import moe.nea.firmament.deps.repo.constants.Parents;
import moe.nea.firmament.deps.repo.constants.PetLevelingData;
import moe.nea.firmament.deps.repo.constants.PetNumbers;
import moe.nea.firmament.deps.repo.data.Rarity;
import moe.nea.firmament.deps.repo.util.PetId;

public class NEUConstants
implements IReloadable {
    Bonuses bonuses;
    Parents parents;
    Enchants enchants;
    EssenceCosts essenceCost;
    FairySouls fairySouls;
    Misc misc;
    Leveling leveling;
    PetLevelingData petLevelingData;
    Map<@PetId String, Map<Rarity, PetNumbers>> petNumbers;
    Islands islands;
    BazaarStocks bazaarStocks;

    @Override
    public void reload(NEURepository repository) throws NEURepositoryException {
        this.bonuses = repository.requireFile("constants/bonuses.json").json(Bonuses.class);
        this.parents = new Parents(repository.requireFile("constants/parents.json").json(new TypeToken<Map<String, List<String>>>(){}));
        this.enchants = repository.requireFile("constants/enchants.json").json(Enchants.class);
        this.essenceCost = new EssenceCosts(repository.requireFile("constants/essencecosts.json").json(JsonObject.class));
        this.fairySouls = new FairySouls(repository.gson, repository.requireFile("constants/fairy_souls.json").json(new TypeToken<Map<String, JsonElement>>(){}));
        this.misc = repository.requireFile("constants/misc.json").json(Misc.class);
        this.leveling = repository.requireFile("constants/leveling.json").json(Leveling.class);
        this.petLevelingData = repository.requireFile("constants/pets.json").json(PetLevelingData.class);
        this.petNumbers = repository.requireFile("constants/petnums.json").json(new TypeToken<Map<String, Map<Rarity, PetNumbers>>>(){});
        NEURepoFile islandsFile = repository.file("constants/islands.json");
        this.islands = islandsFile != null ? islandsFile.json(Islands.class) : new Islands();
        NEURepoFile bazaarFile = repository.file("constants/bazaarstocks.json");
        this.bazaarStocks = new BazaarStocks(bazaarFile != null ? bazaarFile.json(new TypeToken<List<BazaarStocks.InternalRepresentation>>(){}).stream().collect(Collectors.toMap(BazaarStocks.InternalRepresentation::getId, BazaarStocks.InternalRepresentation::getStock)) : Collections.emptyMap());
    }

    public Bonuses getBonuses() {
        return this.bonuses;
    }

    public Parents getParents() {
        return this.parents;
    }

    public Enchants getEnchants() {
        return this.enchants;
    }

    public EssenceCosts getEssenceCost() {
        return this.essenceCost;
    }

    public FairySouls getFairySouls() {
        return this.fairySouls;
    }

    public Misc getMisc() {
        return this.misc;
    }

    public Leveling getLeveling() {
        return this.leveling;
    }

    public PetLevelingData getPetLevelingData() {
        return this.petLevelingData;
    }

    public Map<@PetId String, Map<Rarity, PetNumbers>> getPetNumbers() {
        return this.petNumbers;
    }

    public Islands getIslands() {
        return this.islands;
    }

    public BazaarStocks getBazaarStocks() {
        return this.bazaarStocks;
    }
}

