/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.features.texturepack;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import moe.nea.firmament.Firmament;
import moe.nea.firmament.events.FinalizeResourceManagerEvent;
import moe.nea.firmament.features.texturepack.CustomModelOverrideParser;
import moe.nea.firmament.features.texturepack.FirmamentModelPredicate;
import moe.nea.firmament.features.texturepack.FirmamentModelPredicateParser;
import moe.nea.firmament.features.texturepack.FirmamentRootPredicateSerializer;
import moe.nea.firmament.features.texturepack.HeadModelChooser;
import moe.nea.firmament.features.texturepack.PredicateModel;
import moe.nea.firmament.features.texturepack.predicates.AndPredicate;
import moe.nea.firmament.features.texturepack.predicates.CastPredicate;
import moe.nea.firmament.features.texturepack.predicates.DisplayNamePredicate;
import moe.nea.firmament.features.texturepack.predicates.ExtraAttributesPredicate;
import moe.nea.firmament.features.texturepack.predicates.GenericComponentPredicate;
import moe.nea.firmament.features.texturepack.predicates.ItemPredicate;
import moe.nea.firmament.features.texturepack.predicates.LorePredicate;
import moe.nea.firmament.features.texturepack.predicates.NotPredicate;
import moe.nea.firmament.features.texturepack.predicates.OrPredicate;
import moe.nea.firmament.features.texturepack.predicates.PetPredicate;
import moe.nea.firmament.features.texturepack.predicates.PullingPredicate;
import moe.nea.firmament.features.texturepack.predicates.SkullPredicate;
import moe.nea.firmament.util.json.KJsonOps;
import net.minecraft.class_10443;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0004*\u0001$\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR#\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00060\u001e8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lmoe/nea/firmament/features/texturepack/CustomModelOverrideParser;", "", "<init>", "()V", "", "name", "Lmoe/nea/firmament/features/texturepack/FirmamentModelPredicateParser;", "parser", "", "registerPredicateParser", "(Ljava/lang/String;Lmoe/nea/firmament/features/texturepack/FirmamentModelPredicateParser;)V", "Lcom/google/gson/JsonObject;", "predicates", "", "Lmoe/nea/firmament/features/texturepack/FirmamentModelPredicate;", "parsePredicates", "(Lcom/google/gson/JsonObject;)Ljava/util/List;", "jsonObject", "", "parseCustomModelOverrides", "(Lcom/google/gson/JsonObject;)[Lmoe/nea/firmament/features/texturepack/FirmamentModelPredicate;", "Lmoe/nea/firmament/events/FinalizeResourceManagerEvent;", "event", "finalizeResources", "(Lmoe/nea/firmament/events/FinalizeResourceManagerEvent;)V", "Lcom/mojang/serialization/Codec;", "LEGACY_CODEC", "Lcom/mojang/serialization/Codec;", "getLEGACY_CODEC", "()Lcom/mojang/serialization/Codec;", "", "Lnet/minecraft/class_2960;", "predicateParsers", "Ljava/util/Map;", "getPredicateParsers", "()Ljava/util/Map;", "moe/nea/firmament/features/texturepack/CustomModelOverrideParser.neverPredicate.1", "neverPredicate", "Ljava/util/List;", "Firmament_texturePacks"})
@SourceDebugExtension(value={"SMAP\nCustomModelOverrideParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomModelOverrideParser.kt\nmoe/nea/firmament/features/texturepack/CustomModelOverrideParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,124:1\n37#2:125\n36#2,3:126\n*S KotlinDebug\n*F\n+ 1 CustomModelOverrideParser.kt\nmoe/nea/firmament/features/texturepack/CustomModelOverrideParser\n*L\n108#1:125\n108#1:126,3\n*E\n"})
public final class CustomModelOverrideParser {
    @NotNull
    public static final CustomModelOverrideParser INSTANCE = new CustomModelOverrideParser();
    @NotNull
    private static final Codec<FirmamentModelPredicate> LEGACY_CODEC;
    @NotNull
    private static final Map<class_2960, FirmamentModelPredicateParser> predicateParsers;
    @NotNull
    private static final List<neverPredicate.1> neverPredicate;

    private CustomModelOverrideParser() {
    }

    @NotNull
    public final Codec<FirmamentModelPredicate> getLEGACY_CODEC() {
        return LEGACY_CODEC;
    }

    @NotNull
    public final Map<class_2960, FirmamentModelPredicateParser> getPredicateParsers() {
        return predicateParsers;
    }

    public final void registerPredicateParser(@NotNull String name, @NotNull FirmamentModelPredicateParser parser) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        predicateParsers.put(class_2960.method_60655((String)"firmament", (String)name), parser);
    }

    @NotNull
    public final List<FirmamentModelPredicate> parsePredicates(@Nullable JsonObject predicates) {
        if (predicates == null) {
            return neverPredicate;
        }
        List parsedPredicates = new ArrayList();
        for (String predicateName : predicates.keySet()) {
            FirmamentModelPredicate parsedPredicate;
            FirmamentModelPredicateParser parser;
            if (Intrinsics.areEqual((Object)predicateName, (Object)"cast")) {
                com.google.gson.JsonElement jsonElement = predicates.get(predicateName);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                FirmamentModelPredicate firmamentModelPredicate = CastPredicate.Parser.INSTANCE.parse(jsonElement);
                if (firmamentModelPredicate == null) {
                    return neverPredicate;
                }
                parsedPredicates.add(firmamentModelPredicate);
            }
            if (Intrinsics.areEqual((Object)predicateName, (Object)"pull")) {
                com.google.gson.JsonElement jsonElement = predicates.get(predicateName);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                FirmamentModelPredicate firmamentModelPredicate = PullingPredicate.Parser.INSTANCE.parse(jsonElement);
                if (firmamentModelPredicate == null) {
                    return neverPredicate;
                }
                parsedPredicates.add(firmamentModelPredicate);
            }
            if (Intrinsics.areEqual((Object)predicateName, (Object)"pulling")) {
                parsedPredicates.add(PullingPredicate.Companion.getAnyPulling());
            }
            Intrinsics.checkNotNull((Object)predicateName);
            if (!StringsKt.startsWith$default((String)predicateName, (String)"firmament:", (boolean)false, (int)2, null)) continue;
            class_2960 identifier = class_2960.method_60654((String)predicateName);
            if (predicateParsers.get(identifier) == null) {
                return neverPredicate;
            }
            com.google.gson.JsonElement jsonElement = predicates.get(predicateName);
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
            if (parser.parse(jsonElement) == null) {
                return neverPredicate;
            }
            parsedPredicates.add(parsedPredicate);
        }
        return parsedPredicates;
    }

    @JvmStatic
    @Nullable
    public static final FirmamentModelPredicate[] parseCustomModelOverrides(@NotNull JsonObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        com.google.gson.JsonElement jsonElement = jsonObject.get("predicate");
        JsonObject jsonObject2 = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        if (jsonObject2 == null) {
            return null;
        }
        JsonObject predicates = jsonObject2;
        List<FirmamentModelPredicate> parsedPredicates = INSTANCE.parsePredicates(predicates);
        if (parsedPredicates.isEmpty()) {
            return null;
        }
        Collection $this$toTypedArray$iv = parsedPredicates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FirmamentModelPredicate[0]);
    }

    public final void finalizeResources(@NotNull FinalizeResourceManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        class_10443.field_55336.method_65325((Object)Firmament.INSTANCE.identifier("predicates/legacy"), PredicateModel.Unbaked.Companion.getCODEC());
        class_10443.field_55336.method_65325((Object)Firmament.INSTANCE.identifier("head_model"), HeadModelChooser.Unbaked.Companion.getCODEC());
    }

    static {
        Codec codec = Codec.of((Encoder)Encoder.error((String)"cannot encode legacy firmament model predicates"), (Decoder)((Decoder)new Decoder<FirmamentModelPredicate>(){

            public <T> DataResult<Pair<FirmamentModelPredicate, T>> decode(DynamicOps<T> ops, T input) {
                Intrinsics.checkNotNullParameter(ops, (String)"ops");
                try {
                    Json json = Firmament.INSTANCE.getJson();
                    DeserializationStrategy deserializationStrategy = (DeserializationStrategy)FirmamentRootPredicateSerializer.INSTANCE;
                    Object object = ops.convertTo((DynamicOps)KJsonOps.Companion.getINSTANCE(), input);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"convertTo(...)");
                    FirmamentModelPredicate pred = (FirmamentModelPredicate)json.decodeFromJsonElement(deserializationStrategy, (JsonElement)object);
                    DataResult dataResult = DataResult.success((Object)Pair.of((Object)pred, (Object)ops.empty()));
                    Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"success(...)");
                    return dataResult;
                }
                catch (Exception ex) {
                    DataResult dataResult = DataResult.error(() -> LEGACY_CODEC.1.decode$lambda$0(ex));
                    Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"error(...)");
                    return dataResult;
                }
            }

            private static final String decode$lambda$0(Exception $ex) {
                return "Could not deserialize " + $ex.getMessage();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"of(...)");
        LEGACY_CODEC = codec;
        predicateParsers = new LinkedHashMap();
        INSTANCE.registerPredicateParser("display_name", DisplayNamePredicate.Parser.INSTANCE);
        INSTANCE.registerPredicateParser("lore", LorePredicate.Parser.INSTANCE);
        INSTANCE.registerPredicateParser("all", AndPredicate.Parser.INSTANCE);
        INSTANCE.registerPredicateParser("any", OrPredicate.Parser.INSTANCE);
        INSTANCE.registerPredicateParser("not", NotPredicate.Parser.INSTANCE);
        INSTANCE.registerPredicateParser("item", ItemPredicate.Parser.INSTANCE);
        INSTANCE.registerPredicateParser("extra_attributes", ExtraAttributesPredicate.Parser.INSTANCE);
        INSTANCE.registerPredicateParser("pet", PetPredicate.Parser.INSTANCE);
        INSTANCE.registerPredicateParser("component", GenericComponentPredicate.Parser.INSTANCE);
        INSTANCE.registerPredicateParser("skull", SkullPredicate.Parser.INSTANCE);
        neverPredicate = CollectionsKt.listOf((Object)new FirmamentModelPredicate(){

            public boolean test(class_1799 stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return false;
            }

            public boolean test(class_1799 stack, class_1309 holder) {
                return FirmamentModelPredicate.DefaultImpls.test(this, stack, holder);
            }
        });
    }
}

