/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.gui.config.storage;

import com.google.gson.JsonObject;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObjectBuilder;
import moe.nea.firmament.events.FirmamentEvent;
import moe.nea.firmament.events.TickEvent;
import moe.nea.firmament.features.debug.DebugLogger;
import moe.nea.firmament.gui.config.storage.ConfigFixEvent;
import moe.nea.firmament.gui.config.storage.ConfigLoadContext;
import moe.nea.firmament.gui.config.storage.ConfigStorageClass;
import moe.nea.firmament.gui.config.storage.FirstLevelSplitJsonFolder;
import moe.nea.firmament.gui.config.storage.LegacyImporter;
import moe.nea.firmament.util.SBData;
import moe.nea.firmament.util.TimeMark;
import moe.nea.firmament.util.data.IConfigProvider;
import moe.nea.firmament.util.data.IDataHolder;
import moe.nea.firmament.util.data.ProfileKeyedConfig;
import moe.nea.firmament.util.json.JsonConversionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J-\u0010\f\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00062\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u000e\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00062\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ+\u0010\u0012\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u001d\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u0003J\r\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\u0003J/\u0010#\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b#\u0010$J'\u0010'\u001a\u00020\u00072\u0006\u0010%\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010+\u001a\u00020\u00042\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J-\u00102\u001a\u00020\u00042\n\u0010.\u001a\u0006\u0012\u0002\b\u00030-2\u0012\b\u0002\u00101\u001a\f\u0012\u0006\u0012\u0004\u0018\u000100\u0018\u00010/\u00a2\u0006\u0004\b2\u00103R\u001a\u00104\u001a\u00020!8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R\u001f\u0010:\u001a\n 9*\u0004\u0018\u000108088\u0006\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R\u001f\u0010>\u001a\n 9*\u0004\u0018\u000108088\u0006\u00a2\u0006\f\n\u0004\b>\u0010;\u001a\u0004\b?\u0010=R\u001f\u0010@\u001a\n 9*\u0004\u0018\u000108088\u0006\u00a2\u0006\f\n\u0004\b@\u0010;\u001a\u0004\bA\u0010=R\u001d\u0010D\u001a\b\u0012\u0004\u0012\u00020C0B8\u0006\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010GR\u001f\u0010H\u001a\n 9*\u0004\u0018\u000108088\u0006\u00a2\u0006\f\n\u0004\bH\u0010;\u001a\u0004\bI\u0010=R!\u0010J\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0B8\u0006\u00a2\u0006\f\n\u0004\bJ\u0010E\u001a\u0004\bK\u0010GR\u0017\u0010M\u001a\u00020L8\u0006\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010PR,\u0010Q\u001a\f\u0012\u0006\u0012\u0004\u0018\u000100\u0018\u00010/8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\"\u0010X\u001a\u00020W8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bX\u0010Y\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]\u00a8\u0006^"}, d2={"Lmoe/nea/firmament/gui/config/storage/FirmamentConfigLoader;", "", "<init>", "()V", "", "loadConfig", "T", "Lkotlinx/serialization/json/JsonObject;", "configData", "key", "Lmoe/nea/firmament/gui/config/storage/ConfigStorageClass;", "storageClass", "loadConfigFromData", "(Lkotlinx/serialization/json/JsonObject;Ljava/lang/Object;Lmoe/nea/firmament/gui/config/storage/ConfigStorageClass;)V", "collectConfigFromData", "(Ljava/lang/Object;Lmoe/nea/firmament/gui/config/storage/ConfigStorageClass;)Lkotlinx/serialization/json/JsonObject;", "Lmoe/nea/firmament/gui/config/storage/FirstLevelSplitJsonFolder;", "firstLevelSplitJsonFolder", "saveStorage", "(Lmoe/nea/firmament/gui/config/storage/ConfigStorageClass;Ljava/lang/Object;Lmoe/nea/firmament/gui/config/storage/FirstLevelSplitJsonFolder;)V", "", "Ljava/util/UUID;", "collectAllProfileIds", "()Ljava/util/Set;", "saveAll", "a", "b", "mergeJson", "(Lkotlinx/serialization/json/JsonObject;Lkotlinx/serialization/json/JsonObject;)Lkotlinx/serialization/json/JsonObject;", "updateConfigs", "writeConfigVersion", "Lmoe/nea/firmament/gui/config/storage/ConfigLoadContext;", "loadContext", "", "startVersion", "updateOneConfig", "(Lmoe/nea/firmament/gui/config/storage/ConfigLoadContext;ILmoe/nea/firmament/gui/config/storage/ConfigStorageClass;Lmoe/nea/firmament/gui/config/storage/FirstLevelSplitJsonFolder;)V", "nextVersion", "data", "updateOneConfigOnce", "(ILmoe/nea/firmament/gui/config/storage/ConfigStorageClass;Lkotlinx/serialization/json/JsonObject;)Lkotlinx/serialization/json/JsonObject;", "Lmoe/nea/firmament/events/TickEvent;", "event", "onTick", "(Lmoe/nea/firmament/events/TickEvent;)V", "Lmoe/nea/firmament/util/data/IDataHolder;", "holder", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "timeoutPromise", "markDirty", "(Lmoe/nea/firmament/util/data/IDataHolder;Ljava/util/concurrent/CompletableFuture;)V", "currentConfigVersion", "I", "getCurrentConfigVersion", "()I", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "configFolder", "Ljava/nio/file/Path;", "getConfigFolder", "()Ljava/nio/file/Path;", "storageFolder", "getStorageFolder", "profilePath", "getProfilePath", "", "", "tagLines", "Ljava/util/List;", "getTagLines", "()Ljava/util/List;", "configVersionFile", "getConfigVersionFile", "allConfigs", "getAllConfigs", "Lmoe/nea/firmament/features/debug/DebugLogger;", "debugLogger", "Lmoe/nea/firmament/features/debug/DebugLogger;", "getDebugLogger", "()Lmoe/nea/firmament/features/debug/DebugLogger;", "configPromise", "Ljava/util/concurrent/CompletableFuture;", "getConfigPromise", "()Ljava/util/concurrent/CompletableFuture;", "setConfigPromise", "(Ljava/util/concurrent/CompletableFuture;)V", "Lmoe/nea/firmament/util/TimeMark;", "saveDebounceStart", "Lmoe/nea/firmament/util/TimeMark;", "getSaveDebounceStart", "()Lmoe/nea/firmament/util/TimeMark;", "setSaveDebounceStart", "(Lmoe/nea/firmament/util/TimeMark;)V", "Firmament"})
@SourceDebugExtension(value={"SMAP\nFirmamentConfigLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirmamentConfigLoader.kt\nmoe/nea/firmament/gui/config/storage/FirmamentConfigLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,251:1\n774#2:252\n865#2,2:253\n1460#2,5:255\n774#2:261\n865#2,2:262\n1193#2,2:264\n1267#2,4:266\n1869#2,2:272\n1869#2,2:276\n1374#2:279\n1460#2,5:280\n1#3:260\n216#4,2:270\n29#5,2:274\n31#5:278\n*S KotlinDebug\n*F\n+ 1 FirmamentConfigLoader.kt\nmoe/nea/firmament/gui/config/storage/FirmamentConfigLoader\n*L\n113#1:252\n113#1:253,2\n114#1:255,5\n59#1:261\n59#1:262,2\n60#1:264,2\n60#1:266,4\n131#1:272,2\n152#1:276,2\n160#1:279\n160#1:280,5\n65#1:270,2\n150#1:274,2\n150#1:278\n*E\n"})
public final class FirmamentConfigLoader {
    @NotNull
    public static final FirmamentConfigLoader INSTANCE;
    private static final int currentConfigVersion;
    private static final Path configFolder;
    private static final Path storageFolder;
    private static final Path profilePath;
    @NotNull
    private static final List<String> tagLines;
    private static final Path configVersionFile;
    @NotNull
    private static final List<IDataHolder<?>> allConfigs;
    @NotNull
    private static final DebugLogger debugLogger;
    @Nullable
    private static CompletableFuture<Void> configPromise;
    @NotNull
    private static TimeMark saveDebounceStart;

    private FirmamentConfigLoader() {
    }

    public final int getCurrentConfigVersion() {
        return currentConfigVersion;
    }

    public final Path getConfigFolder() {
        return configFolder;
    }

    public final Path getStorageFolder() {
        return storageFolder;
    }

    public final Path getProfilePath() {
        return profilePath;
    }

    @NotNull
    public final List<String> getTagLines() {
        return tagLines;
    }

    public final Path getConfigVersionFile() {
        return configVersionFile;
    }

    public final void loadConfig() {
        Path path = configFolder;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"configFolder");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Path path3 = configVersionFile;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"configVersionFile");
            path2 = path3;
            linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LegacyImporter.INSTANCE.importFromLegacy();
            }
            this.updateConfigs();
        }
        new ConfigLoadContext("load-" + System.currentTimeMillis()).use((Function1<? super ConfigLoadContext, Unit>)((Function1)FirmamentConfigLoader::loadConfig$lambda$4));
    }

    public final <T> void loadConfigFromData(@NotNull kotlinx.serialization.json.JsonObject configData, @Nullable T key, @NotNull ConfigStorageClass storageClass) {
        Intrinsics.checkNotNullParameter((Object)configData, (String)"configData");
        Intrinsics.checkNotNullParameter((Object)((Object)storageClass), (String)"storageClass");
        for (IDataHolder<?> holder : allConfigs) {
            if (holder.getStorageClass() != storageClass) continue;
            Intrinsics.checkNotNull(holder, (String)"null cannot be cast to non-null type moe.nea.firmament.util.data.IDataHolder<T of moe.nea.firmament.gui.config.storage.FirmamentConfigLoader.loadConfigFromData>");
            IDataHolder<?> h = holder;
            if (key == null) {
                h.explicitDefaultLoad();
                continue;
            }
            h.loadFrom(key, configData);
        }
    }

    @NotNull
    public final <T> kotlinx.serialization.json.JsonObject collectConfigFromData(T key, @NotNull ConfigStorageClass storageClass) {
        Intrinsics.checkNotNullParameter((Object)((Object)storageClass), (String)"storageClass");
        kotlinx.serialization.json.JsonObject json = new kotlinx.serialization.json.JsonObject(MapsKt.emptyMap());
        for (IDataHolder<?> holder : allConfigs) {
            if (holder.getStorageClass() != storageClass) continue;
            Intrinsics.checkNotNull(holder, (String)"null cannot be cast to non-null type moe.nea.firmament.util.data.IDataHolder<T of moe.nea.firmament.gui.config.storage.FirmamentConfigLoader.collectConfigFromData>");
            json = this.mergeJson(json, holder.saveTo(key));
        }
        return json;
    }

    public final <T> void saveStorage(@NotNull ConfigStorageClass storageClass, T key, @NotNull FirstLevelSplitJsonFolder firstLevelSplitJsonFolder) {
        Intrinsics.checkNotNullParameter((Object)((Object)storageClass), (String)"storageClass");
        Intrinsics.checkNotNullParameter((Object)firstLevelSplitJsonFolder, (String)"firstLevelSplitJsonFolder");
        firstLevelSplitJsonFolder.save(this.collectConfigFromData(key, storageClass));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<UUID> collectAllProfileIds() {
        void var2_3;
        void $this$flatMapTo$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = allConfigs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IDataHolder it = (IDataHolder)element$iv$iv;
            boolean bl = false;
            if (!(it.getStorageClass() == ConfigStorageClass.PROFILE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            IDataHolder it = (IDataHolder)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type moe.nea.firmament.util.data.ProfileKeyedConfig<*>");
            Iterable list$iv = ((ProfileKeyedConfig)it).keys();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_3;
    }

    public final void saveAll() {
        new ConfigLoadContext("save-" + System.currentTimeMillis()).use((Function1<? super ConfigLoadContext, Unit>)((Function1)FirmamentConfigLoader::saveAll$lambda$8));
    }

    @NotNull
    public final kotlinx.serialization.json.JsonObject mergeJson(@NotNull kotlinx.serialization.json.JsonObject a, @NotNull kotlinx.serialization.json.JsonObject b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        JsonElement jsonElement = FirmamentConfigLoader.mergeJson$mergeInner((JsonElement)a, (JsonElement)b);
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
        return (kotlinx.serialization.json.JsonObject)jsonElement;
    }

    @NotNull
    public final List<IDataHolder<?>> getAllConfigs() {
        return allConfigs;
    }

    public final void updateConfigs() {
        Path path = configVersionFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"configVersionFile");
        int startVersion = Integer.parseInt(((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)PathsKt.readText$default((Path)path, null, (int)1, null), (char)' ', null, (int)2, null))).toString());
        new ConfigLoadContext("update-from-" + startVersion + "-to-" + currentConfigVersion + "-" + System.currentTimeMillis()).use((Function1<? super ConfigLoadContext, Unit>)((Function1)arg_0 -> FirmamentConfigLoader.updateConfigs$lambda$13(startVersion, arg_0)));
    }

    public final void writeConfigVersion() {
        Path path = configVersionFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"configVersionFile");
        PathsKt.writeText$default((Path)path, (CharSequence)(currentConfigVersion + " " + CollectionsKt.random((Collection)tagLines, (Random)((Random)Random.Default))), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final void updateOneConfig(ConfigLoadContext loadContext, int startVersion, ConfigStorageClass storageClass, FirstLevelSplitJsonFolder firstLevelSplitJsonFolder) {
        if (startVersion == currentConfigVersion) {
            loadContext.logDebug("Skipping upgrade to ");
            return;
        }
        loadContext.logInfo("Starting upgrade from at " + firstLevelSplitJsonFolder.getFolder() + " (" + storageClass + ") to " + startVersion);
        kotlinx.serialization.json.JsonObject data = firstLevelSplitJsonFolder.load();
        int nextVersion = startVersion + 1;
        int n = currentConfigVersion;
        if (nextVersion <= n) {
            while (true) {
                data = this.updateOneConfigOnce(nextVersion, storageClass, data);
                if (nextVersion == n) break;
                ++nextVersion;
            }
        }
        firstLevelSplitJsonFolder.save(data);
    }

    private final kotlinx.serialization.json.JsonObject updateOneConfigOnce(int nextVersion, ConfigStorageClass storageClass, kotlinx.serialization.json.JsonObject data) {
        JsonObject jsonObject = JsonConversionKt.intoGson((JsonElement)data).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
        return JsonElementKt.getJsonObject((JsonElement)JsonConversionKt.intoKotlinJson((com.google.gson.JsonElement)((ConfigFixEvent)ConfigFixEvent.Companion.publish((FirmamentEvent)new ConfigFixEvent(storageClass, nextVersion, jsonObject))).getData()));
    }

    public final void onTick(@NotNull TickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CompletableFuture<Void> completableFuture = configPromise;
        if (completableFuture == null) {
            return;
        }
        CompletableFuture<Void> config = completableFuture;
        long passedTime = saveDebounceStart.passedTime-UwyO8pc();
        if (Duration.compareTo-LRDsOJo((long)passedTime, (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (!config.isDone()) {
            if (Duration.compareTo-LRDsOJo((long)passedTime, (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)) < 0) {
                return;
            }
        }
        debugLogger.log("Performing config save");
        configPromise = null;
        this.saveAll();
    }

    @NotNull
    public final DebugLogger getDebugLogger() {
        return debugLogger;
    }

    @Nullable
    public final CompletableFuture<Void> getConfigPromise() {
        return configPromise;
    }

    public final void setConfigPromise(@Nullable CompletableFuture<Void> completableFuture) {
        configPromise = completableFuture;
    }

    @NotNull
    public final TimeMark getSaveDebounceStart() {
        return saveDebounceStart;
    }

    public final void setSaveDebounceStart(@NotNull TimeMark timeMark) {
        Intrinsics.checkNotNullParameter((Object)timeMark, (String)"<set-?>");
        saveDebounceStart = timeMark;
    }

    public final void markDirty(@NotNull IDataHolder<?> holder, @Nullable CompletableFuture<Void> timeoutPromise) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        debugLogger.log("Config marked dirty");
        saveDebounceStart = TimeMark.Companion.now();
        CompletableFuture<Void> completableFuture = timeoutPromise;
        if (completableFuture == null) {
            completableFuture = CompletableFuture.completedFuture(null);
        }
        configPromise = completableFuture;
    }

    public static /* synthetic */ void markDirty$default(FirmamentConfigLoader firmamentConfigLoader, IDataHolder iDataHolder, CompletableFuture completableFuture, int n, Object object) {
        if ((n & 2) != 0) {
            completableFuture = null;
        }
        firmamentConfigLoader.markDirty(iDataHolder, completableFuture);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit loadConfig$lambda$4(ConfigLoadContext loadContext) {
        Map map;
        Path path;
        Iterable<Path> iterable;
        Intrinsics.checkNotNullParameter((Object)loadContext, (String)"loadContext");
        Path path2 = configFolder;
        Intrinsics.checkNotNull((Object)path2);
        kotlinx.serialization.json.JsonObject configData = new FirstLevelSplitJsonFolder(loadContext, path2).load();
        INSTANCE.loadConfigFromData(configData, Unit.INSTANCE, ConfigStorageClass.CONFIG);
        Path path3 = storageFolder;
        Intrinsics.checkNotNull((Object)path3);
        kotlinx.serialization.json.JsonObject storageData = new FirstLevelSplitJsonFolder(loadContext, path3).load();
        INSTANCE.loadConfigFromData(storageData, Unit.INSTANCE, ConfigStorageClass.STORAGE);
        Path it = iterable = profilePath;
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path path4 = path = Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? iterable : null;
        if (path != null && (iterable = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null)) != null) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable bl2 = iterable;
            boolean $i$f$filter = false;
            void var9_13 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it2 = (Path)element$iv$iv;
                boolean bl3 = false;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isDirectory(it2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                Path it3 = (Path)element$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)UUID.fromString(PathsKt.getName((Path)it3)), (Object)new FirstLevelSplitJsonFolder(loadContext, it3).load());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv2;
        } else {
            map = null;
        }
        Map profileData = map;
        path = profileData;
        if (path == null || path.isEmpty()) {
            profileData = MapsKt.mapOf((Pair)TuplesKt.to((Object)SBData.INSTANCE.getNULL_UUID(), (Object)new kotlinx.serialization.json.JsonObject(MapsKt.emptyMap())));
        }
        Map $this$forEach$iv = profileData;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl5 = false;
            UUID key = (UUID)entry.getKey();
            kotlinx.serialization.json.JsonObject value = (kotlinx.serialization.json.JsonObject)entry.getValue();
            INSTANCE.loadConfigFromData(value, key, ConfigStorageClass.PROFILE);
        }
        return Unit.INSTANCE;
    }

    private static final Unit saveAll$lambda$8(ConfigLoadContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path path = configFolder;
        Intrinsics.checkNotNull((Object)path);
        INSTANCE.saveStorage(ConfigStorageClass.CONFIG, Unit.INSTANCE, new FirstLevelSplitJsonFolder(context, path));
        path = storageFolder;
        Intrinsics.checkNotNull((Object)path);
        INSTANCE.saveStorage(ConfigStorageClass.STORAGE, Unit.INSTANCE, new FirstLevelSplitJsonFolder(context, path));
        Iterable $this$forEach$iv = INSTANCE.collectAllProfileIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID profileId = (UUID)element$iv;
            boolean bl = false;
            Path path2 = profilePath.resolve(profileId.toString());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            INSTANCE.saveStorage(ConfigStorageClass.PROFILE, profileId, new FirstLevelSplitJsonFolder(context, path2));
        }
        INSTANCE.writeConfigVersion();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonElement mergeJson$mergeInner(JsonElement a, JsonElement b) {
        void $this$forEach$iv;
        JsonObjectBuilder builder$iv;
        if (a == null) {
            JsonElement jsonElement = b;
            Intrinsics.checkNotNull((Object)jsonElement);
            return jsonElement;
        }
        if (b == null) {
            return a;
        }
        kotlinx.serialization.json.JsonObject cfr_ignored_0 = (kotlinx.serialization.json.JsonObject)a;
        kotlinx.serialization.json.JsonObject cfr_ignored_1 = (kotlinx.serialization.json.JsonObject)b;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$mergeJson_u24mergeInner_u24lambda_u2410 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        Iterable iterable = SetsKt.plus((Set)((kotlinx.serialization.json.JsonObject)a).keySet(), (Iterable)((kotlinx.serialization.json.JsonObject)b).keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$mergeJson_u24mergeInner_u24lambda_u2410.put(it, FirmamentConfigLoader.mergeJson$mergeInner((JsonElement)((kotlinx.serialization.json.JsonObject)a).get((Object)it), (JsonElement)((kotlinx.serialization.json.JsonObject)b).get((Object)it)));
        }
        return (JsonElement)builder$iv.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateConfigs$lambda$13(int $startVersion, ConfigLoadContext loadContext) {
        Intrinsics.checkNotNullParameter((Object)loadContext, (String)"loadContext");
        Path path = configFolder;
        Intrinsics.checkNotNull((Object)path);
        INSTANCE.updateOneConfig(loadContext, $startVersion, ConfigStorageClass.CONFIG, new FirstLevelSplitJsonFolder(loadContext, path));
        path = storageFolder;
        Intrinsics.checkNotNull((Object)path);
        INSTANCE.updateOneConfig(loadContext, $startVersion, ConfigStorageClass.STORAGE, new FirstLevelSplitJsonFolder(loadContext, path));
        path = profilePath;
        Intrinsics.checkNotNull((Object)path);
        Closeable closeable = Files.newDirectoryStream(path, "*");
        Throwable throwable = null;
        try {
            DirectoryStream directoryStream = (DirectoryStream)closeable;
            Intrinsics.checkNotNull((Object)directoryStream);
            Iterable iterable = directoryStream;
            for (Path it : iterable) {
                boolean bl = false;
                INSTANCE.updateOneConfig(loadContext, $startVersion, ConfigStorageClass.PROFILE, new FirstLevelSplitJsonFolder(loadContext, it));
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        INSTANCE.writeConfigVersion();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$flatMapTo$iv$iv;
        INSTANCE = new FirmamentConfigLoader();
        currentConfigVersion = 1000;
        Path path = Paths.get("config/firmament", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        configFolder = path.toAbsolutePath();
        storageFolder = configFolder.resolve("storage");
        profilePath = configFolder.resolve("profiles");
        Object[] objectArray = new String[]{"<- your config version here", "I'm a teapot", "mail.example.com ESMTP", "Apples"};
        tagLines = CollectionsKt.listOf((Object[])objectArray);
        configVersionFile = configFolder.resolve("config.version");
        Iterable $this$flatMap$iv = IConfigProvider.Companion.getProviders().getAllValidInstances();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IConfigProvider it = (IConfigProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getConfigs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        allConfigs = (List)var3_3;
        debugLogger = new DebugLogger("config");
        saveDebounceStart = TimeMark.Companion.farPast();
    }
}

