/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.gui.config.storage;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JvmStreamsKt;
import moe.nea.firmament.Firmament;
import moe.nea.firmament.gui.config.storage.ConfigLoadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010!R\"\u0010#\u001a\u00020\"8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lmoe/nea/firmament/gui/config/storage/FirstLevelSplitJsonFolder;", "", "Lmoe/nea/firmament/gui/config/storage/ConfigLoadContext;", "context", "Ljava/nio/file/Path;", "folder", "<init>", "(Lmoe/nea/firmament/gui/config/storage/ConfigLoadContext;Ljava/nio/file/Path;)V", "", "cause", "", "backup", "(Ljava/lang/String;)V", "Lkotlinx/serialization/json/JsonObject;", "load", "()Lkotlinx/serialization/json/JsonObject;", "path", "Lkotlin/Pair;", "Lkotlinx/serialization/json/JsonElement;", "loadIndividualFile", "(Ljava/nio/file/Path;)Lkotlin/Pair;", "value", "save", "(Lkotlinx/serialization/json/JsonObject;)V", "name", "element", "saveIndividualFile", "(Ljava/lang/String;Lkotlinx/serialization/json/JsonElement;)Ljava/nio/file/Path;", "Lmoe/nea/firmament/gui/config/storage/ConfigLoadContext;", "getContext", "()Lmoe/nea/firmament/gui/config/storage/ConfigLoadContext;", "Ljava/nio/file/Path;", "getFolder", "()Ljava/nio/file/Path;", "", "hasCreatedBackup", "Z", "getHasCreatedBackup", "()Z", "setHasCreatedBackup", "(Z)V", "Firmament"})
@SourceDebugExtension(value={"SMAP\nFirstLevelSplitJsonFolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirstLevelSplitJsonFolder.kt\nmoe/nea/firmament/gui/config/storage/FirstLevelSplitJsonFolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1617#2,9:111\n1869#2:120\n1870#2:122\n1626#2:123\n1#3:121\n1#3:124\n*S KotlinDebug\n*F\n+ 1 FirstLevelSplitJsonFolder.kt\nmoe/nea/firmament/gui/config/storage/FirstLevelSplitJsonFolder\n*L\n40#1:111,9\n40#1:120\n40#1:122\n40#1:123\n40#1:121\n*E\n"})
public final class FirstLevelSplitJsonFolder {
    @NotNull
    private final ConfigLoadContext context;
    @NotNull
    private final Path folder;
    private boolean hasCreatedBackup;

    public FirstLevelSplitJsonFolder(@NotNull ConfigLoadContext context, @NotNull Path folder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.context = context;
        this.folder = folder;
    }

    @NotNull
    public final ConfigLoadContext getContext() {
        return this.context;
    }

    @NotNull
    public final Path getFolder() {
        return this.folder;
    }

    public final boolean getHasCreatedBackup() {
        return this.hasCreatedBackup;
    }

    public final void setHasCreatedBackup(boolean bl) {
        this.hasCreatedBackup = bl;
    }

    public final void backup(@NotNull String cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        if (this.hasCreatedBackup) {
            return;
        }
        this.hasCreatedBackup = true;
        this.context.createBackup(this.folder, cause);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonObject load() {
        JsonObject jsonObject;
        this.context.logInfo("Loading FLSJF from " + this.folder);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.folder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return new JsonObject(MapsKt.emptyMap());
        }
        try {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = PathsKt.listDirectoryEntries((Path)this.folder, (String)"*.json");
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair<String, JsonElement> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Path p0 = (Path)element$iv$iv;
                boolean bl2 = false;
                if (this.loadIndividualFile(p0) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Map p0 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            boolean bl = false;
            JsonObject it = jsonObject = new JsonObject(p0);
            boolean bl4 = false;
            this.context.logInfo("FLSJF from " + this.folder + " - Voller Erfolg!");
        }
        catch (Exception ex) {
            this.context.logError("Could not load files from " + this.folder, ex);
            this.backup("failed-load");
            jsonObject = new JsonObject(MapsKt.emptyMap());
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Pair<String, JsonElement> loadIndividualFile(@NotNull Path path) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.context.logDebug("Loading partial file from " + path);
        try {
            Pair pair;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                pair = TuplesKt.to((Object)PathsKt.getNameWithoutExtension((Path)path), (Object)JvmStreamsKt.decodeFromStream((Json)Firmament.INSTANCE.getJson(), (DeserializationStrategy)((DeserializationStrategy)JsonElement.Companion.serializer()), (InputStream)it));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = pair;
        }
        catch (Exception ex) {
            this.context.logError("Could not load file from " + path, ex);
            this.backup("failed-load");
            closeable = null;
        }
        return closeable;
    }

    public final void save(@NotNull JsonObject value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.context.logInfo("Saving FLSJF to " + this.folder);
        this.context.logDebug("Current value:\n" + value);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.folder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.context.logInfo("Creating folder " + this.folder);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(this.folder, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        }
        List entries = CollectionsKt.toMutableList((Collection)PathsKt.listDirectoryEntries((Path)this.folder, (String)"*.json"));
        for (Map.Entry entry : ((Map)value).entrySet()) {
            JsonElement element;
            String name = (String)entry.getKey();
            Path path = this.saveIndividualFile(name, element = (JsonElement)entry.getValue());
            if (path == null) continue;
            entries.remove(path);
        }
        if (!((Collection)entries).isEmpty()) {
            this.context.logInfo("Deleting additional files.");
            for (Path path : entries) {
                this.context.logInfo("Deleting " + path);
                this.backup("save-deletion");
                try {
                    Files.delete(path);
                }
                catch (Exception ex) {
                    this.context.logError("Could not delete " + path, ex);
                }
            }
        }
        this.context.logInfo("FLSJF to " + this.folder + " - Voller Erfolg!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Path saveIndividualFile(@NotNull String name, @NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        try {
            this.context.logDebug("Saving partial file with name " + name);
            Path path = this.folder.resolve(name + ".json");
            Intrinsics.checkNotNull((Object)path);
            this.context.ensureWritable(path);
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                JvmStreamsKt.encodeToStream((Json)Firmament.INSTANCE.getJson(), (SerializationStrategy)((SerializationStrategy)JsonElement.Companion.serializer()), (Object)element, (OutputStream)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return path;
        }
        catch (Exception ex) {
            this.context.logError("Could not save " + name + " with value " + element, ex);
            this.backup("failed-save");
            return null;
        }
    }
}

