/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0005\u001a;\u0010\u0007\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u0000*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001aO\u0010\r\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u0000*\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00012\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\b\fH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a5\u0010\u0010\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u0000*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018\"\u001a\u0010\u0019\u001a\u00020\u00018\u0006X\u0087D\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u001a\u0010\u001d\u001a\u00020\u00018\u0006X\u0087D\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001e\u0010\u001c\"#\u0010!\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00160\u001f8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"T", "", "Lkotlin/text/Regex;", "regex", "Lkotlin/Function1;", "Lkotlin/text/MatchResult;", "block", "ifMatches", "(Ljava/lang/String;Lkotlin/text/Regex;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Ljava/util/regex/Pattern;", "string", "Ljava/util/regex/Matcher;", "Lkotlin/ExtensionFunctionType;", "useMatch", "(Ljava/util/regex/Pattern;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "suffix", "ifDropLast", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "text", "Lkotlin/time/Duration;", "parseTimePattern", "(Ljava/lang/String;)J", "", "parseShortNumber", "(Ljava/lang/String;)D", "TIME_PATTERN", "Ljava/lang/String;", "getTIME_PATTERN", "()Ljava/lang/String;", "SHORT_NUMBER_FORMAT", "getSHORT_NUMBER_FORMAT", "", "", "siScalars", "Ljava/util/Map;", "getSiScalars", "()Ljava/util/Map;", "Firmament"})
@SourceDebugExtension(value={"SMAP\nregex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 regex.kt\nmoe/nea/firmament/util/RegexKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class RegexKt {
    @Language(value="RegExp")
    @NotNull
    private static final String TIME_PATTERN = "[0-9]+[ms]";
    @Language(value="RegExp")
    @NotNull
    private static final String SHORT_NUMBER_FORMAT = "[0-9]+(?:,[0-9]+)*(?:\\.[0-9]+)?[kKmMbB]?";
    @NotNull
    private static final Map<Character, Double> siScalars;

    @Nullable
    public static final <T> T ifMatches(@NotNull String $this$ifMatches, @NotNull Regex regex, @NotNull Function1<? super MatchResult, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)$this$ifMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$ifMatches = false;
        MatchResult matchResult = regex.matchEntire((CharSequence)$this$ifMatches);
        return (T)(matchResult != null ? block.invoke((Object)matchResult) : null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final <T> T useMatch(@NotNull Pattern $this$useMatch, @Nullable String string, @NotNull Function1<? super Matcher, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$useMatch, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$useMatch = false;
        if (string != null) {
            CharSequence p0 = string;
            boolean bl = false;
            Matcher matcher = $this$useMatch.matcher(p0);
            if (matcher != null) {
                Matcher matcher2;
                Matcher matcher3;
                Matcher p02 = matcher3 = matcher;
                boolean bl2 = false;
                Matcher matcher4 = matcher2 = p02.matches() ? matcher3 : null;
                if (matcher2 != null) {
                    matcher3 = matcher2;
                    object = block.invoke((Object)matcher3);
                    return (T)object;
                }
            }
        }
        object = null;
        return (T)object;
    }

    @Nullable
    public static final <T> T ifDropLast(@NotNull String $this$ifDropLast, @NotNull String suffix, @NotNull Function1<? super String, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)$this$ifDropLast, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (StringsKt.endsWith$default((String)$this$ifDropLast, (String)suffix, (boolean)false, (int)2, null)) {
            return (T)block.invoke((Object)StringsKt.dropLast((String)$this$ifDropLast, (int)suffix.length()));
        }
        return null;
    }

    @NotNull
    public static final String getTIME_PATTERN() {
        return TIME_PATTERN;
    }

    @NotNull
    public static final String getSHORT_NUMBER_FORMAT() {
        return SHORT_NUMBER_FORMAT;
    }

    @NotNull
    public static final Map<Character, Double> getSiScalars() {
        return siScalars;
    }

    public static final long parseTimePattern(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int length = Integer.parseInt(StringsKt.dropLast((String)text, (int)1));
        return switch (StringsKt.last((CharSequence)text)) {
            case 'm' -> DurationKt.toDuration((int)length, (DurationUnit)DurationUnit.MINUTES);
            case 's' -> DurationKt.toDuration((int)length, (DurationUnit)DurationUnit.SECONDS);
            default -> throw new IllegalStateException(("Invalid pattern for time " + text).toString());
        };
    }

    public static final double parseShortNumber(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (StringsKt.startsWith$default((String)string, (String)"-", (boolean)false, (int)2, null)) {
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return -RegexKt.parseShortNumber(string2);
        }
        if (StringsKt.startsWith$default((String)string, (String)"+", (boolean)false, (int)2, null)) {
            String string3 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return RegexKt.parseShortNumber(string3);
        }
        String k = StringsKt.replace$default((String)string, (String)",", (String)"", (boolean)false, (int)4, null);
        char scalar = StringsKt.last((CharSequence)k);
        Double scalarMultiplier = siScalars.get(Character.valueOf(scalar));
        if (scalarMultiplier == null) {
            scalarMultiplier = 1.0;
        } else {
            k = StringsKt.dropLast((String)k, (int)1);
        }
        return Double.parseDouble(k) * scalarMultiplier;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('k'), (Object)1000.0), TuplesKt.to((Object)Character.valueOf('K'), (Object)1000.0), TuplesKt.to((Object)Character.valueOf('m'), (Object)1000000.0), TuplesKt.to((Object)Character.valueOf('M'), (Object)1000000.0), TuplesKt.to((Object)Character.valueOf('b'), (Object)1.0E9), TuplesKt.to((Object)Character.valueOf('B'), (Object)1.0E9)};
        siScalars = MapsKt.mapOf((Pair[])pairArray);
    }
}

