/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.firmament.util.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import moe.nea.firmament.features.debug.DebugLogger;
import moe.nea.firmament.util.collections.InstanceList;
import moe.nea.firmament.util.collections.WeakCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007*\u0001\u001d\b\u0016\u0018\u0000 '*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u0001*\b\b\u0002\u0010\u0004*\u00020\u00012\u00020\u0001:\u0003'()B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ5\u0010\u000f\u001a\u00180\u000eR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00018\u00022\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00028\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J7\u0010\u0017\u001a\u00028\u00022\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00012\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0004\b\u0019\u0010\u000bR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR6\u0010!\u001a$\u0012\u001a\u0012\u00180\u000eR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0000\u0012\u0004\u0012\u00028\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0011\u0010&\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lmoe/nea/firmament/util/collections/WeakCache;", "", "Key", "ExtraKey", "Value", "", "name", "<init>", "(Ljava/lang/String;)V", "", "clearOldReferences", "()V", "key", "extraData", "Lmoe/nea/firmament/util/collections/WeakCache$Ref;", "mkRef", "(Ljava/lang/Object;Ljava/lang/Object;)Lmoe/nea/firmament/util/collections/WeakCache$Ref;", "get", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "value", "put", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Lkotlin/Function2;", "getOrPut", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "clear", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "moe/nea/firmament/util/collections/WeakCache.queue.1", "queue", "Lmoe/nea/firmament/util/collections/WeakCache$queue$1;", "", "map", "Ljava/util/Map;", "", "getSize", "()I", "size", "Companion", "Ref", "CacheFunction", "Firmament"})
@SourceDebugExtension(value={"SMAP\nWeakCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeakCache.kt\nmoe/nea/firmament/util/collections/WeakCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,117:1\n384#2,7:118\n*S KotlinDebug\n*F\n+ 1 WeakCache.kt\nmoe/nea/firmament/util/collections/WeakCache\n*L\n51#1:118,7\n*E\n"})
public class WeakCache<Key, ExtraKey, Value> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final queue.1 queue;
    @NotNull
    private final Map<Ref, Value> map;
    @NotNull
    private static final InstanceList<WeakCache<?, ?, ?>> allInstances = new InstanceList("WeakCaches");
    @NotNull
    private static final DebugLogger logger = new DebugLogger("WeakCache");

    public WeakCache(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.queue = new ReferenceQueue<Key>(){};
        this.map = new LinkedHashMap();
        allInstances.add(this);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getSize() {
        this.clearOldReferences();
        return this.map.size();
    }

    public final void clearOldReferences() {
        int successCount = 0;
        int totalCount = 0;
        while ((Ref)this.queue.poll() != null) {
            Ref reference;
            ++totalCount;
            if (!reference.shouldBeEvicted() || TypeIntrinsics.asMutableMap(this.map).remove(reference) == null) continue;
            ++successCount;
        }
        if (totalCount > 0) {
            logger.log("Cleared " + successCount + "/" + totalCount + " references from queue");
        }
    }

    @NotNull
    public Ref mkRef(@NotNull Key key, @NotNull ExtraKey extraData) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        return new Ref(key, extraData);
    }

    @Nullable
    public final Value get(@NotNull Key key, @NotNull ExtraKey extraData) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        this.clearOldReferences();
        return this.map.get(this.mkRef(key, extraData));
    }

    public final void put(@NotNull Key key, @NotNull ExtraKey extraData, @NotNull Value value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.clearOldReferences();
        this.map.put(this.mkRef(key, extraData), value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Value getOrPut(@NotNull Key key, @NotNull ExtraKey extraData, @NotNull Function2<? super Key, ? super ExtraKey, ? extends Value> value) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.clearOldReferences();
        Map<Ref, Value> map = this.map;
        Ref key$iv = this.mkRef(key, extraData);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Object answer$iv = value.invoke(key, extraData);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Value)object;
    }

    public final void clear() {
        this.map.clear();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0002\u0006\u0007R \u0010\u0005\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00028&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\b"}, d2={"Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction;", "", "Lmoe/nea/firmament/util/collections/WeakCache;", "getCache", "()Lmoe/nea/firmament/util/collections/WeakCache;", "cache", "NoExtraData", "WithExtraData", "Firmament"})
    public static interface CacheFunction {
        @NotNull
        public WeakCache<?, ?, ?> getCache();

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u0000*\b\b\u0003\u0010\u0002*\u00020\u0001*\b\b\u0004\u0010\u0003*\u00020\u00012\u00020\u00042\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u0005B5\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00040\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\r\u001a\u00028\u00042\u0006\u0010\f\u001a\u00028\u0003H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\"\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00040\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012JN\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u00002\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00040\u00062\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR,\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00040\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010\u0010R#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u00058\u0006\u00a2\u0006\f\n\u0004\b\t\u0010!\u001a\u0004\b\"\u0010\u0012\u00a8\u0006#"}, d2={"Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction$NoExtraData;", "", "Key", "Value", "Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction;", "Lkotlin/Function1;", "Lmoe/nea/firmament/util/collections/WeakCache;", "", "cache", "wrapped", "<init>", "(Lmoe/nea/firmament/util/collections/WeakCache;Lkotlin/jvm/functions/Function1;)V", "p1", "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;", "component1", "()Lmoe/nea/firmament/util/collections/WeakCache;", "component2", "()Lkotlin/jvm/functions/Function1;", "copy", "(Lmoe/nea/firmament/util/collections/WeakCache;Lkotlin/jvm/functions/Function1;)Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction$NoExtraData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lmoe/nea/firmament/util/collections/WeakCache;", "getCache", "Lkotlin/jvm/functions/Function1;", "getWrapped", "Firmament"})
        public static final class NoExtraData<Key, Value>
        implements CacheFunction,
        Function1<Key, Value> {
            @NotNull
            private final WeakCache<Key, Unit, Value> cache;
            @NotNull
            private final Function1<Key, Value> wrapped;

            public NoExtraData(@NotNull WeakCache<Key, Unit, Value> cache2, @NotNull Function1<? super Key, ? extends Value> wrapped) {
                Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                Intrinsics.checkNotNullParameter(wrapped, (String)"wrapped");
                this.cache = cache2;
                this.wrapped = wrapped;
            }

            @NotNull
            public WeakCache<Key, Unit, Value> getCache() {
                return this.cache;
            }

            @NotNull
            public final Function1<Key, Value> getWrapped() {
                return this.wrapped;
            }

            @NotNull
            public Value invoke(@NotNull Key p1) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                return this.getCache().getOrPut(p1, Unit.INSTANCE, (arg_0, arg_1) -> NoExtraData.invoke$lambda$0(this, arg_0, arg_1));
            }

            @NotNull
            public final WeakCache<Key, Unit, Value> component1() {
                return this.cache;
            }

            @NotNull
            public final Function1<Key, Value> component2() {
                return this.wrapped;
            }

            @NotNull
            public final NoExtraData<Key, Value> copy(@NotNull WeakCache<Key, Unit, Value> cache2, @NotNull Function1<? super Key, ? extends Value> wrapped) {
                Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                Intrinsics.checkNotNullParameter(wrapped, (String)"wrapped");
                return new NoExtraData<Key, Value>(cache2, wrapped);
            }

            public static /* synthetic */ NoExtraData copy$default(NoExtraData noExtraData, WeakCache weakCache2, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    weakCache2 = noExtraData.cache;
                }
                if ((n & 2) != 0) {
                    function1 = noExtraData.wrapped;
                }
                return noExtraData.copy(weakCache2, function1);
            }

            @NotNull
            public String toString() {
                return "NoExtraData(cache=" + this.cache + ", wrapped=" + this.wrapped + ")";
            }

            public int hashCode() {
                int result = this.cache.hashCode();
                result = result * 31 + this.wrapped.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NoExtraData)) {
                    return false;
                }
                NoExtraData noExtraData = (NoExtraData)other;
                if (!Intrinsics.areEqual(this.cache, noExtraData.cache)) {
                    return false;
                }
                return Intrinsics.areEqual(this.wrapped, noExtraData.wrapped);
            }

            private static final Object invoke$lambda$0(NoExtraData this$0, Object a, Unit unit) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
                return this$0.wrapped.invoke(a);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u0000*\b\b\u0003\u0010\u0002*\u00020\u0001*\b\b\u0004\u0010\u0003*\u00020\u0001*\b\b\u0005\u0010\u0004*\u00020\u00012\u00020\u00052\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0006B;\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u000e\u001a\u00028\u00052\u0006\u0010\f\u001a\u00028\u00032\u0006\u0010\r\u001a\u00028\u0004H\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\"\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\"\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013JZ\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00072\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001e\u001a\u00020\u001dH\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR,\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b!\u0010\u0011R)\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\"\u001a\u0004\b#\u0010\u0013\u00a8\u0006$"}, d2={"Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction$WithExtraData;", "", "Key", "ExtraKey", "Value", "Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction;", "Lkotlin/Function2;", "Lmoe/nea/firmament/util/collections/WeakCache;", "cache", "wrapped", "<init>", "(Lmoe/nea/firmament/util/collections/WeakCache;Lkotlin/jvm/functions/Function2;)V", "p1", "p2", "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "component1", "()Lmoe/nea/firmament/util/collections/WeakCache;", "component2", "()Lkotlin/jvm/functions/Function2;", "copy", "(Lmoe/nea/firmament/util/collections/WeakCache;Lkotlin/jvm/functions/Function2;)Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction$WithExtraData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lmoe/nea/firmament/util/collections/WeakCache;", "getCache", "Lkotlin/jvm/functions/Function2;", "getWrapped", "Firmament"})
        public static final class WithExtraData<Key, ExtraKey, Value>
        implements CacheFunction,
        Function2<Key, ExtraKey, Value> {
            @NotNull
            private final WeakCache<Key, ExtraKey, Value> cache;
            @NotNull
            private final Function2<Key, ExtraKey, Value> wrapped;

            public WithExtraData(@NotNull WeakCache<Key, ExtraKey, Value> cache2, @NotNull Function2<? super Key, ? super ExtraKey, ? extends Value> wrapped) {
                Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                Intrinsics.checkNotNullParameter(wrapped, (String)"wrapped");
                this.cache = cache2;
                this.wrapped = wrapped;
            }

            @NotNull
            public WeakCache<Key, ExtraKey, Value> getCache() {
                return this.cache;
            }

            @NotNull
            public final Function2<Key, ExtraKey, Value> getWrapped() {
                return this.wrapped;
            }

            @NotNull
            public Value invoke(@NotNull Key p1, @NotNull ExtraKey p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                return this.getCache().getOrPut(p1, p2, this.wrapped);
            }

            @NotNull
            public final WeakCache<Key, ExtraKey, Value> component1() {
                return this.cache;
            }

            @NotNull
            public final Function2<Key, ExtraKey, Value> component2() {
                return this.wrapped;
            }

            @NotNull
            public final WithExtraData<Key, ExtraKey, Value> copy(@NotNull WeakCache<Key, ExtraKey, Value> cache2, @NotNull Function2<? super Key, ? super ExtraKey, ? extends Value> wrapped) {
                Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                Intrinsics.checkNotNullParameter(wrapped, (String)"wrapped");
                return new WithExtraData<Key, ExtraKey, Value>(cache2, wrapped);
            }

            public static /* synthetic */ WithExtraData copy$default(WithExtraData withExtraData, WeakCache weakCache2, Function2 function2, int n, Object object) {
                if ((n & 1) != 0) {
                    weakCache2 = withExtraData.cache;
                }
                if ((n & 2) != 0) {
                    function2 = withExtraData.wrapped;
                }
                return withExtraData.copy(weakCache2, function2);
            }

            @NotNull
            public String toString() {
                return "WithExtraData(cache=" + this.cache + ", wrapped=" + this.wrapped + ")";
            }

            public int hashCode() {
                int result = this.cache.hashCode();
                result = result * 31 + this.wrapped.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WithExtraData)) {
                    return false;
                }
                WithExtraData withExtraData = (WithExtraData)other;
                if (!Intrinsics.areEqual(this.cache, withExtraData.cache)) {
                    return false;
                }
                return Intrinsics.areEqual(this.wrapped, withExtraData.wrapped);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JI\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\n\"\b\b\u0003\u0010\u0004*\u00020\u0001\"\b\b\u0004\u0010\u0005*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\b\u00a2\u0006\u0004\b\u000b\u0010\fJ_\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000e\"\b\b\u0003\u0010\u0004*\u00020\u0001\"\b\b\u0004\u0010\r*\u00020\u0001\"\b\b\u0005\u0010\u0005*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J_\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0011\"\b\b\u0003\u0010\u0004*\u00020\u0001\"\b\b\u0004\u0010\r*\u00020\u0001\"\b\b\u0005\u0010\u0005*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000e\u00a2\u0006\u0004\b\u000b\u0010\u0012R)\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00140\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lmoe/nea/firmament/util/collections/WeakCache$Companion;", "", "<init>", "()V", "Key", "Value", "", "name", "Lkotlin/Function1;", "function", "Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction$NoExtraData;", "memoize", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction$NoExtraData;", "ExtraKey", "Lkotlin/Function2;", "dontMemoize", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Lkotlin/jvm/functions/Function2;", "Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction$WithExtraData;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Lmoe/nea/firmament/util/collections/WeakCache$CacheFunction$WithExtraData;", "Lmoe/nea/firmament/util/collections/InstanceList;", "Lmoe/nea/firmament/util/collections/WeakCache;", "allInstances", "Lmoe/nea/firmament/util/collections/InstanceList;", "getAllInstances", "()Lmoe/nea/firmament/util/collections/InstanceList;", "Lmoe/nea/firmament/features/debug/DebugLogger;", "logger", "Lmoe/nea/firmament/features/debug/DebugLogger;", "Firmament"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InstanceList<WeakCache<?, ?, ?>> getAllInstances() {
            return allInstances;
        }

        @NotNull
        public final <Key, Value> CacheFunction.NoExtraData<Key, Value> memoize(@NotNull String name, @NotNull Function1<? super Key, ? extends Value> function) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(function, (String)"function");
            return new CacheFunction.NoExtraData<Key, Value>(new WeakCache(name), function);
        }

        @NotNull
        public final <Key, ExtraKey, Value> Function2<Key, ExtraKey, Value> dontMemoize(@NotNull String name, @NotNull Function2<? super Key, ? super ExtraKey, ? extends Value> function) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(function, (String)"function");
            return function;
        }

        @NotNull
        public final <Key, ExtraKey, Value> CacheFunction.WithExtraData<Key, ExtraKey, Value> memoize(@NotNull String name, @NotNull Function2<? super Key, ? super ExtraKey, ? extends Value> function) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(function, (String)"function");
            return new CacheFunction.WithExtraData<Key, ExtraKey, Value>(new WeakCache(name), function);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0096\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u000b\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u0013\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lmoe/nea/firmament/util/collections/WeakCache$Ref;", "Ljava/lang/ref/WeakReference;", "weakInstance", "extraData", "<init>", "(Lmoe/nea/firmament/util/collections/WeakCache;Ljava/lang/Object;Ljava/lang/Object;)V", "", "shouldBeEvicted", "()Z", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/Object;", "getExtraData", "()Ljava/lang/Object;", "I", "getHashCode", "Firmament"})
    public class Ref
    extends WeakReference<Key> {
        @NotNull
        private final ExtraKey extraData;
        private final int hashCode;

        public Ref(@NotNull Key weakInstance, ExtraKey extraData) {
            Intrinsics.checkNotNullParameter(weakInstance, (String)"weakInstance");
            Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
            super(weakInstance, WeakCache.this.queue);
            this.extraData = extraData;
            this.hashCode = System.identityHashCode(weakInstance) * 31 + this.extraData.hashCode();
        }

        @NotNull
        public final ExtraKey getExtraData() {
            return this.extraData;
        }

        public boolean shouldBeEvicted() {
            return true;
        }

        public final int getHashCode() {
            return this.hashCode;
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Ref)) {
                return false;
            }
            return ((Ref)other).hashCode == this.hashCode && ((Ref)other).get() == this.get() && Intrinsics.areEqual(((Ref)other).extraData, this.extraData);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

