/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.custom_blocks;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.PrehistoricPlantInfo;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.CustomEntityBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.CultureVatBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.monster.Failuresaurus;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMobType;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CultureVatBlock
extends CustomEntityBlock {
    public static final EnumProperty<EmbryoType> EMBRYO = EnumProperty.m_61587_((String)"embryo", EmbryoType.class);

    public CultureVatBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_(EMBRYO, (Comparable)((Object)EmbryoType.GENERIC)));
    }

    public void onFailedCultivation(Level level, BlockPos pos) {
        List nearby = level.m_45976_(Player.class, new AABB(pos.m_7918_(-50, -50, -50), pos.m_7918_(50, 50, 50)));
        for (Player player : nearby) {
            player.m_5661_((Component)Component.m_237115_((String)"culture_vat.outBreak"), false);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!level.f_46443_ && blockEntity instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
            if (blockEntity.m_58900_().m_61143_(EMBRYO) == EmbryoType.PLANT) {
                BlockState blockState = PrehistoricPlantInfo.MUTANT_PLANT.getPlantBlock().m_49966_();
                level.m_46597_(pos, blockState);
                if (level.m_8055_(pos.m_7494_()).m_247087_()) {
                    level.m_46597_(pos.m_7494_(), (BlockState)blockState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER));
                }
            } else if (blockEntity.m_58900_().m_61143_(EMBRYO) == EmbryoType.TREE) {
                level.m_46597_(pos, ((Block)ModBlocks.MUTANT_TREE_SAPLING.get()).m_49966_());
            } else {
                LivingEntity entity;
                int random = level.f_46441_.m_188503_(100);
                if (random < 5) {
                    entity = (LivingEntity)EntityType.f_20558_.m_20615_(level);
                } else if (random < 10) {
                    entity = (LivingEntity)EntityType.f_20511_.m_20615_(level);
                } else if (random < 15) {
                    entity = (LivingEntity)EntityType.f_20502_.m_20615_(level);
                } else if (random < 20) {
                    entity = (LivingEntity)EntityType.f_20504_.m_20615_(level);
                } else {
                    entity = (LivingEntity)((EntityType)ModEntities.FAILURESAURUS.get()).m_20615_(level);
                    Item dnaItem = container.m_8020_(0).m_41720_();
                    PrehistoricEntityInfo inputEntity = Arrays.stream(PrehistoricEntityInfo.values()).filter(info -> info.dnaItem == dnaItem).findFirst().orElse(null);
                    if (inputEntity != null) {
                        if (inputEntity == PrehistoricEntityInfo.DODO) {
                            ((Failuresaurus)entity).setVariant(Failuresaurus.Variant.DODO.name());
                        } else if (inputEntity.mobType == PrehistoricMobType.BIRD) {
                            ((Failuresaurus)entity).setVariant(Failuresaurus.Variant.FLYING.name());
                        } else if (inputEntity.mobType == PrehistoricMobType.FISH || inputEntity.mobType == PrehistoricMobType.DINOSAUR_FISH) {
                            ((Failuresaurus)entity).setVariant(Failuresaurus.Variant.FISH.name());
                        } else if (EntityDataLoader.INSTANCE.getData(inputEntity.resourceName).diet().canEat(FoodType.MEAT)) {
                            ((Failuresaurus)entity).setVariant(Failuresaurus.Variant.THEROPOD.name());
                        } else {
                            ((Failuresaurus)entity).setVariant(Failuresaurus.Variant.SAUROPOD.name());
                        }
                    }
                }
                if (!level.m_6042_().f_63857_()) {
                    level.m_46597_(pos, Blocks.f_49990_.m_49966_());
                    level.m_46586_(pos, Blocks.f_49990_, pos);
                } else {
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                level.m_7967_((Entity)entity);
                level.m_46961_(pos, false);
            }
            this.dropIron(level, pos);
            this.dropInventory(level, pos);
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46747_(pos);
        }
    }

    private void dropIron(Level level, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42416_, 1 + level.f_46441_.m_188503_(2));
        float posX = (float)pos.m_123341_() + level.f_46441_.m_188501_() * 0.8f + 0.1f;
        float posY = (float)pos.m_123342_() + level.f_46441_.m_188501_() * 0.8f + 0.1f;
        float posZ = (float)pos.m_123343_() + level.f_46441_.m_188501_() * 0.8f + 0.1f;
        ItemEntity item = new ItemEntity(level, (double)posX, (double)posY, (double)posZ, stack);
        item.m_20334_(level.f_46441_.m_188583_() * (double)0.05f, level.f_46441_.m_188583_() * (double)0.05f + (double)0.2f, level.f_46441_.m_188583_() * (double)0.05f);
        level.m_7967_((Entity)item);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : CultureVatBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.CULTURE_VAT.get()), CultureVatBlockEntity::serverTick);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EMBRYO});
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CultureVatBlockEntity(pos, state);
    }

    public static enum EmbryoType implements StringRepresentable
    {
        GENERIC("generic"),
        PLANT("plant"),
        TREE("tree"),
        LIMBLESS("limbless"),
        INSECT("insect"),
        NONE("none");

        private final String name;

        private EmbryoType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

