/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.custom_blocks.SifterBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.MachineContainerBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.inventory.SifterMenu;
import com.github.teamfossilsarcheology.fossil.recipe.ModRecipes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SifterBlockEntity
extends MachineContainerBlockEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1, 2, 3, 4, 5};
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return SifterBlockEntity.this.cookingProgress;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    SifterBlockEntity.this.cookingProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);

    public SifterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SIFTER.get(), blockPos, blockState);
    }

    public static BlockEntity get(BlockPos pos, BlockState state) {
        return new SifterBlockEntity(pos, state);
    }

    @Override
    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SifterBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        boolean wasProcessing = this.cookingProgress > 0;
        boolean dirty = false;
        if (this.canProcess()) {
            ++this.cookingProgress;
            if (this.cookingProgress >= 200) {
                this.cookingProgress = 0;
                this.createItem();
                dirty = true;
            }
        } else {
            this.cookingProgress = Mth.m_14045_((int)(this.cookingProgress - 2), (int)0, (int)200);
        }
        if (wasProcessing != this.cookingProgress > 0) {
            dirty = true;
            state = (BlockState)state.m_61124_((Property)SifterBlock.ACTIVE, (Comparable)Boolean.valueOf(this.cookingProgress > 0));
            level.m_7731_(pos, state, 3);
        }
        if (dirty) {
            SifterBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean isSiftable(ItemStack stack) {
        return ModRecipes.getSifterRecipeForItem((Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_) != null;
    }

    @Override
    protected boolean canProcess() {
        ItemStack itemStack = (ItemStack)this.items.get(0);
        if (!itemStack.m_41619_()) {
            if (this.isSiftable(itemStack)) {
                for (int outputIndex = 5; outputIndex > 0; --outputIndex) {
                    if (!((ItemStack)this.items.get(outputIndex)).m_41619_()) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    protected void createItem() {
        if (this.canProcess()) {
            ItemStack stackInSlot;
            int slot;
            ItemStack result = ModRecipes.getSifterRecipeForItem((Container)new SimpleContainer(new ItemStack[]{(ItemStack)this.items.get(0)}), this.f_58857_).m_5874_(this, this.f_58857_.m_9598_()).m_41777_();
            for (slot = 1; slot <= 5; ++slot) {
                stackInSlot = (ItemStack)this.items.get(slot);
                if (!ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)result) || stackInSlot.m_41613_() + result.m_41613_() >= 64) continue;
                stackInSlot.m_41769_(result.m_41613_());
                if (((ItemStack)this.items.get(0)).m_41613_() > 1) {
                    ((ItemStack)this.items.get(0)).m_41774_(1);
                } else {
                    this.items.set(0, (Object)ItemStack.f_41583_);
                }
                return;
            }
            for (slot = 1; slot <= 5; ++slot) {
                stackInSlot = (ItemStack)this.items.get(slot);
                if (!stackInSlot.m_41619_()) continue;
                this.items.set(slot, (Object)result);
                if (((ItemStack)this.items.get(0)).m_41613_() > 1) {
                    ((ItemStack)this.items.get(0)).m_41774_(1);
                } else {
                    this.items.set(0, (Object)ItemStack.f_41583_);
                }
                return;
            }
        }
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.fossil.sifter");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, @NotNull Inventory inventory) {
        return new SifterMenu(containerId, inventory, this, this.dataAccess);
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        return slot == 0 && this.isSiftable(stack);
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_UP;
    }

    public boolean m_7155_(int slot, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(slot, itemStack);
    }

    public boolean m_7157_(int slot, @NotNull ItemStack stack, @NotNull Direction direction) {
        return direction != Direction.UP && slot >= SLOTS_FOR_DOWN[0];
    }
}

