/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.client.DinopediaBioLoader;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.Quagga;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFish;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricShearable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.MoodSystem;
import com.github.teamfossilsarcheology.fossil.food.FoodMappingsManager;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DinopediaScreen
extends Screen {
    private static final ResourceLocation DINOPEDIA_BACKGROUND = FossilMod.location("textures/gui/dinopedia.png");
    private static final ResourceLocation MOODS = FossilMod.location("textures/gui/dinopedia_mood.png");
    private static final LoadingCache<UUID, Component> USERNAMES = CacheBuilder.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<UUID, Component>(){

        @NotNull
        public Component load(@NotNull UUID key) {
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(key);
            if (player != null) {
                return player.m_7755_();
            }
            GameProfile gameProfile = new GameProfile(key, null);
            gameProfile = Minecraft.m_91087_().m_91108_().fillProfileProperties(gameProfile, true);
            if (gameProfile.isComplete()) {
                return Component.m_237113_((String)gameProfile.getName());
            }
            return Component.m_237113_((String)"Invalid User");
        }
    });
    private static final Component STUNTED_GROWTH = Component.m_237115_((String)"pedia.fossil.condition.stunted");
    private static final Component SHEARED = Component.m_237115_((String)"pedia.fossil.condition.sheared");
    private static final Component NOT_SHEARED = Component.m_237115_((String)"pedia.fossil.condition.not_sheared");
    private static final int MOOD_FACE_WIDTH = 16;
    private static final int MOOD_FACE_HEIGHT = 15;
    private static final int MOOD_BAR_WIDTH = 206;
    private static final int MOOD_BAR_HEIGHT = 9;
    private static final int PAGE_1 = 0;
    private static final int PAGE_2 = 1;
    private static final int MAX_PAGES = 2;
    private final LivingEntity entity;
    private List<String> currentBio;
    private final List<Component> toolTipList = new ArrayList<Component>();
    private final int xSize = 390;
    private final int ySize = 245;
    private int leftPos;
    private int topPos;
    private DinopediaPageButton backButton;
    private DinopediaPageButton forwardButton;
    private int currentPage;

    public DinopediaScreen(LivingEntity entity) {
        super((Component)Component.m_237113_((String)""));
        this.entity = entity;
    }

    public static void renderEntityInDinopedia(int posX, int posY, LivingEntity entity) {
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_252880_((float)posX, (float)posY, 1050.0f);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack poseStack2 = new PoseStack();
        poseStack2.m_85837_(0.0, -10.0, 1000.0);
        int scale = 25;
        if (entity instanceof Prehistoric) {
            scale = (int)(35.0f / entity.m_20205_());
        } else if (entity instanceof DinosaurEgg) {
            scale = 110;
        } else if (entity instanceof Quagga) {
            scale = 35;
        }
        poseStack2.m_85841_((float)scale, (float)scale, (float)scale);
        poseStack2.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        entityRenderDispatcher.m_114468_(false);
        poseStack2.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> {
            float yRotO = entity.f_20883_;
            entity.f_20883_ = 110.0f;
            entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack2, (MultiBufferSource)bufferSource, 0xF000F0);
            entity.f_20883_ = yRotO;
        });
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 390) / 2;
        this.topPos = (this.f_96544_ - 245) / 2;
        this.backButton = (DinopediaPageButton)this.m_142416_((GuiEventListener)new DinopediaPageButton(this.leftPos + 10, this.topPos + 245 - 45, 200, 100, false, button -> this.pageBack()));
        if (this.entity instanceof Prehistoric || this.entity instanceof Quagga || this.entity instanceof PrehistoricFish) {
            this.forwardButton = (DinopediaPageButton)this.m_142416_((GuiEventListener)new DinopediaPageButton(this.leftPos + 390 - 43, this.topPos + 245 - 45, 200, 100, true, button -> this.pageForward()));
        }
        this.updateButtonVisibility();
    }

    protected void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentPage < this.getMaxPages() - 1) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        if (this.forwardButton != null) {
            this.forwardButton.f_93624_ = this.currentPage < this.getMaxPages() - 1;
        }
        this.backButton.f_93624_ = this.currentPage > 0;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.renderBackgroundLayer(guiGraphics, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderForegroundLayer(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.toolTipList.isEmpty()) {
            guiGraphics.m_280666_(this.f_96547_, this.toolTipList, mouseX, mouseY);
            this.toolTipList.clear();
        }
    }

    private void renderBackgroundLayer(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280163_(DINOPEDIA_BACKGROUND, this.leftPos, this.topPos, 0.0f, 0.0f, 390, 245, 390, 390);
        if (this.currentPage == 0) {
            DinopediaScreen.renderEntityInDinopedia(this.leftPos + 100, this.topPos + 80, this.entity);
        }
    }

    private void renderForegroundLayer(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.currentPage == 0) {
            this.renderFirstPage(guiGraphics, mouseX, mouseY);
        } else if (this.currentPage >= 1) {
            if (this.currentBio == null) {
                this.currentBio = this.loadBio(this.entity);
                this.updateButtonVisibility();
            }
            if (!this.currentBio.isEmpty()) {
                this.renderPrehistoricBio(guiGraphics);
            }
        }
    }

    private int getMaxPages() {
        if (this.currentBio == null) {
            return 2;
        }
        return 2 + this.currentBio.size() / 42;
    }

    private int getScaledX(boolean left, int width, float scale) {
        return (int)(((float)this.leftPos + (left ? 0.0f : 195.0f) + (195.0f - (float)width * scale) / 2.0f) / scale);
    }

    private static float roundToHalf(double value) {
        return (float)Math.round(value * 2.0) / 2.0f;
    }

    private void renderFirstPage(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Animal animal;
        float embryoProgress;
        int col = 10321511;
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Animal && (embryoProgress = (float)ModCapabilities.getEmbryoProgress(animal = (Animal)livingEntity)) > 0.0f) {
            float quot = DinopediaScreen.roundToHalf(embryoProgress / (float)(FossilConfig.getInt("pregnancyDuration") + 1) * 100.0f);
            MutableComponent progress = Component.m_237110_((String)"pedia.fossil.pregnantTime", (Object[])new Object[]{Float.valueOf(quot)});
            guiGraphics.m_280614_(this.f_96547_, (Component)progress, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)progress), 1.0f), this.topPos + 135, col, false);
            guiGraphics.m_280168_().m_85836_();
            float scale = 1.5f;
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            MutableComponent name = Component.m_237110_((String)"pedia.fossil.pregnant", (Object[])new Object[]{this.entity.m_6095_().m_20676_()});
            guiGraphics.m_280614_(this.f_96547_, (Component)name, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)name), scale), (int)((float)(this.topPos + 85) / scale), 4337700, false);
            guiGraphics.m_280168_().m_85849_();
        }
        this.renderFirstPageRight(guiGraphics, mouseX, mouseY);
        LivingEntity quot = this.entity;
        if (quot instanceof Prehistoric) {
            Prehistoric dino = (Prehistoric)quot;
            guiGraphics.m_280168_().m_85836_();
            float scale = 1.5f;
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            name = this.entity.m_6095_().m_20676_();
            guiGraphics.m_280614_(this.f_96547_, name, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)name), scale), (int)((float)(this.topPos + 85) / scale), 4337700, false);
            guiGraphics.m_280168_().m_85849_();
            int x = this.leftPos + 30;
            int y = this.topPos + 85;
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"pedia.fossil.age", (Object[])new Object[]{dino.getAgeInDays()}), x, y + 20, col, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"pedia.fossil.health", (Object[])new Object[]{this.entity.m_21223_() + "/" + this.entity.m_21233_()}), x, y + 30, col, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"pedia.fossil.hunger", (Object[])new Object[]{dino.getHunger() + "/" + dino.getMaxHunger()}), x, y + 40, col, false);
            Component dietText = dino.data().diet().getName();
            this.renderHoverInfo(guiGraphics, x, y + 50, mouseX, mouseY, dietText, dino.data().diet().getDescription());
            Component tempText = dino.aiResponseType().getName();
            this.renderHoverInfo(guiGraphics, x, y + 60, mouseX, mouseY, tempText, dino.aiResponseType().getDescription());
            guiGraphics.m_280614_(this.f_96547_, dino.getGender().getName(), x, y + 70, col, false);
            if (dino.m_21805_() == null) {
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"pedia.fossil.untamed"), x, y + 80, col, false);
            } else {
                try {
                    guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"pedia.fossil.owner", (Object[])new Object[]{USERNAMES.get((Object)dino.m_21805_())}), x, y + 80, col, false);
                }
                catch (ExecutionException e) {
                    guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"pedia.fossil.owner", (Object[])new Object[]{"Invalid User"}), x, y + 80, col, false);
                }
            }
            OrderType order = dino.getCurrentOrder();
            this.renderHoverInfo(guiGraphics, x, y + 90, mouseX, mouseY, order.getName(), order.getDescription());
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"pedia.fossil.order.item", (Object[])new Object[]{Component.m_237115_((String)dino.getOrderItem().m_5524_())}), x, y + 100, col, false);
            PrehistoricEntityInfoAI.Activity activity = dino.aiActivityType();
            this.renderHoverInfo(guiGraphics, x, y + 110, mouseX, mouseY, activity.getName(), activity.getDescription());
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"pedia.fossil.population", (Object[])new Object[]{dino.data().maxPopulation()}), x, y + 120, col, false);
        } else {
            LivingEntity scale = this.entity;
            if (scale instanceof DinosaurEgg) {
                DinosaurEgg egg = (DinosaurEgg)scale;
                guiGraphics.m_280168_().m_85836_();
                float scale2 = 1.5f;
                guiGraphics.m_280168_().m_85841_(scale2, scale2, scale2);
                name = Component.m_237110_((String)"pedia.fossil.egg", (Object[])new Object[]{egg.getPrehistoricEntityInfo().displayName.get()});
                guiGraphics.m_280614_(this.f_96547_, name, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)name), scale2), (int)((float)(this.topPos + 85) / scale2), 4337700, false);
                guiGraphics.m_280168_().m_85849_();
                int time = Mth.m_14143_((float)((float)egg.getHatchingTime() / (float)egg.getTotalHatchingTime() * 100.0f));
                MutableComponent progress = Component.m_237110_((String)"pedia.fossil.egg.time", (Object[])new Object[]{Math.max(time, 0)});
                guiGraphics.m_280614_(this.f_96547_, (Component)progress, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)progress), 1.0f), this.topPos + 120, 10321511, false);
                MutableComponent status = egg.m_20069_() ? Component.m_237115_((String)"pedia.fossil.egg.status.wet").m_130938_(style -> style.m_131140_(ChatFormatting.AQUA)) : (egg.isTooCold() ? Component.m_237115_((String)"pedia.fossil.egg.status.cold").m_130938_(style -> style.m_131140_(ChatFormatting.BLUE)) : Component.m_237115_((String)"pedia.fossil.egg.status.warm").m_130938_(style -> style.m_131140_(ChatFormatting.GOLD)));
                status = Component.m_237110_((String)"pedia.fossil.egg.status", (Object[])new Object[]{status});
                guiGraphics.m_280614_(this.f_96547_, (Component)status, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)status), 1.0f), this.topPos + 140, 10321511, false);
            } else if (this.entity instanceof PrehistoricFish || this.entity instanceof Quagga) {
                guiGraphics.m_280168_().m_85836_();
                float scale3 = 1.5f;
                guiGraphics.m_280168_().m_85841_(scale3, scale3, scale3);
                name = this.entity.m_6095_().m_20676_();
                guiGraphics.m_280614_(this.f_96547_, name, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)name), scale3), (int)((float)(this.topPos + 85) / scale3), 4337700, false);
                guiGraphics.m_280168_().m_85849_();
            }
        }
    }

    private void renderHoverInfo(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Component text, Component hoverText) {
        guiGraphics.m_280614_(this.f_96547_, text, x, y, 10321511, false);
        if (mouseX >= x && mouseY >= y && mouseX < x + this.f_96547_.m_92852_((FormattedText)text)) {
            Objects.requireNonNull(this.f_96547_);
            if (mouseY < y + 9) {
                this.toolTipList.add(hoverText);
            }
        }
    }

    private void renderFirstPageRight(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Prehistoric) {
            Prehistoric dino = (Prehistoric)livingEntity;
            guiGraphics.m_280168_().m_85836_();
            float scale = 1.75f;
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            int x = this.getScaledX(false, 16, scale);
            int y = (int)((float)(this.topPos + 16) / scale);
            MoodSystem moodSystem = dino.moodSystem;
            guiGraphics.m_280218_(MOODS, x, y, moodSystem.getMoodFace().uOffset, 10, 16, 15);
            guiGraphics.m_280168_().m_85849_();
            x = (int)((float)x * scale);
            y = (int)((float)y * scale);
            if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && (float)mouseX < (float)x + 16.0f * scale && (float)mouseY < (float)y + 15.0f * scale) {
                this.toolTipList.add(moodSystem.getMoodFace().getName());
                this.toolTipList.add(moodSystem.getMoodFace().getDescription());
            }
            guiGraphics.m_280168_().m_85836_();
            scale = 0.75f;
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            x = this.getScaledX(false, 206, scale);
            y = (int)((float)(this.topPos + 49) / scale);
            guiGraphics.m_280218_(MOODS, x, y, 0, 0, 206, 9);
            guiGraphics.m_280168_().m_85849_();
            x = (int)((float)x * scale);
            y = (int)((float)y * scale);
            if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && (float)mouseX < (float)x + 206.0f * scale && (float)mouseY < (float)y + 9.0f * scale) {
                MutableComponent mood = Component.m_237113_((String)String.valueOf(moodSystem.getMood())).m_130938_(style -> style.m_131140_(moodSystem.getMoodFace().color));
                this.toolTipList.add((Component)Component.m_237110_((String)"pedia.fossil.mood_status", (Object[])new Object[]{mood}));
            }
            guiGraphics.m_280168_().m_85836_();
            x = this.getScaledX(false, 4, 1.0f);
            y = this.topPos + 9 + 38;
            guiGraphics.m_280218_(MOODS, x - moodSystem.getMoodPosition(), y, 0, 26, 4, 10);
            guiGraphics.m_280168_().m_85849_();
            TreeSet<Item> foodMap = FoodMappingsManager.INSTANCE.getItemCache().get(dino.data().diet());
            List keys = foodMap.stream().limit(64L).toList();
            int itemCount = 0;
            int renderSize = 16;
            for (ItemLike itemLike : keys) {
                x = this.leftPos + 195 + (195 - renderSize * 8) / 2 + renderSize * (itemCount % 8);
                y = this.topPos + 65 + renderSize * (itemCount / 8);
                ++itemCount;
                ItemStack itemStack = new ItemStack(itemLike);
                guiGraphics.m_280480_(itemStack, x, y);
                if (!this.toolTipList.isEmpty() || mouseX < x || mouseY < y || mouseX >= x + renderSize || mouseY >= y + renderSize) continue;
                this.toolTipList.addAll(DinopediaScreen.m_280152_((Minecraft)this.f_96541_, (ItemStack)itemStack));
            }
            x = this.leftPos + 4 + 195;
            y = this.topPos + 70 + renderSize * (itemCount / 8);
            if (dino.isAgingDisabled()) {
                guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42675_), x += 16, y);
                if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                    this.toolTipList.add(STUNTED_GROWTH);
                }
            }
            if (dino instanceof PrehistoricShearable) {
                PrehistoricShearable shearable = (PrehistoricShearable)((Object)dino);
                guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42574_), x += 16, y);
                if (shearable.isSheared()) {
                    guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42127_), x, y);
                }
                if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                    this.toolTipList.add(shearable.isSheared() ? SHEARED : NOT_SHEARED);
                }
            }
            if (Minecraft.m_91087_().f_91074_.m_7500_()) {
                CompoundTag tag = dino.getDebugTag();
                if (dino.m_21525_() || tag.m_128471_("disableGoalAI") || tag.m_128471_("disableMoveAI") || tag.m_128471_("disableLookAI")) {
                    guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42751_), x += 16, y);
                    if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                        this.toolTipList.add((Component)Component.m_237113_((String)String.format("Disabled AI: %b, Goal: %b, Move: %b, Look: %b", dino.m_21525_(), tag.m_128471_("disableGoalAI"), tag.m_128471_("disableMoveAI"), tag.m_128471_("disableLookAI"))));
                    }
                }
                if (!dino.getVariantId().isBlank()) {
                    guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42497_), x += 16, y);
                    if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                        this.toolTipList.add((Component)Component.m_237113_((String)("Variant: " + dino.getVariantId())));
                    }
                }
            }
        }
    }

    private List<String> loadBio(LivingEntity entity) {
        String name;
        if (entity instanceof Prehistoric) {
            name = ((Prehistoric)entity).info().resourceName;
        } else if (entity instanceof PrehistoricFish) {
            name = ((PrehistoricFish)entity).info().resourceName;
        } else if (entity instanceof Quagga) {
            name = "quagga";
        } else {
            return List.of();
        }
        String bio = DinopediaBioLoader.INSTANCE.getDinopediaBio(name);
        StringSplitter stringSplitter = this.f_96547_.m_92865_();
        ArrayList<String> list = new ArrayList<String>();
        stringSplitter.m_92364_(bio, 195, Style.f_131099_, true, (style, i, j) -> {
            String string2 = bio.substring(i, j);
            list.add(StringUtils.stripEnd((String)string2, (String)" \n"));
        });
        return list;
    }

    private void renderPrehistoricBio(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        float scale = 0.75f;
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        int right = 0;
        int left = 0;
        int offset = this.currentPage - 1;
        List currentLines = this.currentBio.stream().skip((long)offset * 42L).limit(42L).toList();
        for (int i = 0; i < currentLines.size(); ++i) {
            if (i <= 20) {
                String string = (String)currentLines.get(i);
                int n = this.getScaledX(true, 195, scale);
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_280056_(this.f_96547_, string, n, (int)((float)(this.topPos + 10 + 9 * ++left) / scale), 10321511, false);
                continue;
            }
            String string = (String)currentLines.get(i);
            int n = this.getScaledX(false, 195, scale);
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280056_(this.f_96547_, string, n, (int)((float)(this.topPos + 10 + 9 * ++right) / scale), 10321511, false);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }

    static class DinopediaPageButton
    extends Button {
        private final boolean isForward;

        public DinopediaPageButton(int x, int y, int width, int height, boolean isForward, Button.OnPress onPress) {
            super(x, y, width, height, (Component)Component.m_237113_((String)""), onPress, f_252438_);
            this.isForward = isForward;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280218_(DINOPEDIA_BACKGROUND, this.m_252754_(), this.m_252907_(), this.isForward ? 0 : 34, 223, 34, 30);
        }
    }
}

