/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import java.text.DecimalFormat;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class DebugSlider
extends AbstractSliderButton {
    private final DecimalFormat format;
    private final Component prefix;
    private final Component suffix;
    protected final double stepSize;
    protected final boolean drawString;
    protected double minValue;
    protected double maxValue;

    DebugSlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.f_93577_ = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = Mth.m_14082_((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.m_5695_();
    }

    public double getValue() {
        return this.f_93577_ * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        this.f_93577_ = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.m_5695_();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        super.m_7212_(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.f_93577_ + (double)(f / (float)(this.f_93618_ - 8)), false);
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        this.setSliderValue(this.f_93577_, true);
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.m_252754_() + 4)) / (double)(this.f_93618_ - 8), false);
    }

    public void setSliderValue(double value, boolean force) {
        double oldValue = this.f_93577_;
        this.f_93577_ = this.snapToNearest(value);
        if (force || !Mth.m_14082_((double)oldValue, (double)this.f_93577_)) {
            this.m_5697_();
        }
        this.m_5695_();
    }

    public double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        }
        value = Mth.m_14139_((double)Mth.m_14008_((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? Mth.m_14008_((double)value, (double)this.maxValue, (double)this.minValue) : Mth.m_14008_((double)value, (double)this.minValue, (double)this.maxValue);
        return Mth.m_144914_((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void m_5695_() {
        if (this.drawString) {
            this.m_93666_((Component)Component.m_237113_((String)"").m_7220_(this.prefix).m_130946_(this.getValueString()).m_7220_(this.suffix));
        } else {
            this.m_93666_((Component)Component.m_237113_((String)""));
        }
    }

    protected void m_5697_() {
    }
}

