/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.SyncDebugInfoMessage;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Animal;

public class EmbryoTab
extends DebugTab<Animal> {
    private int hatchingTime;

    protected EmbryoTab(DebugScreen debugScreen, Animal entity) {
        super(debugScreen, entity);
        this.hatchingTime = ModCapabilities.getEmbryoProgress(entity);
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        int yPos = 0;
        DebugSlider hatchingTimeSlider = new DebugSlider(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Embryo time in ticks: "), (Component)Component.m_237113_((String)""), 1.0, FossilConfig.getInt("pregnancyDuration"), this.hatchingTime, 5.0, 0, true){

            @Override
            protected void m_5697_() {
                EmbryoTab.this.hatchingTime = (int)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }
        };
        this.addWidget(hatchingTimeSlider);
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Set Info"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new SyncDebugInfoMessage(((Animal)this.entity).m_19879_(), "", this.hatchingTime, 0, 0, 0, 0, 0))).m_252987_(20, yPos += 30, 150, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Set the info above on the server"))).m_253136_());
    }
}

