/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.entity.PrehistoricSkeleton;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.SyncDebugInfoMessage;
import com.github.teamfossilsarcheology.fossil.util.TimePeriod;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class SkeletonEditTab
extends DebugTab<PrehistoricSkeleton> {
    private final int maxAge;
    private int age;
    private PrehistoricEntityInfo info;

    protected SkeletonEditTab(DebugScreen debugScreen, PrehistoricSkeleton entity) {
        super(debugScreen, entity);
        this.maxAge = entity.data().adultAgeDays();
        this.age = entity.getAge();
        this.info = entity.info();
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        DebugSlider ageSlider = new DebugSlider(20, 30, 150, 20, (Component)Component.m_237113_((String)"Age: "), (Component)Component.m_237113_((String)""), 0.0, this.maxAge, this.age, 1.0, 0, true){

            @Override
            protected void m_5697_() {
                SkeletonEditTab.this.age = (int)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }
        };
        this.addWidget(ageSlider);
        this.addWidget(new ModelsList());
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Set Info"), button -> {
            MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new SyncDebugInfoMessage(((PrehistoricSkeleton)this.entity).m_19879_(), this.info.name(), this.age, 0, 0, 0, 0, 0));
            ageSlider.maxValue = EntityDataLoader.INSTANCE.getData(this.info.resourceName).adultAgeDays();
            this.age = (int)Math.min((double)this.age, ageSlider.maxValue);
            ageSlider.setValue(this.age);
        }).m_252987_(20, 210, 150, 20).m_253136_());
    }

    @Override
    protected void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280430_(this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Age: " + ((PrehistoricSkeleton)this.entity).getAge())), 175, 35, 0xFFFFFF);
        guiGraphics.m_280430_(this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Type: " + ((PrehistoricSkeleton)this.entity).info().name())), 175, 185, 0xFFFFFF);
    }

    private class ModelsList
    extends ContainerObjectSelectionList<ModelEntry> {
        public ModelsList() {
            super(SkeletonEditTab.this.minecraft, 200, SkeletonEditTab.this.height, 60, SkeletonEditTab.this.height, 25);
            List<String> sortedModels = PrehistoricEntityInfo.entitiesWithSkeleton(TimePeriod.values()).stream().map(Enum::name).toList();
            for (String typeName : sortedModels) {
                this.m_7085_((AbstractSelectionList.Entry)new ModelEntry(typeName));
            }
            this.m_93488_(false);
            this.m_93496_(false);
            this.f_93393_ = SkeletonEditTab.this.width - SkeletonEditTab.this.width / 4;
            this.f_93392_ = this.f_93393_ + this.f_93388_;
        }

        protected int m_5756_() {
            return this.f_93393_ + this.f_93388_ - 6;
        }

        private class ModelEntry
        extends ContainerObjectSelectionList.Entry<ModelEntry> {
            private final Button changeButton;

            ModelEntry(String text) {
                this.changeButton = Button.m_253074_((Component)Component.m_237113_((String)text), button -> {
                    SkeletonEditTab.this.info = PrehistoricEntityInfo.valueOf(button.m_6035_().getString());
                }).m_252987_(0, 0, 200, 20).m_253136_();
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return ImmutableList.of((Object)this.changeButton);
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                this.changeButton.m_252865_(left);
                this.changeButton.m_253211_(top);
                this.changeButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }

            @NotNull
            public List<? extends GuiEventListener> m_6702_() {
                return ImmutableList.of((Object)this.changeButton);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return this.changeButton.m_6375_(mouseX, mouseY, button);
            }

            public boolean m_6348_(double mouseX, double mouseY, int button) {
                return this.changeButton.m_6348_(mouseX, mouseY, button);
            }
        }
    }
}

